/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import paraselene.HTMLPart;
import paraselene.PlainText;
import paraselene.dyna.DynamicPage;
import paraselene.dyna.DynamicPageException;
import paraselene.dyna.URIResolver;
import paraselene.mockup.LineSeparator;
import paraselene.mockup.Output;
import paraselene.supervisor.RequestParameter;
import paraselene.tag.Tag;

class MobileData {
    private String name;
    private URL url;
    private File output;
    private ArrayList<String> ip = new ArrayList();
    private String last_ip;

    private String trim(String str) {
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        return str;
    }

    MobileData(String line, String dir) throws MalformedURLException {
        int no;
        String[] str = line.split("\\p{Space}");
        if (str.length < 2) {
            System.out.println("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002");
            System.exit(1);
        }
        for (no = 0; no < str.length; ++no) {
            this.name = this.trim(str[no]);
            if (this.name == null) continue;
            ++no;
            break;
        }
        while (no < str.length) {
            String dmy = this.trim(str[no]);
            if (dmy != null) {
                this.url = new URL(dmy);
                break;
            }
            ++no;
        }
        if (this.name == null || this.url == null) {
            System.out.println("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002");
            System.exit(1);
        }
        Output.mkdir(dir);
        StringBuilder buf = new StringBuilder(dir);
        buf = buf.append(File.separator);
        buf = buf.append(this.name);
        buf = buf.append(".");
        buf = buf.append("mip");
        this.output = new File(buf.toString());
    }

    private void parse_ip(String str) {
        if ((str = str.trim()).isEmpty()) {
            return;
        }
        String[] data = str.split("\\.");
        if (data.length != 4) {
            return;
        }
        StringBuilder buf = new StringBuilder(data[0]);
        for (int i = 1; i < data.length; ++i) {
            buf = buf.append(".");
            buf = buf.append(data[i]);
        }
        this.last_ip = buf.toString();
    }

    private void parse(String str) {
        if ((str = str.trim()).isEmpty()) {
            return;
        }
        if (str.charAt(0) == '/' && this.last_ip != null) {
            this.ip.add(this.last_ip + str);
            this.last_ip = null;
            return;
        }
        String[] ip_mask = str.split("/");
        if (ip_mask.length == 2) {
            this.parse_ip(ip_mask[0]);
            if (this.last_ip == null) {
                return;
            }
            this.ip.add(this.last_ip + "/" + ip_mask[1]);
            this.last_ip = null;
        } else if (ip_mask.length == 1) {
            this.parse_ip(ip_mask[0]);
        }
    }

    private void parse(PlainText text) {
        String str = text.toString();
        if (str == null) {
            return;
        }
        String[] data = str.split("\\p{Space}");
        for (int i = 0; i < data.length; ++i) {
            this.parse(data[i]);
        }
    }

    private void seek(Tag tag) {
        if (tag == null) {
            return;
        }
        Tag[] next = tag.getTagArray();
        for (int i = 0; i < next.length; ++i) {
            this.seek(next[i]);
        }
        int cnt = tag.getHTMLPartCount();
        for (int i = 0; i < cnt; ++i) {
            HTMLPart hp = tag.getHTMLPart(i);
            if (!(hp instanceof PlainText)) continue;
            this.parse((PlainText)hp);
        }
    }

    void get() throws DynamicPageException, IOException {
        DynamicPage page = new DynamicPage(new URIResolver(){

            @Override
            public String resolve(String src) {
                return "";
            }

            @Override
            public boolean isParamURIName(String name) {
                return false;
            }
        }, null);
        System.out.println(this.url.toString() + " >> " + this.output.toString());
        page.create(this.url, RequestParameter.Method.GET, null);
        this.seek(page.getFirstTagByType("body"));
        int cnt = this.ip.size();
        BufferedWriter w = new BufferedWriter(new FileWriter(this.output));
        for (int i = 0; i < cnt; ++i) {
            w.write(this.ip.get(i));
            w.write(LineSeparator.getUse());
        }
        w.close();
    }
}

