/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import paraselene.HTMLPart;
import paraselene.PlainText;
import paraselene.QueryItem;
import paraselene.WebChar;
import paraselene.css.CSSValuable;
import paraselene.mockup.Linker;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageID;
import paraselene.supervisor.Supervisor;
import paraselene.supervisor.TransactionSequencer;
import paraselene.tag.AttributeValuable;

public class URIValue
extends PlainText
implements AttributeValuable,
CSSValuable {
    private static final long serialVersionUID = 21L;
    private static final String DOWNLOAD_DIR = "rabbit/";
    private boolean feedback_f = false;
    public static final String DEFAULT_ENC = "UTF-8";
    private String out_enc = null;

    public boolean isParaselenePagePath() {
        return this.feedback_f;
    }

    private URIValue() {
    }

    private String getCharset() {
        if (this.out_enc != null) {
            return this.out_enc;
        }
        String ret = null;
        ret = this.getAssignedTag().getAssignedPage().getParentPage().getCharset();
        if (ret != null) {
            return ret;
        }
        return DEFAULT_ENC;
    }

    public static String CSSURLStrip(String org_url) {
        if (org_url == null) {
            return null;
        }
        if ((org_url = org_url.trim()).length() < 6) {
            return org_url;
        }
        if (!"url(".equalsIgnoreCase(org_url.substring(0, 4))) {
            return org_url;
        }
        String url = org_url.substring(4).trim();
        int len = url.length();
        if (len < 1) {
            return org_url;
        }
        if (url.charAt(len - 1) != ')') {
            return org_url;
        }
        if ((len = (url = url.substring(1, len)).length()) == 0) {
            return "";
        }
        char[] ch = new char[]{url.charAt(0), url.charAt(len - 1)};
        if (ch[0] == ch[1] && (ch[0] == '\'' || ch[0] == '\"')) {
            url = url.substring(1, len - 1);
        }
        return url;
    }

    public static boolean isCSSURL(String url) {
        if (url == null) {
            return false;
        }
        return !(url = url.trim()).equals(URIValue.CSSURLStrip(url));
    }

    @Override
    public HTMLPart getReplica() {
        try {
            return new URIValue(this.getURI(), DEFAULT_ENC, this.out_enc);
        }
        catch (Exception e) {
            Option.debug(e);
            return null;
        }
    }

    public static String encode(String uri, String enc) throws UnsupportedEncodingException {
        return URIValue.encode(uri, enc, false);
    }

    public static String encode(String uri, String enc, boolean xml_f) throws UnsupportedEncodingException {
        String[] frag;
        uri = URIValue.CSSURLStrip(uri);
        if (enc == null) {
            enc = DEFAULT_ENC;
        }
        if ((frag = uri.split("#")).length == 0) {
            return uri;
        }
        String[] query = frag[0].split("\\?");
        if (query.length == 0) {
            return uri;
        }
        String[] test = query[0].split(":");
        String scheme = null;
        String main_path = test[test.length - 1];
        if (test.length > 1) {
            if (test.length == 2) {
                StringBuilder sc = new StringBuilder(test[0]);
                if (main_path.indexOf("//") == 0) {
                    main_path = main_path.substring(2);
                    sc = sc.append("://");
                } else {
                    sc = sc.append(":");
                }
                scheme = sc.toString();
            } else {
                StringBuilder sc = new StringBuilder();
                for (int i = 0; i < test.length - 1; ++i) {
                    sc = sc.append(test[i]);
                    sc = sc.append(":");
                }
                scheme = sc.toString();
            }
        } else {
            int len = query[0].length();
            if (len > 0 && query[0].charAt(len - 1) == ':') {
                scheme = query[0];
                main_path = "";
            }
        }
        StringBuilder buf = new StringBuilder(" ");
        buf = buf.append(main_path);
        buf = buf.append(" ");
        String[] path = buf.toString().split("/");
        buf = new StringBuilder(URLEncoder.encode(path[0], enc));
        for (int i = 1; i < path.length; ++i) {
            buf = buf.append("/");
            buf = buf.append(URLEncoder.encode(path[i], enc));
        }
        String tmp = buf.toString();
        buf = new StringBuilder(tmp.substring(1, tmp.length() - 1));
        if (query.length > 1) {
            buf = buf.append("?");
            String[] param = query[1].split("&");
            for (int i = 0; i < param.length; ++i) {
                if (i > 0) {
                    buf = buf.append(xml_f ? WebChar._amp.getReference() : "&");
                }
                String[] data = param[i].split("=");
                buf = buf.append(URLEncoder.encode(data[0], enc));
                buf = buf.append("=");
                if (data.length <= 1) continue;
                buf = buf.append(URLEncoder.encode(data[1], enc));
            }
        }
        if (frag.length > 1) {
            buf = buf.append("#");
            buf = buf.append(URLEncoder.encode(frag[1], enc));
        }
        if (scheme != null) {
            StringBuilder full = new StringBuilder(scheme);
            buf = full.append((CharSequence)buf);
        }
        return buf.toString();
    }

    public URIValue(String u, String enc) throws UnsupportedEncodingException, URISyntaxException {
        u = URIValue.CSSURLStrip(u);
        this.setEncode(enc);
        this.setURI(URIValue.makeURI(u, enc), enc);
    }

    public URIValue(String u) throws UnsupportedEncodingException, URISyntaxException {
        this(URIValue.CSSURLStrip(u), null);
    }

    public URIValue(URI u, String dec, String enc) throws UnsupportedEncodingException, URISyntaxException {
        this(URLDecoder.decode(u.toString(), dec), enc);
    }

    public void setURI(URI u, String dec) throws UnsupportedEncodingException {
        if (u == null) {
            this.feedback_f = false;
            this.setText(null);
        } else {
            if (dec == null) {
                dec = DEFAULT_ENC;
            }
            this.setText(URLDecoder.decode(u.toString(), dec));
            this.feedback_f = super.toString(HTMLPart.StringMode.PLAIN).indexOf(TransactionSequencer.LINK_DEF[0]) == 0;
        }
    }

    private static URI makeURI(String uri) {
        return URIValue.makeURI(uri, DEFAULT_ENC);
    }

    private static URI makeURI(String uri, String enc) {
        if ((uri = URIValue.CSSURLStrip(uri)) == null) {
            return null;
        }
        try {
            return new URI(URIValue.encode(uri, enc));
        }
        catch (Exception e) {
            Option.debug(e);
            return null;
        }
    }

    public URI getURI() {
        return URIValue.makeURI(super.toString(HTMLPart.StringMode.PLAIN));
    }

    public QueryItem[] getQuery() {
        String q = super.toString();
        if (q == null) {
            return new QueryItem[0];
        }
        String[] fr = q.split("#");
        if (fr.length == 0) {
            return new QueryItem[0];
        }
        q = fr[0];
        String[] pre = q.split("\\?");
        if (pre.length < 2) {
            return new QueryItem[0];
        }
        String[] str = pre[1].split("&");
        ArrayList<QueryItem> list = new ArrayList<QueryItem>();
        block4: for (int i = 0; i < str.length; ++i) {
            String[] part = str[i].split("=");
            switch (part.length) {
                case 1: {
                    list.add(new QueryItem(part[0]));
                    continue block4;
                }
                case 2: {
                    list.add(new QueryItem(part[0], part[1]));
                }
            }
        }
        return list.toArray(new QueryItem[0]);
    }

    public void setQuery(QueryItem ... query) {
        try {
            this.setText(URIValue.setQuery(this.getURI(), query));
        }
        catch (Exception e) {
            Option.debug(e);
        }
    }

    public static String pageToURI(PageID pid, String fragment, QueryItem ... query) {
        StringBuilder buf = new StringBuilder(TransactionSequencer.LINK_DEF[0]);
        buf = buf.append(pid.getID());
        if (fragment != null) {
            buf = buf.append("#");
            buf = buf.append(fragment);
        }
        try {
            return URIValue.setQuery(URIValue.makeURI(buf.toString(), DEFAULT_ENC), query);
        }
        catch (Exception e) {
            Option.debug(e);
            return null;
        }
    }

    public static String pageToDownloadURI(PageID pid, String filename, QueryItem ... query) {
        StringBuilder buf = new StringBuilder(DOWNLOAD_DIR);
        buf = buf.append(URIValue.pageToURI(pid, null, new QueryItem[0]));
        buf = buf.append("/");
        buf = buf.append(filename);
        try {
            return URIValue.setQuery(URIValue.makeURI(buf.toString(), DEFAULT_ENC), query);
        }
        catch (Exception e) {
            Option.debug(e);
            return null;
        }
    }

    public static String makeAbsolutePath(Scheme prt, int port, String path) {
        StringBuilder buf = new StringBuilder(prt.str);
        if (port == prt.port) {
            port = 0;
        }
        buf = buf.append(port);
        if (path == null) {
            path = "/";
        }
        if (path.charAt(0) != '/') {
            buf = buf.append("/");
        }
        buf = buf.append(path);
        return buf.toString();
    }

    private static String setQuery(URI uri, QueryItem ... q) {
        int port;
        if (q == null) {
            q = new QueryItem[]{};
        }
        StringBuilder buf = new StringBuilder();
        String tmp = uri.getScheme();
        if (tmp != null) {
            buf = buf.append(tmp);
            buf = buf.append("://");
        }
        if ((tmp = uri.getUserInfo()) != null) {
            buf = buf.append(tmp);
            buf = buf.append("@");
        }
        if ((tmp = uri.getHost()) != null) {
            buf = buf.append(tmp);
        }
        if ((port = uri.getPort()) != -1) {
            buf = buf.append(":");
            buf = buf.append(port);
        }
        buf = buf.append(uri.getPath());
        for (int i = 0; i < q.length; ++i) {
            buf = i == 0 ? buf.append("?") : buf.append("&");
            buf = buf.append(q[i].toString());
        }
        tmp = uri.getFragment();
        if (tmp != null) {
            buf = buf.append("#");
            buf = buf.append(tmp);
        }
        try {
            return URLDecoder.decode(buf.toString(), DEFAULT_ENC);
        }
        catch (Exception e) {
            Option.debug(e);
            return null;
        }
    }

    public void setEncode(String enc) throws UnsupportedEncodingException {
        if (enc != null) {
            URLEncoder.encode("\u30c6\u30b9\u30c8", enc);
        }
        this.out_enc = enc;
    }

    private static String toCSS(String uri) {
        if (uri == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("url(");
        buf = buf.append(uri);
        buf = buf.append(")");
        return buf.toString();
    }

    @Override
    public String toString(HTMLPart.StringMode mode) {
        String ret = super.toString(HTMLPart.StringMode.PLAIN);
        if (mode == HTMLPart.StringMode.PLAIN) {
            return ret;
        }
        try {
            ret = Linker.flag ? URIValue.encode(ret, this.getCharset()) : Supervisor.makeWithSessionURI(ret, this.getCharset(), this.getAssignedTag());
        }
        catch (Exception e) {
            Option.debug(e);
        }
        if (mode == HTMLPart.StringMode.CSS) {
            ret = URIValue.toCSS(ret);
        }
        return ret;
    }

    public static enum Scheme {
        HTTP(TransactionSequencer.LINK_DEF[1], "http", 80),
        HTTPS(TransactionSequencer.LINK_DEF[2], "https", 443);

        private static final long serialVersionUID = 1L;
        String str;
        String prot;
        int port;

        private Scheme(String s, String p, int pt) {
            this.str = s;
            this.prot = p;
            this.port = pt;
        }

        private boolean equalsString(String o) {
            return this.prot.equalsIgnoreCase(o);
        }

        public static Scheme getScheme(URI uri) {
            Scheme[] s = Scheme.values();
            String p = uri.getScheme();
            for (int i = 0; i < s.length; ++i) {
                if (!s[i].equalsString(p)) continue;
                return s[i];
            }
            return null;
        }
    }
}

