/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import paraselene.EphemeralPage;
import paraselene.Page;
import paraselene.ajax.Ajax;
import paraselene.ajax.data.Exec;
import paraselene.ajax.data.PostBack;
import paraselene.supervisor.AjaxForward;
import paraselene.supervisor.CallStack;
import paraselene.supervisor.Child;
import paraselene.supervisor.Closure;
import paraselene.supervisor.EphemeralClosure;
import paraselene.supervisor.EphemeralPosition;
import paraselene.supervisor.Forward;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageID;
import paraselene.supervisor.SandBox;
import paraselene.tag.Tag;
import paraselene.ui.PageBypassedDiv;

public class History
implements Serializable {
    private static final long serialVersionUID = 2L;
    private ArrayList<Page> hist = new ArrayList();
    private int histry_no;
    private ReentrantLock lock = new ReentrantLock();
    private ArrayList<Page> popup = new ArrayList();
    volatile boolean drop_f = false;
    volatile String session_id;
    private transient LinkedList<CallStack> callstack = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callStack(Child base, Page call, EphemeralPosition p, Tag hint) {
        Option.trace("callStack:%s %s", base, call.getID());
        LinkedList<CallStack> linkedList = this.callstack;
        synchronized (linkedList) {
            this.callstack.push(new CallStack(base, call, p, hint));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object popStack(Child base) {
        LinkedList<CallStack> linkedList = this.callstack;
        synchronized (linkedList) {
            while (this.callstack.size() > 0) {
                CallStack cs = this.callstack.pop();
                if (cs.isMyself(base)) {
                    Object ret = cs.result;
                    if (ret == null) {
                        return EphemeralPage.NO_ANSWER;
                    }
                    return ret;
                }
                if (cs.child == null) continue;
                Child child = cs.child;
                synchronized (child) {
                    this.unlock();
                    cs.child.notifyAll();
                }
            }
        }
        return EphemeralPage.ABORT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deadStack(Page p) {
        if (this.hist.contains(p)) {
            return;
        }
        Option.traceWithStack("deadStack: %s", p.getID());
        LinkedList<CallStack> linkedList = this.callstack;
        synchronized (linkedList) {
            CallStack cs;
            boolean flag = false;
            Iterator i$ = this.callstack.iterator();
            while (i$.hasNext() && !(flag = (cs = (CallStack)i$.next()).isMyself(p))) {
            }
            if (!flag) {
                return;
            }
            while (this.callstack.size() > 0) {
                CallStack cs2 = this.callstack.pop();
                flag = cs2.isMyself(p);
                if (cs2.child == null) continue;
                Child child = cs2.child;
                synchronized (child) {
                    this.unlock();
                    cs2.child.notifyAll();
                }
                if (!flag) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Child continueStack(Page p, Object result) {
        Option.traceWithStack("continueStack:%s / return %s", p.getID(), result);
        LinkedList<CallStack> linkedList = this.callstack;
        synchronized (linkedList) {
            CallStack cs;
            boolean flag = false;
            Iterator i$ = this.callstack.iterator();
            while (i$.hasNext() && !(flag = (cs = (CallStack)i$.next()).isMyself(p))) {
            }
            if (!flag) {
                Option.trace("continueStack null return", new Object[0]);
                return null;
            }
            while (this.callstack.size() > 0) {
                CallStack cs2 = this.callstack.pop();
                if (cs2.child == null) continue;
                if (cs2.isMyself(p)) {
                    cs2.result = result;
                    this.callstack.push(cs2);
                    return cs2.child;
                }
                Child child = cs2.child;
                synchronized (child) {
                    this.unlock();
                    cs2.child.notifyAll();
                }
            }
        }
        Option.trace("continueStack null return", new Object[0]);
        return null;
    }

    private Forward returnStack(Closure fw) throws Throwable {
        Page page = fw.close_page;
        Object result = fw instanceof EphemeralClosure ? ((EphemeralClosure)fw).result_data : null;
        Child child = this.continueStack(page, result);
        if (child != null) {
            return Forward.merge(fw, SandBox.input_sub(child, false, this));
        }
        return fw;
    }

    Forward returnStack(Forward fw, boolean call_f) throws Throwable {
        if (this.callstack == null) {
            this.callstack = new LinkedList();
        }
        if (call_f && fw instanceof Closure) {
            return this.returnStack((Closure)fw);
        }
        if (fw.isAjaxHold()) {
            ArrayList<Forward> list = new ArrayList<Forward>();
            for (AjaxForward af : fw.getAjaxForward(true)) {
                list.add((Forward)((Object)af));
                if (!(af instanceof Closure)) continue;
                list.add(this.returnStack((Closure)af, call_f));
            }
            return Forward.merge(list.toArray(new Forward[0]));
        }
        return fw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Forward getStackForward(Child c) {
        LinkedList<CallStack> linkedList = this.callstack;
        synchronized (linkedList) {
            for (CallStack cs : this.callstack) {
                if (!cs.isMyself(c)) continue;
                return cs.fw;
            }
        }
        return null;
    }

    private void comet_stop(Page p) {
        StringBuilder buf = new StringBuilder("paraselene.comet_stop('");
        buf = buf.append(p.getUniqueKey());
        buf = buf.append("');");
        Ajax.addComet(this.session_id, new PostBack(new Exec(buf.toString())));
    }

    boolean tryLock() {
        if (this.lock.isHeldByCurrentThread()) {
            return true;
        }
        Option.trace("call tryLock ", new Object[0]);
        boolean ret = this.lock.tryLock();
        Option.trace("tryLock %s ", new Object[]{ret});
        return ret;
    }

    void lock() {
        if (this.lock.isHeldByCurrentThread()) {
            return;
        }
        Option.trace("call lock ", new Object[0]);
        this.lock.lock();
        Option.trace("locked ", new Object[0]);
    }

    void unlock() {
        if (!this.lock.isHeldByCurrentThread()) {
            return;
        }
        Option.trace("call unlock ", new Object[0]);
        this.lock.unlock();
        Option.trace("unlocked ", new Object[0]);
    }

    private History() {
    }

    History(int n, String s) {
        this();
        this.histry_no = n;
        this.session_id = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSatellitePage(Page page) {
        if (page == null) {
            return;
        }
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            String key = page.getUniqueKey();
            for (Page p : this.popup) {
                if (!p.getUniqueKey().equals(key)) continue;
                return;
            }
            this.setInfo(page);
            this.popup.add(page);
        }
        Option.trace("addSatellitePage %d %s", this.hashCode(), page.getUniqueKey());
    }

    private void initSatellitePage(Page parent) {
        if (parent == null) {
            return;
        }
        PageBypassedDiv[] div = parent.getPageBypassedDiv();
        for (int i = 0; i < div.length; ++i) {
            this.initSatellitePage(div[i].getBypassPage());
        }
        if (parent != parent.getParentPage()) {
            this.addSatellitePage(parent);
        }
    }

    public void removeSatellitePage(Page page) {
        if (page == null) {
            return;
        }
        if (page.getAjaxSupport() == Page.AjaxSupport.SERVER_PUSH) {
            this.comet_stop(page);
        }
        this.removePopup(page);
    }

    private boolean addPopup(Page page) {
        if (page.getPopupType() == null) {
            return false;
        }
        this.addSatellitePage(page);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePopup(Page page) {
        String key = page.getUniqueKey();
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            int cnt = this.popup.size();
            for (int i = 0; i < cnt; ++i) {
                if (!this.popup.get(i).getUniqueKey().equals(key)) continue;
                this.deadStack(this.popup.remove(i));
                Option.trace("removePopup %s", key);
                return;
            }
        }
        Option.trace("donot remove, not found %s", key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPopup() {
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            for (Page p : this.popup) {
                this.deadStack(p);
            }
            this.popup.clear();
            Option.traceWithStack("popup clear", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Page page) {
        if (page == null) {
            return;
        }
        if (this.addPopup(page = page.getParentPage())) {
            return;
        }
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            Page old = null;
            if (cnt > 0) {
                old = this.getPage();
            }
            if (page.isHistoryClear()) {
                for (int i = 0; i < cnt; ++i) {
                    Page h = this.hist.get(i);
                    if (!page.equals(h)) continue;
                    for (int j = cnt - 1; j >= i; --j) {
                        Page tmp = this.hist.remove(j);
                        tmp.setHistoryKey(0);
                        if (page == tmp) continue;
                        this.deadStack(tmp);
                    }
                    break;
                }
            }
            if (page.isAllowHistoryAdd()) {
                this.setInfo(page);
                this.hist.add(page);
                page.setHistoryKey(this.histry_no);
            }
            if ((cnt = this.getHistoryCount()) == 0 || old != this.getPage()) {
                if (cnt > 0 && old != null) {
                    Option.trace(String.format("old=%s(%s) / new=%s(%s)", old.getID().toString(), old.getUniqueKey(), this.getPage().getID().toString(), this.getPage().getUniqueKey()), new Object[0]);
                }
                this.clearPopup();
                this.initSatellitePage(this.getPage());
            }
        }
    }

    private void setInfo(Page page) {
        if (page.getPageServerInformation() != null) {
            return;
        }
        Page old = this.getPage();
        if (old == null) {
            return;
        }
        page.setPageServerInformation(old.getPageServerInformation());
    }

    public int getHistoryCount() {
        return this.hist.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page[] getAllPage(PageID id) {
        if (id == null) {
            return new Page[0];
        }
        ArrayList<Page> list = new ArrayList<Page>();
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = 0; i < cnt; ++i) {
                Page h = this.hist.get(i);
                if (!h.equals(id)) continue;
                int hld = list.size();
                boolean flag = true;
                for (int j = 0; j < hld; ++j) {
                    if (((Page)list.get(j)).getUniqueKey() != h.getUniqueKey()) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                list.add(h);
            }
        }
        return list.toArray(new Page[0]);
    }

    public Page getPage(PageID id) {
        Page[] p = this.getAllPage(id);
        if (p.length == 0) {
            return null;
        }
        return p[p.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page[] getBrowsingPage() {
        ArrayList<Page> list = new ArrayList<Page>();
        this.lock();
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            int cnt = this.popup.size();
            for (int i = 0; i < cnt; ++i) {
                list.add(this.popup.get(i));
            }
        }
        Page p = this.getPage();
        if (p != null) {
            list.add(p);
        }
        return list.toArray(new Page[0]);
    }

    private Page[] getBrowsingPage(Page page, PageID ... id) {
        Page[] dmy = new Page[]{};
        if (page == null) {
            return dmy;
        }
        ArrayList<Page> list = new ArrayList<Page>();
        PageID pid = page.getID();
        for (PageID pageID : id) {
            if (pid.getID() != pageID.getID()) continue;
            list.add(page);
            break;
        }
        for (Serializable serializable : page.getPageBypassedDiv()) {
            for (Page b : this.getBrowsingPage(((PageBypassedDiv)serializable).getBypassPage(), id)) {
                list.add(b);
            }
        }
        return list.toArray(dmy);
    }

    public Page[] getBrowsingPage(PageID ... id) {
        ArrayList<Page> list = new ArrayList<Page>();
        for (Page p : this.getBrowsingPage()) {
            for (Page p2 : this.getBrowsingPage(p, id)) {
                this.initSatellitePage(p2);
                list.add(p2);
            }
        }
        return list.toArray(new Page[0]);
    }

    public Page getBrowsingPage(String uni) {
        Option.trace("getBrowsingPage  %d >> %s", this.hashCode(), uni);
        Page page = null;
        for (Page p : this.getBrowsingPage()) {
            if (p.getUniqueKey().equals(uni)) {
                return p;
            }
            if ((p = p.getBypassPage(uni)) == null) continue;
            this.initSatellitePage(page);
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(int last_no) {
        if (last_no < 0) {
            return;
        }
        if (last_no == 0) {
            this.clearPopup();
        }
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = cnt - 1; i >= 0; --i) {
                if (last_no == 0) {
                    Page old = this.hist.remove(i);
                    old.setHistoryKey(0);
                    this.deadStack(old);
                    return;
                }
                --last_no;
            }
        }
        if (last_no == 0) {
            this.initSatellitePage(this.getPage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(PageID page_id) {
        boolean init_f = false;
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = cnt - 1; i >= 0; --i) {
                Page page = this.hist.get(i);
                if (page.getID() != page_id) continue;
                Page old = this.hist.remove(i);
                old.setHistoryKey(0);
                this.deadStack(old);
                if (i != cnt - 1) continue;
                this.clearPopup();
                init_f = true;
            }
        }
        if (init_f) {
            this.initSatellitePage(this.getPage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage() {
        this.clearPopup();
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = 0; i < cnt; ++i) {
                Page old = this.hist.get(i);
                old.setHistoryKey(0);
                this.deadStack(old);
            }
            this.hist.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(int last_no) {
        if (last_no < 0) {
            return null;
        }
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = cnt - 1; i >= 0; --i) {
                if (last_no == 0) {
                    return this.hist.get(i);
                }
                --last_no;
            }
        }
        return null;
    }

    public Page getPage() {
        return this.getPage(0);
    }
}

