/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;


/**
 * ダイアログ種別を表す。
 */
public interface DialogType {
	/**
	 * ダイアログ表示位置。
	 */
	public enum Position {
		/**
		 * 無指定。
		 */
		CENTER,
		/**
		 * 指定タグの上部に表示。
		 */
		UP,
		/**
		 * 指定タグの下部に表示。
		 */
		DOWN,
		/**
		 * 指定タグの左部に表示。
		 */
		LEFT,
		/**
		 * 指定タグの右部に表示。
		 */
		RIGHT;
	}

	/**
	 * タイトルバーの有無。
	 * @return true:存在する、false:存在しない。
	 */
	public boolean isTitle();
	/**
	 * モーダルであるか？
	 * @return true:モーダル、false:モードレス。
	 */
	public boolean isMode();
	/**
	 * 自動クローズであるか？<br>
	 * これがtrueであれば、ダイアログ範囲外をクリックすると、
	 * ダイアログが自動的に閉じます。<br>
	 * ブラウザに表示された時、背景が黒であれば自動クローズしません。
	 * @return true:自動クローズする、false:自動クローズしない。
	 */
	public boolean isAutoClose();
	/**
	 * 表示位置の取得。
	 * @return 表示位置。
	 */
	public Position getPosition();
}

