/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import paraselene.*;
import paraselene.tag.*;

/**
 * {@link Closure}の機能と同じですが、{@link paraselene.EphemeralPage}呼び出し時の
 * 戻り値を指定する事ができます。
 */
public class EphemeralClosure extends Closure {
	private static final long serialVersionUID = 2L;
	Object result_data;

	private EphemeralClosure(){}
	/**
	 * コンストラクタ。
	 * @param result 戻り値の指定。
	 */
	public EphemeralClosure( Object result ) {
		super();
		result_data = result;
	}
}

class EphemeralPopup extends Popup {
	private static final long serialVersionUID = 2L;
	private Tag	hint;
	EphemeralPopup( Page dlg, EphemeralPosition p, Tag h ) {
		super( dlg, p );
		hint = h;
		if ( hint != null )	hint.makeID();
	}

	Tag getHint() {
		return hint;
	}

	public String toString() {
		StringBuilder	buf = new StringBuilder( "EphemeralPopup:" );
		return buf.append( super.toString() ).toString();
	}
}

