/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import paraselene.*;

/**
 * 遷移先指定。何も更新を行いません。後続のoutput() も呼ばれません。<br>
 * Ajax 機能が無効な場合、{@link Feedback}と同じ動作となります。
 */
public class NOP extends Feedback {
	private static final long serialVersionUID = 2L;

	/**
	 * コンストラクタ。
	 */
	public NOP() {
		super();
	}

	public String toString() {
		return "NOP: ...";
	}

	public boolean equals( Object o ) {
		return false;
	}

	OutputCall makeOutput( PageFactory pf, int nk, Page lp, RequestParameter r, SessionData sd ) {
		Option.trace( "new NopOutput <- %s", this );
		return new NopOutput( pf, nk, lp, this, r, sd );
	}

	CometCall makeCometCall( PageFactory pf, History h ) {
		Option.trace( "new NopCometCall <- %s", this );
		return new NopCometCall( pf, h, this );
	}
}

