/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;


import java.util.*;
import java.io.*;
import java.net.*;
import java.math.*;
import javax.servlet.*;
import javax.servlet.http.*;
import paraselene.*;
import paraselene.test.*;
import paraselene.tag.*;
import paraselene.tag.form.*;

class PathData {
	boolean	called = false;
	Page	from = null;
	Page	to = null;
	Page	redirect = null;
	Integer	from_histry = null;
	Integer	to_histry = null;
}

class Null extends NullPage {
	public Forward input( RequestParameter req, Forward fw ) throws PageException{
		return null;
	}
}

/**
 * トランザクションシーケンサ。
 * URIの生成と解析を司ります。
 */
public class TransactionSequencer implements Serializable {
	private static final long serialVersionUID = 2L;

	static final String[] SELENE = new String[] {
		"lu",	// 0: リクエストID
		"mo",	// 1: 遷移元ページ
		"on",	// 2: 遷移先ページ
		"na",	// 3: 固定拡張子
		"art",	// 4: 遷移元履歴キー
		"mis",	// 5: 遷移先履歴キー
		"dia",	// 6: alias
	};
	/**
	 * Paraselene拡張子。
	 */
	public static final String EXTENSION = "." + SELENE[3];
	/**
	 * Paraselene 仮URL。
	 */
	public static final String[] LINK_DEF = new String[] {
		"PARASELENE(PAGE)", "PARASELENE(HTTP)", "PARASELENE(HTTPS)"
	};
	private volatile int seq_no = 0;
	private HashMap<Integer,Boolean>	no_map = new HashMap<Integer,Boolean>();
	private static final String[] HEAD = { "seleno", "lilith" };
	private static final int HEAD_LENGTH = 6;

	TransactionSequencer() {
	}

	private int newNo( PageID id ) {
		long	dt = (new Date().getTime() / 1000) & 0x7fffff;
		int		ret = (int)(dt << 8);
		synchronized( this ) {
			ret |= (seq_no & 0xff);
			seq_no += (int)(Math.random() * 5);
			no_map.put( ret, false );
		}
		return ret;
	}

	/**
	 * URIの生成。
	 * @param seq シーケンサ。nullなら通番発行しない。
	 * @param from 遷移元ページ。null可。
	 * @param to 遷移先ページ。null不可。
	 * @param from_key 遷移元キー。
	 * @param to_key 遷移先キー。
	 * @param flag true:通常、false:検索エンジン。
	 * @return URI。
	 */
	public static String makeURI( TransactionSequencer seq, PageID from, PageID to, int from_key, int to_key, boolean flag ) {
		StringBuilder	buf = new StringBuilder();
		if ( flag && seq != null ) {
			buf = buf.append( SELENE[0] );
			buf = buf.append( "." );
			buf = buf.append( HEAD[0] );
			buf = buf.append( Integer.toString( seq.newNo( to ), Character.MAX_RADIX ) );
			buf = buf.append( "." );
		}
		if ( from != null ) {
			buf = buf.append( SELENE[1] );
			buf = buf.append( "." );
			buf = buf.append( Integer.toString( from.getID(), Character.MAX_RADIX ) );
			buf = buf.append( "." );
			if ( flag && from_key != HistorySet.ROOT ) {
				buf = buf.append( SELENE[4] );
				buf = buf.append( "." );
				buf = buf.append( Integer.toString( from_key, Character.MAX_RADIX ) );
				buf = buf.append( "." );
			}
		}
		if ( flag && to_key != HistorySet.ROOT ) {
			buf = buf.append( SELENE[5] );
			buf = buf.append( "." );
			buf = buf.append( Integer.toString( to_key, Character.MAX_RADIX ) );
			buf = buf.append( "." );
		}
		buf = buf.append( SELENE[2] );
		buf = buf.append( "." );
		buf = buf.append( Integer.toString( to.getID(), Character.MAX_RADIX ) );
		buf = buf.append( "." );
		buf = buf.append( SELENE[3] );
		return buf.toString();
	}

	static String makeRedirectURI( TransactionSequencer seq, PageID to ) {
		StringBuilder	buf = new StringBuilder();
		buf = buf.append( SELENE[0] );
		buf = buf.append( "." );
		buf = buf.append( HEAD[1] );
		buf = buf.append( Integer.toString( seq.newNo( null ), Character.MAX_RADIX ) );
		buf = buf.append( "." );
		buf = buf.append( SELENE[2] );
		buf = buf.append( "." );
		buf = buf.append( Integer.toString( to.getID(), Character.MAX_RADIX ) );
		buf = buf.append( "." );
		buf = buf.append( SELENE[3] );
		return buf.toString();
	}

	private static Page getPage( String no, PageFactory fact ) {
		Page	ret = null;
		try {
			ret = fact.getPage( Integer.parseInt( no, Character.MAX_RADIX ) );
		}
		catch( Exception e ) {}
		if ( ret == null )	return new Null();
		return ret;
	}

	static PathData parsePath( TransactionSequencer seq, String uri, PageFactory fact, HistorySet hset ) throws ParaseleneException {
		String[]	path = uri.split( "[\\?;]" );
		if ( path != null )	uri = path[0];
		Option.trace( uri );
		path = uri.split( "/" );
		for ( int i = path.length - 1; i >= 0; i-- ) {
			String[]	body = path[i].split( "\\." );
			if ( body.length == 0 )	continue;
			if ( !SELENE[3].equals( body[body.length - 1] ) )	continue;
			PathData	ret = new PathData();
			int	cnt = body.length - 1;
			boolean	redirect_f = false;
			boolean	request_id = false;
			for ( int j = 0; j < cnt; j += 2 ) {
				if ( seq != null && SELENE[0].equals( body[j] ) ) {
					if ( body[j + 1].length() <= HEAD_LENGTH )	return null;
					String	head = body[j + 1].substring( 0, HEAD_LENGTH );
					String	number = body[j + 1].substring( HEAD_LENGTH );
					if ( HEAD[1].equals( head ) )	redirect_f = true;
					else if ( !HEAD[0].equals( head ) ) {
						return null;
					}
					int	no = Integer.parseInt( number, Character.MAX_RADIX );
					synchronized( seq ) {
						Boolean	flag = seq.no_map.get( no );
						if ( flag == null )	return null;
						request_id = true;
						ret.called = flag;
						seq.no_map.put( no, true );
					}
				}
				else if ( SELENE[1].equals( body[j] ) ) {
					ret.from = getPage( body[j + 1], fact );
				}
				else if ( SELENE[2].equals( body[j] ) ) {
					if ( redirect_f ) {
						ret.redirect = getPage( body[j + 1], fact );
					}
					else {
						ret.to = getPage( body[j + 1], fact );
					}
				}
				else if ( SELENE[4].equals( body[j] ) ) {
					ret.from_histry = Integer.parseInt( body[j + 1], Character.MAX_RADIX );
				}
				else if ( SELENE[5].equals( body[j] ) ) {
					ret.to_histry = Integer.parseInt( body[j + 1], Character.MAX_RADIX );
					if ( hset != null && ret.to_histry == HistorySet.RAND ) {
						ret.to_histry = hset.toInt();
					}
				}
			}
			if ( ret.from != null ) {
				Page	out = ret.to;
				if ( out == null )	out = ret.redirect;
				if ( out != null ) {
					if ( seq != null && out.isCheckRepeatSameRequest() && !request_id ) {
						return null;
					}
				}
			}
			return ret;
		}
		return null;
	}

	static boolean isMustSession( String uri ) {
		String[]	path = uri.split( "\\?" );
		uri = path[0];
		path = uri.split( "/" );
		for ( int i = path.length -1; i >= 0; i-- ) {
			String[]	body = path[i].split( "\\." );
			if ( body.length == 0 )	continue;
			if ( !SELENE[3].equals( body[body.length - 1] ) )	continue;
			int	cnt = body.length - 1;
			for ( int j = 0; j < cnt; j += 2 ) {
				if ( SELENE[0].equals( body[j] ) )	return true;
				if ( SELENE[1].equals( body[j] ) )	return true;
			}
			return false;
		}
		return false;
	}

	private static class MSS extends TestSession {
		private volatile boolean init_f = true;
		private HttpSession origin;
		private String	top_id = ((Integer)new Date().hashCode()).toString();
		private MSS( HttpSession org ) {
			super();
			origin = org;
		}
		public long getLastAccessedTime() throws IllegalStateException {
			return origin.getLastAccessedTime();
		}
		public ServletContext getServletContext() {
			return origin.getServletContext();
		}
		public void setMaxInactiveInterval( int interval ) {
			origin.setMaxInactiveInterval( interval );
		}
		public int getMaxInactiveInterval() {
			return origin.getMaxInactiveInterval();
		}
		public boolean isNew() throws IllegalStateException {
			return init_f;
		}
		public void invalidate() throws IllegalStateException {
			init_f = true;
			super.invalidate();
		}
		public String getId() throws IllegalStateException {
			return new BigInteger(
				new StringBuilder( top_id ).append( super.getId() ).toString()
			).toString( Character.MAX_RADIX );
		}

		private Object[] toArray() {
			ArrayList<Object>	list = new ArrayList<Object>();
			for ( Enumeration<?> e = getAttributeNames(); e.hasMoreElements();) {
				list.add( getAttribute( (String)e.nextElement() ) );
			}
			return list.toArray( new Object[0] );
		}
		private void unbound( HttpSessionBindingEvent event ) {
			for ( Object o: toArray() ) {
				if ( o instanceof HttpSessionBindingListener ) {
					((HttpSessionBindingListener)o).valueUnbound( event );
				}
			}
		}
		private void passivate( HttpSessionEvent se ) {
			for ( Object o: toArray() ) {
				if ( o instanceof HttpSessionActivationListener ) {
					((HttpSessionActivationListener)o).sessionWillPassivate( se );
				}
			}
		}
		private void activate( HttpSessionEvent se ) {
			for ( Object o: toArray() ) {
				if ( o instanceof HttpSessionActivationListener ) {
					((HttpSessionActivationListener)o).sessionDidActivate( se );
				}
			}
		}
	}

	private static class MSSHolder
	implements HttpSessionBindingListener, HttpSessionActivationListener {
		private static final String MSS_KEY = "paraselene.multistage.session";
		private static MSSHolder getHolder( HttpSession org ) {
			MSSHolder	holder = (MSSHolder)org.getAttribute( MSS_KEY );
			if ( holder == null ) {
				holder = new MSSHolder();
				org.setAttribute( MSS_KEY, holder );
			}
			return holder;
		}
		private static void replaceHolder( HttpSession org, MSSHolder holder ) {
			org.setAttribute( MSS_KEY, holder );
		}

		private volatile boolean replace_flag = false;
		private HashMap<String, MSS>	map = new HashMap<String, MSS>();
		private MSSHolder(){}
		private String makeSession( HttpSession org ) {
			MSS	mss = new MSS( org );
			String	id = mss.getId();
			map.put( id, mss );
			return id;
		}
		private boolean isSession( String id ) {
			return map.get( id ) != null;
		}
		private MSS getSession( String id, boolean flag ) {
			MSS	mss = map.get( id );
			if ( mss == null )	return null;
			if ( flag ) {
				mss.init_f = false;
				mss.reset();
			}
			if ( mss.init_f )	return null;
			return mss;
		}

		private MSS[] toArray() {
			ArrayList<MSS>	list = new ArrayList<MSS>();
			for ( String key: map.keySet() ) {
				list.add( map.get( key ) );
			}
			return list.toArray( new MSS[0] );
		}
		public void valueBound( HttpSessionBindingEvent event ){}
		public void valueUnbound( HttpSessionBindingEvent event ) {
			if ( replace_flag )	return;
			for ( MSS mss: toArray() ) {
				mss.unbound( event );
			}
		}
		public void sessionWillPassivate( HttpSessionEvent se ) {
			if ( replace_flag )	return;
			for ( MSS mss: toArray() ) {
				mss.passivate( se );
			}
		}
		public void sessionDidActivate( HttpSessionEvent se ) {
			if ( replace_flag )	return;
			for ( MSS mss: toArray() ) {
				mss.activate( se );
			}
		}
	}

	static final String SESSION_DIR = "mss.";
	private static final int SESSION_DIR_LEN = SESSION_DIR.length();

	static String getMSS( HttpServletRequest req ) {
		for ( String path: req.getRequestURI().split( "/" ) ) {
			if ( path.indexOf( SESSION_DIR ) == 0 ) {
				if ( path.equals( SESSION_DIR ) )	continue;
				return path.substring( SESSION_DIR_LEN );
			}
		}
		return null;
	}

	private static final int EXT_LEN = EXTENSION.length();

	static String rewritePath( String org_path, ServerInformation info ) {
		if ( info.getMultiStageSessionID() == null )	return org_path;
		try {
			if ( new URI( org_path ).isAbsolute() )	return org_path;
			if ( org_path.charAt( 0 ) == '/' )	return org_path;
			for ( String part: org_path.split( "/" ) ) {
				part = part.split( "\\?" )[0];
				int	len = part.length();
				if ( len < EXT_LEN )	continue;
				if ( EXTENSION.equals( part.substring( len - EXT_LEN ) ) )	return org_path;
			}
			return new StringBuilder( "../" ).append( org_path ).toString();
		}
		catch( URISyntaxException e ) {}
		return org_path;
	}

	static String makeNewMSSPath( boolean ms_flag, HttpServletRequest req ) {
		if ( !ms_flag )	return null;
		HttpSession	org = req.getSession( true );
		String	id = getMSS( req );
		if ( id != null ) {
			if ( MSSHolder.getHolder( org ).isSession( id ) )	return null;
			Option.trace( "MSS not found[id=%s]", id );
		}
		id = MSSHolder.getHolder( org ).makeSession( org );
		Option.trace( "MSS residect[id=%s]", id );
		String[]	path = req.getRequestURI().split( "/" );
		StringBuilder	buf = new StringBuilder();
		int	cnt = path.length - 1;
		for ( int i = 0; i < cnt; i++ ) {
			if ( path[i].indexOf( SESSION_DIR ) == 0 )	continue;
			buf = buf.append( path[i] ).append( "/" );
		}
		buf = buf.append( SESSION_DIR ).append( id ).append( "/" ).append( path[cnt] );
		String	query = req.getQueryString();
		if ( query != null ) {
			buf = buf.append( "?" ).append( query );
		}
		return buf.toString();
	}

	static HttpSession getOriginSession( boolean ms_flag, HttpServletRequest req, boolean session_flag ) {
		HttpSession	origin = req.getSession( session_flag );
		if ( ms_flag == false || origin == null )	return origin;
		String	id = getMSS( req );
		if ( id == null )	return null;
		MSSHolder	holder = MSSHolder.getHolder( origin );
		if ( holder == null )	return null;
		origin = holder.getSession( id, session_flag );
		return origin;
	}

	static void replaceSession( HttpServletRequest req ) {
		HttpSession	origin = req.getSession( true );
		MSSHolder	holder = MSSHolder.getHolder( origin );
		holder.replace_flag = true;
		origin.invalidate();
		origin = req.getSession( true );
		MSSHolder.replaceHolder( origin, holder );
		holder.replace_flag = false;
		return;
	}
}

