/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.form;

import paraselene.*;
import paraselene.tag.*;
import paraselene.supervisor.*;
import paraselene.ui.*;

/**
 * BUTTONタグ。
 */
public class GPButton extends Control implements PageHooker, Clickable {
	private static final long serialVersionUID = 1L;
	private static final String NAME = "button";
	private static final String TYPE = "type";

	private boolean pushed = false;
	/**
	 * ボタンの種類。
	 */
	public enum Type {
		SUBMIT( Input.Type.SUBMIT ),
		RESET( Input.Type.RESET ),
		BUTTON( Input.Type.BUTTON );
		Input.Type	type;
		private Type( Input.Type t ) { type = t; }
		String getType() { return type.str; }
	}

	/**
	 * コンストラクタ。
	 */
	public GPButton() {
		super( NAME, false );
	}

	/**
	 * コンストラクタ。
	 * @param t ボタンの種類。
	 */
	public GPButton( Type t ) {
		this();
		setAttribute( TYPE, t.getType() );
	}

	protected Tag newReplica() {
		return copy4Replica( new GPButton() );
	}

	/**
	 * 値の設定。タグ内部ではなく、value属性値に設定します。
	 * @param v 設定値。
	 */
	public void setValueString( String v ) {
		setValueAttribute( v );
	}

	/**
	 * 値の取得。タグ内部ではなく、value属性値から取得します。
	 * @return 文字列。
	 */
	public String getValueString() {
		return getValueAttribute();
	}

	/**
	 * ボタン押下状態の解除。<br>
	 * setClicked( false ) と等価です。
	 */
	public void resetClicked() {
		setClicked( false );
	}

	public boolean isClicked( RequestParameter req ) {
		return Button.isClicked( req, this );
	}

	public boolean isClicked() {
		return pushed;
	}

	public void setClicked( boolean flag ) {
		pushed = flag;
	}

	public Forward beforeInput( Page page, RequestParameter req, Forward fw ) throws Exception {
		return fw;
	}

	public void afterOutput( Page from, Page to, RequestParameter req ) throws Exception {
		commitDaemon();
	}

	public void commitDaemon() {
		Button.setHandler( this );
	}
}

