/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.ruby;


import paraselene.tag.*;

/**
 * RUBY タグ。
 */
public class Ruby extends Tag {
	private static final long serialVersionUID = 1L;
	private static final String NAME = "ruby";

	/**
	 * コンストラクタ。
	 */
	public Ruby() {
		super( NAME, false );
	}

	/**
	 * コンストラクタ。
	 * ルビに対応していないブラウザでは"base(text)"と表示されます。
	 * @param base ルビを振る対象。
	 * @param text ルビ。
	 */
	public Ruby( String base, String text ) {
		this();
		setRuby( base, text );
	}

	protected Tag newReplica() {
		return new Ruby();
	}

	/**
	 * 単純型ルビを作成します。
	 * ルビに対応していないブラウザでは"base(text)"と表示されます。
	 * @param base ルビを振る対象。
	 * @param text ルビ。
	 */
	public void setRuby( String base, String text ) {
		removeHTMLPart();
		addHTMLPart(
			new RubyText( RubyText.Type.BASE, base ),
			new RubyText( RubyText.Type.PARENTHESES, "(" ),
			new RubyText( RubyText.Type.TEXT, text ),
			new RubyText( RubyText.Type.PARENTHESES, ")" )
		);
	}

}

