import java.io.*;


public class Comp {
	public static void main( String[] argv ) throws Exception {
		boolean	debug_f = false;
		if ( argv.length > 2 ) {
			debug_f = argv[2].equals( "-debug" );
		}
		File[]	file = new File[]{
			new File( argv[0] ), new File( argv[1] )
		};
		BufferedReader	br = new BufferedReader(
			new InputStreamReader(
				new FileInputStream( file[0] )
			)
		);
		BufferedWriter	bw = new BufferedWriter(
			new OutputStreamWriter(
				new FileOutputStream( file[1] )
			)
		);
		while( true ) {
			String	line = br.readLine();
			if ( line == null )	break;
			if ( !debug_f )	line = line.trim();
			if ( line.isEmpty() )	continue;
			char[]	ch = line.toCharArray();
			for ( int i = 0; i < ch.length; i++ ) {
				if ( !debug_f && ch[i] == '\t' )	continue;
				bw.write( ch[i] );
			}
			if ( debug_f )	bw.write( "\r\n" );
		}
		bw.close();
		br.close();
		file[1].setLastModified( file[0].lastModified() );
	}
}

