#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Sync.h"

#define MIN_SIZE 1000

int min_size;

int qsorttest(int num, int min_size = MIN_SIZE)
{
  int i;
  void qsort (int[], int, int);
  void qsort_sync(int[], int, int, Sync<int>);

  /*
  if(argc < 2) {
    printf("qsort NUM [min_size]\n");
    exit(0);
  }

  int num = atoi(argv[1]);
  if(argc > 2) min_size = atoi(argv[2]); else min_size = MIN_SIZE;
  */
  pards_init(pards_get_nprocs()+1, num * sizeof(int) * 2 + 1000000);

  //  pards_set_error_level(NO_PRINT);

  int* p = (int*)pards_shmalloc(sizeof(int) * num);
  int* q = (int*)pards_shmalloc(sizeof(int) * num);
  srand(1);
  for(i = 0; i < num; i++)
    p[i] = q[i] = rand();

  DWORD t1, t2;

  printf("serial version\n");
  t1 = GetTickCount();
  qsort(p,0,num-1);
  t2 = GetTickCount();
  for(i = 0; i < (5 < num ? 5 : num) ; i++)
    printf("%d ",p[i]);
  printf("...\n");
  
  printf("elapsed time = %f sec\n",(double)(t2 - t1)/1000.0);

  printf("parallel version\n");
  Sync<int> s;
  t1 = GetTickCount();
  qsort_sync(q,0,num-1,s);
  s.read(); // wait
  t2 = GetTickCount();

  for(i = 0; i < (5 < num ? 5 : num) ; i++)
    printf("%d ",q[i]);
  printf("...\n");
  
  printf("elapsed time = %f sec\n",(double)(t2 - t1)/1000.0);
  
  pards_finalize();
  return 0;
}

void qsort_sync (int v[], int left, int right, Sync<int> s)
{
  int last;
  void swap(int v[], int i, int j);
  void qsort (int[], int, int);
  int partition (int[], int, int);

  if(left >= right){
    s.write(1);
    return;
  }

  if(pards_avail_processes() == 0 || right - left + 1 < min_size){
    qsort(v,left,right);
    s.write(1);
    return;
  } else {
    try{
      Sync<int> t;
      try {
	Sync<int> u;
	last = partition(v,left,right);
	SPAWN_F(qsort_sync(v,left,last-1,t));
	qsort_sync(v,last+1,right,u);
	t.read();
	t.free();
	u.read();
	u.free();
	s.write(1);
	return;
      } catch (SemaphoreException) {
	pards_error("Exception Caught (t is allocated)",INFO);
	last = partition(v,left,right);
	SPAWN_F(qsort_sync(v,left,last-1,t));
	qsort(v,last+1,right);
	t.read();
	t.free();
	s.write(1);
      }
    } catch (SemaphoreException) {
      pards_error("Exception Caught",INFO);
      qsort(v,left,right);
      s.write(1);
      return;
    }
  }
}

void qsort (int v[], int left, int right)
{
  int last;
  void swap(int v[], int i, int j);
  int partition (int v[], int left, int right);

  if(left >= right)
    return;

  last = partition(v,left,right);  
  qsort(v,left,last-1);
  qsort(v,last+1,right);
}

int partition (int v[], int left, int right)
{
  int i, last;
  void swap(int v[], int i, int j);
  
  swap(v,left,(left+right)/2);
  last = left;
  for(i = left + 1; i <= right; i++)
    if(v[i] < v[left])
      swap(v,++last,i);
  swap(v,left,last);

  return last;
}

void swap(int v[], int i, int j)
{
  int temp;
  
  temp = v[i];
  v[i] = v[j];
  v[j] = temp;
}
