#include "SyncQueue.h"
#include "Merger.h"

class Item{
public:
  int val;
  int id;
};

int timedputsample()
{
  void generator(int,Merger<Item>*);
  void consumer(SyncQueue<Item>*);

  pards_init();

  SyncQueue<Item> *first = new SyncQueue<Item>(1); 
  Merger<Item> *merger = new Merger<Item>(first,2);
  
  SPAWN(generator(1,merger));
  SPAWN(generator(2,merger));
  consumer(first);

  pards_finalize();
  return 0;
}


void generator(int id, Merger<Item> *m)
{
  pards_status st;
  srand(id);
  for(int i = 0; i < 3; i++){
	  Sleep((rand()%3)*1000);
    Item it;
    it.val = i;
    it.id = id;
    struct timeval tv = {1,0};
    m->timedput(it, &tv, &st);
    if(st == TIMEOUT){
      pards_errorf(INFO,"Timeout. id:%d\n",id);
      break;
    }
  }
  m->release();
}

void consumer(SyncQueue<Item> *l)
{
  SyncQueue<Item> *current = l;
  while(1){
    Sleep(3000);
    Item it = current->read();
    pards_errorf(INFO,"val = %d, id = %d\n",it.val, it.id);
    current = current->release();
    if(current == 0) break;
  }
}
