#include <cppcutter.h>
#include <particle.h>
#include <iostream>
#include <filter.h>
using namespace std;

Particles<double> func1(Particles<double> &p, Particles<double> &v)
{
  for(int i=0;i<p.size();++i)
  {
    for(int j=0;j<p[i].size();++j)
    {
      p[i][j]= p[i][j]+v[i][j];
    }
  }
  cout<<"state function"<<endl;
  return(p);
}
double func2(Particles<double> &p, Particle<double> &q)
{

//  cout<<"robserve function"<<endl;
  return(p[0][0]-q[0]);
}
double func3(Particles<double> &p, Particle<double> &q)
{
//  cout<<"robserve jacobian function"<<endl;
  return(1.0);
}
double func4(double w)
{
//  cout<<"robserve density function"<<endl;
  return(1.0/sqrt(2.0*M_PI*0.1*0.1)*exp(-w*w/(2.0*0.1*0.1)));
}

namespace test_filter
{
  void cut_setup()
  {
  }
  void cut_teardown()
  {
  }

  void test_construction(void)
  {
    // Constructor
    Filter a(0.0);
    a.setNumber(5);
    a.setDimension(3);
    a.createInitialParticles();
    cut_assert_equal_string("(0.000000,0.000000,0.000000)(0.000000,0.000000,0.000000)(0.000000,0.000000,0.000000)(0.000000,0.000000,0.000000)(0.000000,0.000000,0.000000)",a.predict_particles_toString().c_str());
//    a.dump_predict_particles();
  }
  void test_manipulation(void)
  {
    Filter a(0.0);
    a.setNumber(5);
    a.setDimension(3);
    a.set_state_func(&func1);
    a.set_robserve_func(&func2);
    a.set_robserve_jacobian_func(&func3);
    a.set_robserve_density_func(func4);

    a.createInitialParticles();
    a.create_system_noise();

    // initial value
    cut_assert_equal_string("(0.000000,0.000000,0.000000)(0.000000,0.000000,0.000000)(0.000000,0.000000,0.000000)(0.000000,0.000000,0.000000)(0.000000,0.000000,0.000000)",a.predict_particles_toString().c_str());
    cut_assert_equal_string("(1.163078,0.483805,0.299564)(0.153025,-1.168815,1.558071)(-0.545944,-2.355630,0.541440)(2.678507,1.254634,-0.548774)(-0.681064,-0.135316,0.377231)",a.system_noise_toString().c_str());    
    a.get_next_state();

    // initial value+system noise
    cut_assert_equal_string("(1.163078,0.483805,0.299564)(0.153025,-1.168815,1.558071)(-0.545944,-2.355630,0.541440)(2.678507,1.254634,-0.548774)(-0.681064,-0.135316,0.377231)",a.predict_particles_toString().c_str());
    Particles<double> y(5,3);
    Particle<double> x(3);
    x[0]=0.1; x[1]=-1.1; x[2]=1.5;
    for(int i=0;i<y.size();++i)
    {
      y[i] = x;
    }
    a.set_observed_data(y);
    cut_assert_equal_double(-1.06308,1e-4,a.get_observed_noise(0));
    cut_assert_equal_double(1.14882e-24,1e-5,a.get_robserved_density_value(-1.06308));
    a.compute_likelihood();
    a.resampling();
    cut_assert_equal_string("(0.153025,-1.168815,1.558071)(0.153025,-1.168815,1.558071)(0.153025,-1.168815,1.558071)(0.153025,-1.168815,1.558071)(0.153025,-1.168815,1.558071)",a.predict_particles_toString().c_str());

    // step 2

    a.create_system_noise();
    a.get_next_state();
    cut_assert_equal_string("(0.563190,-0.597547,-1.199891)(1.229306,-1.782948,3.388836)(-0.993781,-1.114977,-0.949410)(-0.438624,-0.310210,1.330129)(0.354340,-0.818760,2.094123)",a.predict_particles_toString().c_str());
    x[0]=0.2; x[1]=-1.0; x[2]=1.5;
    for(int i=0;i<y.size();++i)
    {
      y[i] = x;
    }
    a.set_observed_data(y);
    cut_assert_equal_double(-0.36319,1e-4,a.get_observed_noise(0));
    a.set_robserve_density_func(func4);
    cut_assert_equal_double(1.14882e-24,1e-5,a.get_robserved_density_value(-1.06308));
    a.compute_likelihood();
    a.resampling();
    cut_assert_equal_string("(0.563190,-0.597547,-1.199891)(0.563190,-0.597547,-1.199891)(0.563190,-0.597547,-1.199891)(0.563190,-0.597547,-1.199891)(0.563190,-0.597547,-1.199891)",a.predict_particles_toString().c_str());

  }
}
int main()
{
  test_filter::test_construction();
  return(0);
}
