#include <cppcutter.h>
#include <particle.h>
#include <iostream>
using namespace std;

namespace test_particle
{

  void cut_setup()
  {
  }
  void cut_teardown()
  {
  }

  void test_construction(void)
  {
    // Constructor
    Particle<int> a(5);
    vector<int> p = a.get_particle();
    cppcut_assert_equal(5, (int)p.size());

    // Copy constructor
    vector<int> b(5);
    for(int i=1;i<5;++i) b.at(i-1)=i;
    a = b;
    for(int i=1;i<5;++i) cut_assert_equal_int(i, a[i-1]);
    Particle<int> c(5);
    cut_assert_equal_int(5,c.size());
    cut_assert_equal_string("(0,0,0,0,0)",c.toString().c_str());
    for(int i=1;i<5;++i) cut_assert_equal_int(i, a[i-1]);
  }
  void test_MersennneTwister(void)
  {
    MTRand r;
    cout<<r.randInt()<<endl;
  }
  void test_dumping(void)
  {
    Particle<int> a(5);
    cut_assert_equal_string("(0,0,0,0,0)",a.toString().c_str());
  }
}
