<?php

/* -------------------------------------------------------------------------
	!!!The character encoding of this file must be `INT_ENC`
	defined in Config.inc.php (the default value is EUC-JP)!!!

	設定画面
	for PC2M Website Transcoder for Mobile Clients
	Copyright (C) 2005-2006 ucb.rcdtokyo and the contributors
	http://www.rcdtokyo.com/pc2m/note/

	これは、既定のTemplate.inc.phpでは、画面上部にある「設」リンクをクリック
	して表示されるページの内容です。
------------------------------------------------------------------------- */

/* -------------------------------------------------------------------------
	設定画面のページタイトル
------------------------------------------------------------------------- */

define('SETUP_TITLE', '設定');

/* -------------------------------------------------------------------------
	メッセージボディ

	メッセージボディは、HTMLソースの文字列をreturnする形式で記述します。
	以下の内容は、表示される際には全角半角の変換が行われますが、それ以外の変
	換処理は一切行われません。すなわち、携帯端末が対応しているすべてのタグを
	制約なしに利用できます。
------------------------------------------------------------------------- */

ob_start();

	$_url = null;
	if ($local_args['u']) {
		if (preg_match('/^[0-9a-f]{32}$/', $local_args['u'])) {
			if (isset($_SESSION['history'][$local_args['u']])) {
				$_url = $_SESSION['history'][$local_args['u']][1];
			}
		} else {
			$_url = $local_args['u'];
		}
	}

	echo '<center>-簡単設定-</center>
	<p><a href="'.$script_self.
		KEY_PREFIX.'v=0&amp;'.KEY_PREFIX.'l=0&amp;'.KEY_PREFIX.'k=0&amp;'.
		KEY_PREFIX.'u='.urlencode($_url).'">[軽]パケ代節約設定</a></p>
		<ul>
		<li>テキストのみ</li>
		<li>装飾なし</li>
		<li>半角変換する</li>
		</ul>';
	if (!$_has_sessionid_leakrisk) {
		echo '<p><a href="'.$script_self.
			KEY_PREFIX.'v=1&amp;'.KEY_PREFIX.'l=1&amp;'.KEY_PREFIX.'k=1&amp;'.
			KEY_PREFIX.'u='.urlencode($_url).'">[麗]パケホ向け設定</a></p>
			<ul>
			<li>画像も表示(一部変換)</li>
			<li>装飾あり</li>
			<li>半角変換しない</li>
			</ul>
			<hr>';
	} else {
		echo '<p><a href="'.$script_self.
			KEY_PREFIX.'v=2&amp;'.KEY_PREFIX.'l=1&amp;'.KEY_PREFIX.'k=1&amp;'.
			KEY_PREFIX.'u='.urlencode($_url).'">パケホ向け設定</a></p>
			<ul>
			<li>画像も表示(全部変換)</li>
			<li>装飾あり</li>
			<li>半角変換しない</li>
			</ul>
			<hr>';
	}

	echo '<center>-詳細設定-</center>
		<form action="'.basename($_SERVER['SCRIPT_NAME']).'">'.
		((isset($_SESSION) and $local_args['d'] != null and !ENABLE_SESSION_COOKIE)?
			'<input type="hidden" name="'.KEY_PREFIX.'d" value="'.$local_args['d'].'">': null);

	// HTML受信サイズ
	echo '<p><label for="'.KEY_PREFIX.'c">■HTML受信サイズ</label><br>
		<input type="text" name="'.
		KEY_PREFIX.'c" size="4" maxlength="3" istyle="4" value="'.
		($local_args['c']? $local_args['c']:
		floor((($client->cache_size > CACHESIZE_THRESHOLD)? CACHESIZE_THRESHOLD: $client->cache_size) /1000)).
		'">KB</p>';

	// 以下は受信サイズをプルダウンメニューから選択させる場合
	// 端末のキャッシュサイズが7.5KB以下なら非表示
	/*
	if ($client->cache_size > 7500) {
		echo '<p><label for="'.KEY_PREFIX.'c">■キャッシュサイズ選択</label><br>
			<select name="'.KEY_PREFIX.'c">
			<option value=""'.(!$local_args['c']? ' selected="selected"': null).'>自動('.$_default_setting['c'].'KB)</option>
			<option value="5"'.(($local_args['c'] == '5')? ' selected="selected"': null).'>5KB</option>';
		if ($client->cache_size > 10000) {
			echo '<option value="10"'.(($local_args['c'] == '10')? ' selected="selected"': null).'>10KB</option>';
		}
		if ($client->cache_size > 20000) {
			echo '<option value="20"'.(($local_args['c'] == '20')? ' selected="selected"': null).'>20KB</option>';
		}
		if ($client->cache_size > 40000) {
			echo '<option value="40"'.(($local_args['c'] == '40')? ' selected="selected"': null).'>40KB</option>';
		}

		// 端末のキャッシュサイズが定数CACHESIZE_THRESHOLDを超えている場合は
		// 端末のキャッシュサイズの最大値（KB単位で端数は切り捨て）を表示する
		if (defined('CACHESIZE_THRESHOLD') and $client->cache_size > CACHESIZE_THRESHOLD) {
			$i = floor($client->cache_size /1000);
			echo '<option value="'.$i.'"'.($local_args['c'] == $i ? ' selected="selected"' : null).'>'.$i.'KB</option>';
		}
		echo '</select></p>';
	}
	*/

	// テキストと画像の同時表示の選択ラジオボタン
	if ($client->screen['color'] > 256 and IMAGE_CONVERTER) {
		echo '<p><label for="'.KEY_PREFIX.'v">■画像表示</label><br>
			<input type="radio" name="'.KEY_PREFIX.'v" value="0"'.
			(empty($local_args['v'])? ' checked="checked"': null).'>テキストのみ<br>';
		if (!$_has_sessionid_leakrisk) {
			echo '<input type="radio" name="'.KEY_PREFIX.'v" value="1"'.
				(($local_args['v'] == 1)? ' checked="checked"': null).'>画像も表示(一部変換)<br>';
		}
		echo '<input type="radio" name="'.KEY_PREFIX.'v" value="2"'.
			(($local_args['v'] == 2)? ' checked="checked"': null).'>画像も表示(全部変換)<br>
			画像の最大幅<input type="text" name="'.KEY_PREFIX.'w" size="4" maxlength="3" istyle="4" value="'.
			$local_args['w'].'">px</p>';
		if (!$_has_sessionid_leakrisk) {
			echo '<p><font size="-1">※「全部変換」は「一部変換」で画像が表示されない場合に(表示は遅くなります)</font></p>';
		}
	}

	// 装飾タグの有無の選択ラジオボタン
	echo '<p><label for="'.KEY_PREFIX.'l">■装飾</label><br>
		<input type="radio" name="'.KEY_PREFIX.'l" value="0"'.
		(empty($local_args['l'])? ' checked="checked"': null).'>なし<br>
		<input type="radio" name="'.KEY_PREFIX.'l" value="1"'.
		(($local_args['l'] == 1)? ' checked="checked"': null).'>あり</p>
		<p><font size="-1">※「あり」は文字色や背景色を表示しますがページや端末によっては文字が読めなくなります。</font></p>';

	// 半角変換の有無の選択ラジオボタン
	// 設定ファイルで定数KANA_CONVOPTを空文字にしている場合は
	// 設定変更しても表示に変化はないので、この項目は削除してください。
	echo '<p><label for="'.KEY_PREFIX.'k">■半角に変換</label><br>
		<input type="radio" name="'.KEY_PREFIX.'k" value="0"'.
		(empty($local_args['k'])? ' checked="checked"': null).'>する<br>
		<input type="radio" name="'.KEY_PREFIX.'k" value="1"'.
		(($local_args['k'] == 1)? ' checked="checked"': null).'>しない</p>';

	// 送信後の戻り先
	echo '<p><label for="'.KEY_PREFIX.'u">■戻り先(空欄でTOP)</label><br>
		<input type="text" name="'.KEY_PREFIX.'u" size="8" istyle="3" value="'.$_url.'"><input type="submit" value="設定"></p>
		<p><label for="'.KEY_PREFIX.'s">■表示開始位置(文字数/検索語)</label><br>
		<input type="text" name="'.KEY_PREFIX.'s" size="8"></p>';

	// User-Agentの選択
	if (isset($alternative_http_headers) and !empty($alternative_http_headers)) {
		echo '<p><label for="'.KEY_PREFIX.'b">■User-Agent</label><br>
		<select name="'.KEY_PREFIX.'b">
		<option value="0"'.(!$local_args['b']? ' selected="selected"': null).'>標準</option>';
		$limit = count($alternative_http_headers);
		for ($i = 0; $i < $limit; $i++)  {
			echo '<option value="'.($i +1).'"'.
				(($local_args['b'] == $i +1)? ' selected="selected"': null).
				'>'.$alternative_http_headers[$i]['description'].'</option>';
		}
		echo '</select></p>';
	}

	echo '</form>
		<hr>
		<a href="'.$script_self.KEY_PREFIX.'a=l">セッションの復元</a>(管理者用)';

$_output_buffer = ob_get_contents();
ob_end_clean();
return $_output_buffer;

?>
