<?php

/* -------------------------------------------------------------------------
	Redirect Hook (to hide session ID if the client sends a referer)
	for PC2M Website Transcoder for Mobile Clients
	Copyright (C) 2005-2006 ucb.rcdtokyo and the contributors
	http://www.rcdtokyo.com/pc2m/note/
------------------------------------------------------------------------- */

if (!empty($_SERVER['QUERY_STRING'])) {
	@include_once 'Config.inc.php';
	if (!defined('KEY_PREFIX')) {
		define('KEY_PREFIX', '');
	}
	if (!defined('SESSION_ID_LENGTH')) {
		define('SESSION_ID_LENGTH', 32);
	}
	$_url = $_SERVER['QUERY_STRING'];
	if (strpos($_url, '?') === false
		and (preg_match('/%3A/i', $_url)
			or preg_match('/%2E/i', $_url)
			or preg_match('/%2F/i', $_url))) {
		$_url = urldecode($_url);
	}
	$_url = preg_replace('/&amp;/', '&', $_url);
	$_url = preg_replace('/\s/', '%20', $_url);
	if (!preg_match('/^https?:\/\//', $_url)) {
		$_url = 'http://'.$_url;
	}
	// Redirect to the destination immediately
	// if the client does not send a referer or the referer does not contain session ID
	if (!isset($_SERVER['HTTP_REFERER'])
		or !preg_match('/[?&]\b'.KEY_PREFIX.'d=\w{'.SESSION_ID_LENGTH.'}\b/', $_SERVER['HTTP_REFERER'])) {
		header('Location:'.$_url);
		exit;
	}
	// Otherwise display HTML with a link to the destination
	header('Content-Type:text/html;charset=Shift_JIS');
	echo <<<HTML
<html>
<body>

<p>ȉNbNĈړĂ<br>
<a href="{$_url}">{$_url}</a></p>
<p>̃y[W̓ZLeB̓sŕ\Ă܂</p>

</body>
</html>
HTML;
}

?>
