<?php

/* -------------------------------------------------------------------------
	PC2M Website Transcoder for Mobile Clients
	Copyright (C) 2005-2007 ucb.rcdtokyo and the contributors
	http://www.rcdtokyo.com/pc2m/note/

	Version 0.9.22.5 (beta) issued January 22, 2008

	このプログラムは、Free Software FoundationによるGNU General Public
	Licenseのバージョン2あるいはそれ以降のバージョン（以下「GPL」と言う）に
	基づきライセンスされます。このプログラムの全利用者は、必ず GPLの全文を確
	認してください。GPLの全文は、ウェブサイト http://www.gnu.org/licenses/
	にて、あるいは、Free Software Foundation, Inc., 59 Temple Place - Suite
	330, Boston, MA 02111-1307 USAに請求文書を送付することで入手できます。
	このプログラムは、いわゆるPublic Domainなどではなく、著作権は放棄されて
	いません。
	このプログラムは、GPLの定める条件に反しない限り、商用利用を含むいかなる
	目的での利用も制限されるものではありません。また、このプログラムは、GPL
	の定める条件、すなわちその全ての派生物が、同様にGPLに基づきライセンスさ
	れなければならないという条件下で、頒布や改変などを行うことができます。
	このプログラムは、有用なものであることを願って提供されるものではあります
	が、商品性や特定目的に対する適合性などの黙示保証を含む、いかなるものも保
	証するものではありません。すなわち、その利用は、全て自らの責任において
	行ってください。
------------------------------------------------------------------------- */

define('DEBUG_MODE', false);
if (defined('DEBUG_MODE') and DEBUG_MODE) {
	ini_set('display_errors', '1');
	error_reporting(E_ALL);
	function microtime_float()
	{
		list($usec, $sec) = explode(" ", microtime());
		return ((float)$usec + (float)$sec);
	}
	$elaps = 0;
	$time_start = microtime_float();
}
@include_once 'Config.inc.php';
require_once 'ClientDetect.class.php';
$client = new ClientDetect();
if (((defined('ALLOW_ONLYMOBILE') and ALLOW_ONLYMOBILE === true)
	or (defined('RESTRICT_MOZILLA_AGENT') and RESTRICT_MOZILLA_AGENT === true))
	and !$client->is_mobile) {
	if (!isset($exclude_iprange) or
		!$client->_compareIp($client->_dumpAddress($_SERVER['REMOTE_ADDR']), $exclude_iprange)) {
		header("$_SERVER[SERVER_PROTOCOL] 403 Forbidden");
		exit("$_SERVER[SERVER_PROTOCOL] 403 Forbidden");
	}
}
if (!defined('OUTPUT_ENC')) {
	define('OUTPUT_ENC', 'SJIS-win');
}
if (!defined('INT_ENC')) {
	define('INT_ENC', 'eucJP-win');
}
if (!defined('DETECT_ORDER')) {
	define('DETECT_ORDER', 'ASCII, JIS, UTF-8, EUC-JP, SJIS');
}
mb_internal_encoding(INT_ENC);
mb_detect_order(DETECT_ORDER);
$output_enc = OUTPUT_ENC;
$_template_path = null;
if (defined('IMAGE_ENABLED') and IMAGE_ENABLED) {
	if (!defined('IMAGE_CONVERTER')) {
		if (defined('FANCY_URL_PREFIX')) {
			define('IMAGE_CONVERTER', $_SERVER['SCRIPT_NAME']);
		} else {
			define('IMAGE_CONVERTER', basename($_SERVER['SCRIPT_NAME']));
		}
	}
} elseif (!defined('IMAGE_CONVERTER')) {
	define('IMAGE_CONVERTER', false);
}
if (!defined('KEY_PREFIX')) {
	define('KEY_PREFIX', '');
}
if (!defined('SIZE_REDUNDANCY')) {
	define('SIZE_REDUNDANCY', 1000);
}
if (!defined('URL_REDUNDANCY')) {
	define('URL_REDUNDANCY', 4);
}
if (!defined('ALLOWABLE_CLENGTH')) {
	define('ALLOWABLE_CLENGTH', 300000);
}
if (!defined('MAX_META_REDIRECT')) {
	define('MAX_META_REDIRECT', 5);
}
if (!defined('ALLOWABLE_PIXSIZE')) {
	define('ALLOWABLE_PIXSIZE', 640);
}
if (!defined('AVERAGE_COMPRESSION_RATIO')) {
	define('AVERAGE_COMPRESSION_RATIO', 50);
}
if (!defined('AVERAGE_PALETTE_BIT')) {
	define('AVERAGE_PALETTE_BIT', 6);
}
if (!defined('KANA_CONVOPT')) {
	define('KANA_CONVOPT', '');
}
if (!defined('SESSION_ID_LENGTH')) {
	define('SESSION_ID_LENGTH', 32);
}
if (!defined('SESSION_INSECURE_LIFETIME')) {
	define('SESSION_INSECURE_LIFETIME', 300);
}
if (!defined('SESSION_SECURE_LIFETIME')) {
	define('SESSION_SECURE_LIFETIME', SESSION_INSECURE_LIFETIME);
}
if (!defined('MAX_HISTORY_KEEP')) {
	define('MAX_HISTORY_KEEP', 30);
}
define('SHOW_PASSINPUT',
	$client->is_postcapable
	or !defined('USE_ONLYPOST_FORPASS')
	or !USE_ONLYPOST_FORPASS
);
$remote_url = null;
$content = null;
$title = null;
$rss_url = null;
$rss = array();
$mobile_url = null;
$body_elements = array();
$start_link = null;
$next_link = null;
$copy_link = null;
$next_trim = null;
$total_chars = null;
$new_image = array();
$image_quality = null;
$form_hidden = null;
$_kana_convopt = null;
$_refresh_count = 0;
$_history_key = null;
$_is_error = false;
$_is_httperror = false;
$_has_sessionid_leakrisk = false;
$_element_serial = 1;
$enable_accesskey = true;
$_keys = array('d', 'c', 's', 'f', 'o', 'v', 'l', 'k', 'a', 'm', 'e', 'w', 'h', 't', 'q', 'i', 'p', 'r', 'b', 'y', 'u');
$_raw_query = $_SERVER['QUERY_STRING'];
if (defined('FANCY_URL_PREFIX') and 0 !== strpos($_SERVER['REQUEST_URI'], $_SERVER['SCRIPT_NAME'])) {
	$_raw_query = preg_replace('/^'.str_replace('/', '\/', FANCY_URL_PREFIX).'/', '', $_SERVER['REQUEST_URI']);
	$search = '/^([a-z0-9]{'.SESSION_ID_LENGTH.'})\//';
	if (preg_match($search, $_raw_query, $matches)) {
		$_raw_query = preg_replace($search, '', $_raw_query);
		if (empty($_POST)) {
			$_GET[KEY_PREFIX.'d'] = $matches[1];
		} else {
			$_POST[KEY_PREFIX.'d'] = $matches[1];
		}
	}
}
$_remote_args = empty($_POST)? $_GET: $_POST;
$_ext_urlenc_search = array('-', '.', '_');
$_ext_urlenc_replace = array('%2D', '%2E', '%5F');
$_key_prefix = str_replace($_ext_urlenc_search, $_ext_urlenc_replace, urlencode(KEY_PREFIX));
if (!preg_match('/'.$_key_prefix.'/i', $_raw_query)) {
	$_key_prefix = urlencode(KEY_PREFIX);
}
foreach ($_keys as $key) {
	if (isset($_remote_args[KEY_PREFIX.$key])) {
		$local_args[$key] = ('' !== $_remote_args[KEY_PREFIX.$key])?
			mb_convert_encoding($_remote_args[KEY_PREFIX.$key], INT_ENC, $output_enc):
			null;
		unset($_remote_args[KEY_PREFIX.$key]);
		if ($key == 'u') {
			$search = "'&?".$_key_prefix.$key."='i";
		} else {
			$search = "'&?".$_key_prefix.$key."=[^&]*'i";
		}
		$_raw_query = preg_replace($search, null, $_raw_query);
	} else {
		$local_args[$key] = null;
	}
}
$_raw_query = preg_replace('/^(?:&|\+|%20|%81%40|\x20)+(.*)$/', '$1', $_raw_query);
define('ENABLE_SESSION_COOKIE', isset($_COOKIE[KEY_PREFIX.'d']));
if (ENABLE_SESSION_COOKIE and $_COOKIE[KEY_PREFIX.'d'] == $local_args['d']) {
	if (!empty($_SERVER['QUERY_STRING'])) {
		$array = explode('&', $_SERVER['QUERY_STRING']);
		$limit = count($array);
		for ($i = 0; $i < $limit; $i++) {
			if (0 === strpos($array[$i], KEY_PREFIX.'d='.$local_args['d'])) {
				unset($array[$i]);
			}
		}
		$x = implode('&', $array);
		header('Location:http'.
			(isset($_SERVER['HTTPS']) and $_SERVER['HTTPS'] == 'on'? 's': null).'://'.
			$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'].'?'.$x);
		exit;
	} elseif (defined('FANCY_URL_PREFIX')) {
		header('Location:http'.
			(isset($_SERVER['HTTPS']) and $_SERVER['HTTPS'] == 'on'? 's': null).'://'.
			$_SERVER['HTTP_HOST'].FANCY_URL_PREFIX.$_raw_query);
		exit;
	}
}
if (defined('ENABLE_SESSION') and ENABLE_SESSION === true) {
	ini_set('session.save_handler', 'files');
	ini_set('session.referer_check', '');
	ini_set('session.use_cookies', '1');
	ini_set('session.use_only_cookies', '0');
	ini_set('session.cache_limiter', 'nocache');
	if (!defined('SESSION_COOKIE_PATH')) {
		session_set_cookie_params(0, getDirName($_SERVER['SCRIPT_NAME']));
	} else {
		session_set_cookie_params(0,
			(strrpos(SESSION_COOKIE_PATH, '/') == strlen(SESSION_COOKIE_PATH) -1)?
			SESSION_COOKIE_PATH: SESSION_COOKIE_PATH.'/');
	}
	session_name(KEY_PREFIX.'d');
	$_session_key = md5(
		(isset($_SERVER['HTTP_USER_AGENT'])? $_SERVER['HTTP_USER_AGENT']: null).
		$client->getSerialId().
		$client->hostname
	);
	$_session_lifetime = (ENABLE_SESSION_COOKIE
		or (null !== $client->getSerialId() and $client->is_mobile))?
		SESSION_SECURE_LIFETIME:
		SESSION_INSECURE_LIFETIME;
	$_restart = true;
	if ($local_args['d'] or isset($_COOKIE[session_name()])) {
		if (!isset($_COOKIE[session_name()]) and !preg_match('/^[\w-]+$/', $local_args['d'])) {
			session_id(generateId(SESSION_ID_LENGTH));
		}
		if ($local_args['a'] != 'i'
			and isset($_SERVER['HTTP_USER_AGENT'])
			and false !== strpos($_SERVER['HTTP_USER_AGENT'], 'UP.Browser')) {
			session_cache_limiter('nocache');
		} else {
			session_cache_limiter('none');
		}
		session_start();
		if (($local_args['a'] == 'l' and $client->dev_type == 'docomo' and $client->is_mobile)
			or (isset($_SESSION['identifier']) and $_SESSION['identifier'] == $_session_key
			and isset($_SESSION['atime']) and $_session_lifetime > time() - $_SESSION['atime'])) {
			$_restart = false;
		} else {
			$_SESSION = array();
			if (isset($_COOKIE[session_name()])) {
				setcookie(session_name(), '', time() -42000, '/');
			}
			@session_destroy();
		}
	}
	if ($_restart) {
		if ($local_args['m']) {
			header('Location:'.basename($_SERVER['SCRIPT_NAME']));
			exit;
		}
		if (!$client->is_mobile
			and defined('RESTRICT_HOSTS_INDNSBL') and RESTRICT_HOSTS_INDNSBL === true) {
			if (isset($dnsbls) and false !== @include_once 'Net/DNSBL.php') {
				$dnsbl = new Net_DNSBL();
				$dnsbl->setBlacklists($dnsbls);
				if ($dnsbl->isListed($_SERVER['REMOTE_ADDR'])) {
					header("$_SERVER[SERVER_PROTOCOL] 403 Forbidden");
					exit("$_SERVER[SERVER_PROTOCOL] 403 Forbidden");
				}
			}
		}
		session_id(generateId(SESSION_ID_LENGTH));
		if ($local_args['a'] != 'i'
			and isset($_SERVER['HTTP_USER_AGENT'])
			and false !== strpos($_SERVER['HTTP_USER_AGENT'], 'UP.Browser')) {
			session_cache_limiter('nocache');
		} else {
			session_cache_limiter('none');
		}
		session_start();
		$_SESSION['identifier'] = $_session_key;
	}
	$local_args['d'] = session_id();
	$_SESSION['atime'] = time();
	if ($local_args['c'] === null and isset($_SESSION['settings']['c'])) {
		$local_args['c'] = $_SESSION['settings']['c'];
	}
	if ($local_args['w'] === null and isset($_SESSION['settings']['w'])) {
		$local_args['w'] = $_SESSION['settings']['w'];
	}
	if ($local_args['v'] === null and isset($_SESSION['settings']['v'])) {
		$local_args['v'] = $_SESSION['settings']['v'];
	}
	if ($local_args['l'] === null and isset($_SESSION['settings']['l'])) {
		$local_args['l'] = $_SESSION['settings']['l'];
	}
	if ($local_args['k'] === null and isset($_SESSION['settings']['k'])) {
		$local_args['k'] = $_SESSION['settings']['k'];
	}
	if ($local_args['b'] === null and isset($_SESSION['settings']['b'])) {
		$local_args['b'] = $_SESSION['settings']['b'];
	}
} else {
	$local_args['d'] = null;
}
if ($local_args['c'] == 0) {
	$local_args['c'] = null;
}
if (!is_numeric($local_args['c'])) {
	$local_args['c'] = null;
}
if (!is_numeric($local_args['w'])) {
	$local_args['w'] = null;
} else {
	if ($local_args['w'] > ALLOWABLE_PIXSIZE) {
		$local_args['w'] = null;
	}
}
if (!is_numeric($local_args['h'])) {
	$local_args['h'] = null;
}
if (!preg_match('/^[1-3]$/', $local_args['t'])) {
	$local_args['t'] = null;
}
if (!preg_match('/^\d{1,3}[^\d\s]*$/', $local_args['q'])) {
	$local_args['q'] = null;
}
if ($client->screen['color'] < 256) {
	$local_args['v'] = 0;
}
$_default_setting['c'] = floor(
	(($client->cache_size > CACHESIZE_THRESHOLD)?
	CACHESIZE_THRESHOLD:
	$client->cache_size) /1000);
$_default_setting['v'] = 0;
$_default_setting['l'] = 0;
$_default_setting['k'] = 0;
if (defined('RICHTERM_THRESHOLD')
	and RICHTERM_THRESHOLD <= $client->cache_size) {
	if (defined('RICHTERM_VISUAL')) {
		$_default_setting['v'] = RICHTERM_VISUAL;
	}
	if (defined('RICHTERM_LEGACYTAGS')) {
		$_default_setting['l'] = RICHTERM_LEGACYTAGS;
		if ($client->preferred_markup == 'chtml') {
			list($_major) = explode('.', $client->chtml);
			if ($_major < 6) {
				$_default_setting['l'] = 0;
			}
		}
	}
	if (defined('RICHTERM_KANACONV')) {
		$_default_setting['k'] = RICHTERM_KANACONV;
	}
}
if ($local_args['v'] === null) {
	$local_args['v'] = $_default_setting['v'];
}
if ($local_args['l'] === null) {
	$local_args['l'] = $_default_setting['l'];
}
if ($local_args['k'] === null) {
	$local_args['k'] = $_default_setting['k'];
}
if (defined('FANCY_URL_PREFIX')) {
	$script_self = "$_SERVER[SCRIPT_NAME]?";
	$fancy_url_prefix = FANCY_URL_PREFIX;
} else {
	$script_self = basename($_SERVER['SCRIPT_NAME']).'?';
}
if ($local_args['d'] !== null and !ENABLE_SESSION_COOKIE) {
	$script_self = $script_self.strip_tags(SID).'&amp;';
	$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'d" value="'.$local_args['d'].'" />';
	if (defined('FANCY_URL_PREFIX')) {
		$fancy_url_prefix .= session_id().'/';
	}
	if (isset($_SERVER['HTTP_REFERER'])) {
		$_has_sessionid_leakrisk = true;
		if ($local_args['v'] == 1) {
			$local_args['v'] = 2;
		}
	}
}
if (isset($_SESSION)) {
	$_SESSION['settings']['c'] = $local_args['c'];
	$_SESSION['settings']['w'] = $local_args['w'];
	$_SESSION['settings']['v'] = $local_args['v'];
	$_SESSION['settings']['l'] = $local_args['l'];
	$_SESSION['settings']['k'] = $local_args['k'];
	$_SESSION['settings']['b'] = $local_args['b'];
}
if (!isset($_SESSION)
	or (defined('KEEP_SETTING_INQUERY') and KEEP_SETTING_INQUERY)) {
	if ($local_args['c'] and $local_args['c'] != $_default_setting['c']) {
		$script_self = $script_self.KEY_PREFIX.'c='.$local_args['c'].'&amp;';
		$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'c" value="'.$local_args['c'].'" />';
	}
	if ($local_args['w'] and $local_args['w'] != $client->screen['width']) {
		$script_self = $script_self.KEY_PREFIX.'w='.$local_args['w'].'&amp;';
		$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'w" value="'.$local_args['w'].'" />';
	}
	if ($local_args['v'] != $_default_setting['v']) {
		$script_self = $script_self.KEY_PREFIX.'v='.$local_args['v'].'&amp;';
		$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'v" value="'.$local_args['v'].'" />';
	}
	if ($local_args['l'] != $_default_setting['l']) {
		$script_self = $script_self.KEY_PREFIX.'l='.$local_args['l'].'&amp;';
		$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'l" value="'.$local_args['l'].'" />';
	}
	if ($local_args['k'] != $_default_setting['k']) {
		$script_self = $script_self.KEY_PREFIX.'k='.$local_args['k'].'&amp;';
		$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'k" value="'.$local_args['k'].'" />';
	}
}
if (!isset($_SESSION)) {
	if ($local_args['b']) {
		$script_self = $script_self.KEY_PREFIX.'b='.$local_args['b'].'&amp;';
		$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'b" value="'.$local_args['b'].'" />';
	}
}
$script_host = 'http'.
	(isset($_SERVER['HTTPS']) and $_SERVER['HTTPS'] == 'on'? 's': null).
	'://'.$_SERVER['HTTP_HOST'];
$_kana_convopt = $local_args['k']? '': KANA_CONVOPT;
if (defined('USE_DATABASE') and USE_DATABASE == true) {
	switch ($dbconf['dbtype']) {
		case 'mysql':
			@mysql_connect($dbconf['host'].':'.$dbconf['port'], $dbconf['user'], $dbconf['pass']) or exit(mysql_error());
			mysql_select_db($dbconf['dbname']);
			break;
		default:
			require_once 'MDB2.php';
			$mdb2 =& MDB2::factory("$dbconf[dbtype]://$dbconf[user]:$dbconf[pass]@$dbconf[host]:$dbconf[port]");
			if (PEAR::isError($mdb2)) {
				exit ($mdb2->getMessage());
			}
			$mdb2->setDatabase($dbconf['dbname']);
	}
	dbgc();
}
if ($local_args['a'] == 'h') {
	if (!isset($_SESSION['history']) or empty($_SESSION['history'])) {
		$content = sayError('ERROR_NOHISTORY');
	} else {
		$array = sortMultiArray($_SESSION['history'], 0);
		$content = '<ol>';
		$i = 0;
		foreach ($array as $key => $value) {
			$content .= '<li><a href="'.$script_self.KEY_PREFIX.'u='.
				(($value[4] == 'post')? $key: $value[1]).'">'.
				($value[2]? $value[2]: $value[1]).'</a></li>';
			$i++;
		}
		$content .= '</ol>';
	}
	$content = mb_convert_kana($content, $_kana_convopt);
	trimContent($content, $local_args['s']);
} elseif ($local_args['a'] == 's') {
	$content = require_once $_template_path.'Setup.inc.php';
	$content = mb_convert_kana($content, $_kana_convopt);
	$title = defined('SETUP_TITLE')? SETUP_TITLE: null;
} elseif ($local_args['a'] == 'o') {
	$content = require_once $_template_path.'Option.inc.php';
	$content = mb_convert_kana($content, $_kana_convopt);
	$title = defined('SETUP_TITLE')? SETUP_TITLE: null;
} elseif ($local_args['a'] == 'l') {
	$content = require_once $_template_path.'Auth.inc.php';
	$content = mb_convert_kana($content, $_kana_convopt);
	$title = defined('AUTH_TITLE')? AUTH_TITLE: null;
} elseif (($local_args['u'] === null or $local_args['u'] === '') and !$_raw_query) {
	if (defined('DEFAULT_URL') and DEFAULT_URL) {
		$_raw_query = DEFAULT_URL;
	} else {
		if (false === $content = @include_once $_template_path.'Frontpage.inc.php') {
			$content = sayError('ERROR_FRONTPAGE_MISSING');
		} else {
			$content = mb_convert_kana($content, $_kana_convopt);
			$title = defined('DEFAULT_TITLE')? DEFAULT_TITLE: null;
		}
	}
}
if ($content === null) {
	require_once 'HTTP/Client.php';
	require_once 'HTTP/Request/Listener.php';
	class URL_Listener extends HTTP_Request_Listener
	{
		var $_url;
		var $_checkedUrl;
		var $_redirUrl;
		function update(&$subject, $event, $data)
		{
			switch ($event) {
				case 'httpSuccess':
				case 'httpError':
					if ('' == $this->_redirUrl) {
						$this->_url = $this->_checkedUrl;
					} else {
						$this->_url = $this->_redirUrl;
					}
					break;
				case 'httpRedirect':
					$this->_redirUrl = $data;
					break;
				case 'request':
					$this->_checkedUrl = $data;
					$this->_redirUrl = '';
			}
		}
		function getResults()
		{
			return $this->_url;
		}
	}
	require_once 'HTMLParser.class.php';
	$format_rule = require_once 'FormatRule.inc.php';
	class HTMLParser_Preformat extends HTMLParser
	{
		function openHandler(&$parser, $name, $attribs)
		{
			$name = strtolower($name);
			if (isset($this->dtd[$name])) {
				if (isset($this->dtd[$name]['replace'])) {
					$name = $this->dtd[$name]['replace'];
				}
				if ($this->_checkAttributes($name, $attribs)) {
					if (in_array($name, $this->tags_to_save)) {
						$this->_saveTag($name, $attribs);
					}
					if (!empty($this->current_node)) {
						if (!isset($this->node[$name])) {
							if ($name == 'form'
								and !in_array($name, $this->dtd[$this->current_node[0]]['children'])
								and in_array('table', $this->current_node)) {
								if (!in_array('form', $this->current_node)) {
									$limit = count($this->current_node);
									for ($i = 0; $i < $limit; $i++) {
										if ($this->current_node[$i] == 'table') {
											$this->_insertNode($name, $attribs, $i +1);
											break;
										}
									}
								}
							} else {
								$this->_elementLookup($name, $attribs);
							}
						}
					} elseif ($name != $this->root[0]) {
						$this->_appendNode(
							$this->root[0],
							(isset($this->root[1])? $this->root[1]: array())
						);
						$this->_elementLookup($name, $attribs);
					} else {
						$this->_appendNode($name, $attribs);
					}
				}
			}
		}
		function escapeHandler(&$parser, $data)
		{
			if (preg_match('/^--\/?pc2m_.+--$/', $data)) {
				$this->current_construct .= "<!$data>";
			}
		}
		function _checkAttributes($name, &$attribs)
		{
			if (!empty($attribs)) {
				$array = array();
				foreach ($attribs as $key => $value) {
					$key = strtolower($key);
					if (in_array($key, $this->dtd[$name]['attributes'])) {
						if (empty($value)
							and in_array($key, $this->html_minimized_attributes)) {
							$value = $key;
						} else {
							$this->_escapeChars($value);
						}
						if ($key == 'name') {
							switch ($name) {
								case 'input':
								case 'select':
								case 'textarea':
								case 'button':
									$value = str_replace('.', 'x2E', $value);
							}
						}
						$array[$key] = $value;
					}
				}
				$attribs = $array;
			}
			if (isset($this->dtd[$name]['required_attribute'])
				and !isset($attribs[$this->dtd[$name]['required_attribute']])) {
				return false;
			} else {
				return true;
			}
		}
	}
	$content = retrieveContent();
}
if (isset($_SESSION) and $remote_url and !$_is_error and !$_is_httperror and $_history_key !== null) {
	if (!isset($_SESSION['history'][$_history_key])) {
		$x = ($local_args['m'] == 'post' and 0 === strpos($remote_url, $local_args['u']));
		$_SESSION['history'][$_history_key] = array(
			time(),
			$remote_url,
			$title,
			$x? $_remote_args: null,
			$x? $local_args['m']: null,
			$x? $local_args['e']: null
		);
	} else {
		$_SESSION['history'][$_history_key][0] = time();
	}
}
if (isset($rss)) {
	$array = array_keys($rss);
	if (isset($array[0])) {
		$rss_url = $array[0];
	}
}
$title = mb_convert_kana($title, $_kana_convopt);
if (isset($_SESSION['authenticated'])) {
	$_session_save_path = realpath(session_save_path()).'/';
	$_session_filename = 'sess_'.session_id();
	$_backup_filename = 'pc2m_backup_'.$_SESSION['authenticated'];
	session_write_close();
	@copy($_session_save_path.$_session_filename, $_session_save_path.$_backup_filename);
}
ob_start();
	require $_template_path.'Template.inc.php';
	$_output_buffer = ob_get_contents();
	if (defined('DEBUG_MODE') and DEBUG_MODE === true) {
		$time_end = microtime_float();
		$elaps += ($time_end - $time_start);
		$time_start = $time_end;
		$stats = '<div>Length:'.number_format(ob_get_length()).'bytes<br />'.
			'Elapse:'.round($elaps, 2).'sec'.
			(function_exists('memory_get_usage')? '<br />Memory:'.number_format(memory_get_usage()).'bytes': null).'</div>';
		$_output_buffer = preg_replace('/<\/body>/', $stats.'</body>', $_output_buffer);
	}
	if ($client->preferred_markup == 'xhtml') {
		formatXhtml($_output_buffer);
	} else {
		formatHtml($_output_buffer);
	}
ob_end_clean();
echo mb_convert_encoding($_output_buffer, $output_enc, INT_ENC);

/* -------------------------------------------------------------------------
	retrieveContent
------------------------------------------------------------------------- */

function retrieveContent()
{
	global $output_enc;
	global $remote_url;
	global $local_args;
	global $allowed_urls;
	global $urls_to_redirect;
	global $quick_search;
	global $new_image;
	global $_raw_query;
	global $_remote_args;
	global $_history_key;
	global $_is_error;
	global $_kana_convopt;
	$local_args['m'] = strtolower($local_args['m']);
	if (($local_args['m'] and !$local_args['e'])
		or (!$local_args['m'] and $local_args['e'])) {
		return sayError('ERROR_ARG_INVALID');
	}
	if ($local_args['m'] and !preg_match('/^(?:post|get)$/', $local_args['m'])) {
		return sayError('ERROR_ARG_INVALID');
	}
	if ($local_args['e'] and null === checkCharset($local_args['e'])) {
		return sayError('ERROR_ARG_INVALID');
	}
	if (preg_match('/^[0-9a-f]{32}$/', $local_args['u'])) {
		if (isset($_SESSION['history'][$local_args['u']])) {
			if ($local_args['o'] === null) {
				return sayError('ERROR_CONFIRM_POST');
			}
			if ($local_args['o'] == '1') {
				$_remote_args = $_SESSION['history'][$local_args['u']][3];
			}
			$local_args['m'] = $_SESSION['history'][$local_args['u']][4];
			$local_args['e'] = $_SESSION['history'][$local_args['u']][5];
			$local_args['u'] = $_SESSION['history'][$local_args['u']][1];
			$_raw_query =& $local_args['u'];
		} else {
			return sayError('ERROR_NOHISTORY');
		}
	}
	$_post_data = array();
	if ($local_args['m'] != null and $local_args['e'] != null) {
		if (!$local_args['u']) {
			return sayError('ERROR_URL_EMPTY');
		}
		$_url = $local_args['u'].((null !== $local_args['y'])? '?'.$local_args['y']: null);
		list($_scheme) = explode(':',$_url);
		if (!preg_match('/^https?/', $_scheme)) {
			return sayError('ERROR_SCHEME_UNSUPPORTED', $_scheme);
		}
		if ($_scheme == 'https'
			and (!defined('SSL_ENABLED') or !SSL_ENABLED)) {
			return sayError('ERROR_SSL_DISABLED', $_url);
		}
		mb_convert_variables($local_args['e'], $output_enc, $_remote_args);
		if ($local_args['m'] == 'post') {
			foreach ($_remote_args as $key => $value) {
				$key = str_replace('x2E', '.', $key);
				if (preg_match('/^(.*)x78x79$/', $key, $matches)) {
					if ($matches[1] !== '') {
						$_post_data[$matches[1].'.x'] = '0';
						$_post_data[$matches[1].'.y'] = '0';
						$_post_data[$matches[1]] = $value;
					} else {
						$_post_data['x'] = '0';
						$_post_data['y'] = '0';
					}
				} else {
					$_post_data[$key] = $value;
				}
			}
		} else {
			$_net_url = new Net_URL($_url);
			foreach ($_remote_args as $key => $value) {
				$key = str_replace('x2E', '.', $key);
				if (is_array($value)) {
					$_net_url->addQueryString($key, $value);
				} elseif (preg_match('/^(.*)x78x79$/', $key, $matches)) {
					if ($matches[1] !== '') {
						$_net_url->addQueryString($matches[1].'.x', '0');
						$_net_url->addQueryString($matches[1].'.y', '0');
						$_net_url->addQueryString($matches[1], $value);
					} else {
						$_net_url->addQueryString('x', '0');
						$_net_url->addQueryString('y', '0');
					}
				} else {
					$_net_url->addQueryString($key, $value);
				}
			}
			$_url = $_net_url->getURL();
		}
	} elseif (defined('USE_DATABASE') and USE_DATABASE == true
		and preg_match('/^b([0-9a-f]{32})$/', $_raw_query, $matches)) {
		global $dbconf;
		switch ($dbconf['dbtype']) {
			case 'mysql':
				$_result = mysql_query("
					SELECT *
					FROM `$dbconf[prefix]urls`
					WHERE `keyid` = '$matches[1]'
				") or exit(mysql_error());
				$myrow = mysql_fetch_array($_result) or die('No such ID is registered.');
				$_url = urldecode($myrow['url']);
				if ($local_args['a'] != 'i') {
					mysql_query("
						UPDATE
						`$dbconf[prefix]urls`
						SET `lastupdated` = '".date('Y-m-d H:i:s')."'
						WHERE `keyid` = '$matches[1]'
					") or exit(mysql_error());
				}
				break;
			default:
				global $mdb2;
				$result = $mdb2->query("
					SELECT *
					FROM `$dbconf[prefix]urls`
					WHERE `keyid` = '$matches[1]'
				");
				if (PEAR::isError($result)) {
					exit ($mdb2->getMessage());
				}
				$myrow = $result->fetchRow(MDB2_FETCHMODE_ASSOC) or die('No such ID is registered.');
				$result->free();
				$_url = urldecode($myrow['url']);
				if ($local_args['a'] != 'i') {
					$result = $mdb2->query("
						UPDATE
						`$dbconf[prefix]urls`
						SET `lastupdated` = '".date('Y-m-d H:i:s')."'
						WHERE `keyid` = '$matches[1]'
					");
					if (PEAR::isError($result)) {
						exit ($mdb2->getMessage());
					}
					$result->free();
				}
		}
	} else {
		if (false === strpos($_raw_query, '?')
			and (preg_match('/%3A/i', $_raw_query)
				or preg_match('/%2E/i', $_raw_query)
				or preg_match('/%2F/i', $_raw_query))) {
			$_raw_query = urldecode($_raw_query);
		}
		if (preg_match('/^(\w+):\/*?(\w.+)/', $_raw_query, $matches)) {
			if (!preg_match('/^https?/', $matches[1])) {
				return sayError('ERROR_SCHEME_UNSUPPORTED', $matches[1]);
			}
			if ($matches[1] == 'https'
				and (!defined('SSL_ENABLED') or !SSL_ENABLED)) {
				return sayError('ERROR_SSL_DISABLED', $_raw_query);
			} else {
				$_url = $matches[1].'://'.$matches[2].((null !== $local_args['y'])? '?'.$local_args['y']: null);
			}
		} elseif (preg_match('/^[\w-]+\.[\w-]+/', $_raw_query)) {
				$_url = "http://$_raw_query".((null !== $local_args['y'])? '?'.urldecode($local_args['y']): null);
		} else {
			$_raw_query = mb_convert_kana(mb_convert_encoding(urldecode($_raw_query), INT_ENC, $output_enc), 'asKHV');
			if (defined('QUICK_SEARCH')) {
				if (preg_match('/^\s*(\w+)\s+(.*)$/', $_raw_query, $matches)) {
					$_search_key = strtolower($matches[1]);
					$_search_string = $matches[2];
				}
				if (!isset($_search_key) or !isset($quick_search[$_search_key])) {
					$_search_key = QUICK_SEARCH;
					$_search_string = $_raw_query;
				}
				$_url = $quick_search[$_search_key][0].
					urlencode(mb_convert_encoding($_search_string, $quick_search[$_search_key][1], INT_ENC));
			} else {
				return sayError('ERROR_URL_INVALID', $_raw_query);
			}
		}
	}
	$_url = str_replace("\x20", '%20', $_url);
	$array = parse_url($_url);
	if ((
			$array['host'] == $_SERVER['HTTP_HOST']
			or (
				isset($array['port'])
				and $array['host'].':'.$array['port'] == $_SERVER['HTTP_HOST']
			)
		) and (
			$array['path'] == $_SERVER['SCRIPT_NAME']
			or $array['path'] == dirname($_SERVER['SCRIPT_NAME'])
			or $array['path'] == dirname($_SERVER['SCRIPT_NAME']).'/'
		)) {
		header("Location:$_url");
		exit;
	}
	if (defined('RESTRICT_URL') and RESTRICT_URL === true) {
		if (isset($allowed_urls)) {
			if (!urlMatch($_url, $allowed_urls)) {
				$remote_url = $_url;
				return sayError('ERROR_URL_RESTRICTED', $_url);
			}
		}
		if (isset($urls_to_redirect)) {
			if (urlMatch($_url, $urls_to_redirect)) {
				$redirector = new Net_URL('r.php');
				header('Location:'.$redirector->getURL().'?'.urlencode($_url));
				exit;
			}
		}
	}
	$_content = sendRequest($_url, array(), $_post_data);
	if ($new_image or $_is_error) {
		return $_content;
	}
	if (preg_match_all('/<frame\b[^>]*?>/si', $_content, $matches)) {
		$_content = sendRequest(getAttribute('src', $matches[0][0]), array(), array(), true);
		$limit = count($matches[0]);
		for ($i = 1; $i < $limit; $i++) {
			$_content .= '<hr />'.sendRequest(getAttribute('src', $matches[0][$i]), array(), array(), true);
		}
	}
	$_content = mb_convert_kana($_content, $_kana_convopt);
	$_history_key = $remote_url;
	if ($local_args['m'] == 'post'
		and $remote_url == $local_args['u']) {
		$_net_url = new Net_URL($remote_url);
		foreach ($_remote_args as $key => $value) {
			$key = str_replace('x2E', '.', $key);
			if (is_array($value)) {
				$_net_url->addQueryString($key, $value);
			} else {
				$_net_url->addQueryString($key, $value);
			}
		}
		$_history_key = $_net_url->getURL();
	}
	$_history_key = md5($_history_key);
	if (false !== $_trim_from = mb_strpos($_content, '<!--pc2m_fragment-->')) {
		$_content = str_replace('<!--pc2m_fragment-->', null, $_content);
	} else {
		$_trim_from = 0;
	}
	if ($local_args['s'] != null) {
		if (!is_numeric($local_args['s']) or $local_args['s'] < 0) {
			$x = $local_args['s'];
			$x = preg_quote($x, '/');
			$x = str_replace("'", "\'", $x);
			$search = '/'.mb_convert_kana($x, $_kana_convopt).'/si';
			if (preg_match($search, $_content, $matches, PREG_OFFSET_CAPTURE)) {
				if (substr($_content, $matches[0][1] -1, 1) == '>') {
					$_trim_from = mb_strlen(substr($_content, 0, $matches[0][1] -1));
				} else {
					$_trim_from = mb_strlen(substr($_content, 0, $matches[0][1]));
				}
			} else {
				return sayError('ERROR_WORD_NOTFOUND', htmlspecialchars($local_args['s']));
			}
		} else {
			$_trim_from = $local_args['s'];
		}
	}
	trimContent($_content, $_trim_from);
	return $_content;
}

/* -------------------------------------------------------------------------
	sendRequest
------------------------------------------------------------------------- */

function sendRequest($_url, $_client_param = array(), $_post_data = array(), $_is_framesrc = false)
{
	global $client;
	global $remote_url;
	global $local_args;
	global $new_image;
	global $image_quality;
	global $alternative_http_headers;
	global $mime_types;
	global $_current_url;
	global $_remote_charset;
	global $_is_httperror;
	$_remote_charset = null;
	$_url = str_replace('&amp;', '&', $_url);
	if (isset($_SESSION)
		and $local_args['i'] !== null
		and $local_args['p'] !== null
		and $local_args['r'] !== null) {
		extract(parse_url($_url));
		$_SESSION['www_authenticate'][md5($host.$local_args['r'])] = array(
			'path' => getDirName($path),
			'user' => $local_args['i'],
			'pass' => $local_args['p']
		);
	}
	$_http_client = new HTTP_Client(
		$_client_param,
		array(
			'Accept-Charset' => 'Shift_JIS,utf-8;q=0.7,*;q=0.7',
			'Accept-Language' => 'ja'
		)
	);
	$_http_client->attach($_url_listener = new URL_Listener());
	if (null !== $local_args['b'] and isset($alternative_http_headers[$local_args['b'] -1])) {
		$_http_client->setDefaultHeader($alternative_http_headers[$local_args['b'] -1]['headers']);
	} elseif (defined('PEAR_USER_AGENT') and PEAR_USER_AGENT) {
		$_http_client->setDefaultHeader('User-Agent', PEAR_USER_AGENT);
	}
	if (isset($_SESSION['cookies'])) {
		foreach ($_SESSION['cookies'] as $key => $value) {
			$_http_client->_cookieManager->addCookie($value);
		}
	}
	if (isset($_SESSION['history'])
		and ($local_args['a'] == 'i' or (defined('PC2M_ALWAYS_SEND_REFERER') and PC2M_ALWAYS_SEND_REFERER))) {
		$array = sortMultiArray($_SESSION['history'], 0);
		foreach ($array as $key => $value) {
			if ($value[1] != $_url) {
				$_http_client->setDefaultHeader('Referer', $value[1]);
				break;
			}
		}
	}
	if (isset($_SESSION)) {
		session_write_close();
	}
	if (defined('DEBUG_MODE') and DEBUG_MODE) {
		global $elaps;
		global $time_start;
		$time_end = microtime_float();
		$elaps += ($time_end - $time_start);
	}
	if (!empty($_post_data)) {
		$_http_client->post($_url, $_post_data);
	} else {
		$_http_client->get($_url);
	}
	if (defined('DEBUG_MODE') and DEBUG_MODE) {
		$time_start = microtime_float();
	}
	if (isset($_SESSION)) {
		session_start();
	}
	if (null === $_response = $_http_client->currentResponse()) {
		if (!$_is_framesrc) {
			$remote_url = $_url;
		}
		return sayError('ERROR_SERVER_NORESPONSE', $_url);
	}
	if (isset($_SESSION)
		and 0 === strpos($_response['code'], '401')
		and preg_match('/^Basic\srealm="(.*)"$/i', $_response['headers']['www-authenticate'], $matches)) {
		$_realm = $matches[1];
		extract(parse_url($_url));
		$x = md5($host.$_realm);
		if (!isset($_client_param['user'])
			and !isset($_client_param['user'])
			and isset($_SESSION['www_authenticate'][$x]['user'])
			and isset($_SESSION['www_authenticate'][$x]['pass'])
			and isset($_SESSION['www_authenticate'][$x]['path'])
			and 0 === strpos(getDirName($path), $_SESSION['www_authenticate'][$x]['path'])) {
			$_client_param['user'] = $_SESSION['www_authenticate'][$x]['user'];
			$_client_param['pass'] = $_SESSION['www_authenticate'][$x]['pass'];
			return sendRequest($_url, $_client_param, $_post_data, $_is_framesrc);
		} elseif (SHOW_PASSINPUT) {
			if (!$_is_framesrc) {
				$remote_url = $_url;
			}
			return sayError('ERROR_AUTH_REQUIRED', $host, $_realm);
		}
	}
	if (!$_url_listener->getResults()) {
		return sayError('ERROR_SERVER_NORESPONSE', $_url);
	}
	$_current_url = parse_url($_url_listener->getResults());
	$_current_url['url'] = $_url_listener->getResults();
	if (0 === strpos($_current_url['url'], 'http://www.google.co.jp/accounts/SetSID?')) {
		global $script_self;
		header('Location:'.$script_self.KEY_PREFIX.'u='.$_current_url['url']);
		exit;
	}
	if (!$_is_framesrc) {
		$remote_url = $_current_url['url'];
	}
	$_is_httperror = ($_response['code'] != '200');
	if (isset($_current_url['fragment'])) {
		$local_args['f'] = $_current_url['fragment'];
	}
	if (isset($_SESSION)) {
		foreach ($_http_client->_cookieManager->_cookies as $key => $value) {
			$_SESSION['cookies'][$key] = $value;
		}
	}
	if (isset($mime_types) and isset($_current_url['path'])) {
		$search = '/^.+\.(\w+)$/';
		$x = basename(strtolower($_current_url['path']));
		if (preg_match($search, $x, $matches) and isset($mime_types[$matches[1]])) {
			$_response['headers']['content-type'] = $mime_types[$matches[1]];
		}
	}
	if (isset($_response['headers']['content-type'])) {
		preg_match('/^([a-z\/\.\+\-]+)(.*)$/', $_response['headers']['content-type'], $matches);
	}
	switch ($_ctype = isset($matches[1])? $matches[1]: null) {
		case null:
		case 'text/html':
		case 'text/xhtml';
		case 'application/xhtml+xml':
			if (isset($matches[2]) and preg_match('/^.*\bcharset\s*=\s*(.+)$/', $matches[2], $matches)) {
				$_remote_charset = checkCharset($matches[1]);
			}
			convertHTML($_response['body'], $_is_framesrc);
			return $_response['body'];
			break;
		case 'image/gif':
		case 'image/jpeg':
		case 'image/pjpeg':
		case 'image/png':
			if (!IMAGE_CONVERTER) {
				return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
			}
			if (isset($_response['headers']['content-length'])
				and is_numeric($_response['headers']['content-length'])
				and (int) $_response['headers']['content-length'] > ALLOWABLE_CLENGTH) {
				if (!$_is_framesrc) {
					$remote_url = $_url_listener->getResults();
				}
				return sayError('ERROR_CLENGTH_EXCEEDED',
					$_url_listener->getResults(),
					number_format($_response['headers']['content-length']),
					number_format(ALLOWABLE_CLENGTH));
			}
			if ($_is_framesrc) {
				return $local_args["v"]?
					'<img src="'.addImageProxyURL($_current_url['url']).'">':
					'['.mb_strimwidth(getFilename($_current_url['url']), 0, 11, "...").
						'<a href="'.addProxyURL($_current_url['url']).'">+</a>]';
			}
			if ($client->screen['color'] < 256) {
				return sayError('ERROR_COLOR_INCAPABLE');
			}
			if (false === $_resource = @imageCreateFromString($_response['body'])) {
				return sayError('ERROR_ISNOT_IMAGE', $_current_url['url']);
			}
			$_width = imageSx($_resource);
			$_height = imageSy($_resource);
			switch ($_ctype) {
				case 'image/gif';
					$_type = 1;
					break;
				case 'image/png':
					$_type = 3;
					break;
				default:
					$_type = 2;
			}
			$new_image = getNewImageInfo(array($_width, $_height, $_type));
			$image_quality = $new_image[3];
			if ($local_args['a'] == 'i') {
				transcodeImage($_resource, array($_width, $_height, $_type));
			} else {
				return '<img src="'.addImageProxyURL($_current_url['url']).'">';
			}
			break;
		case 'application/xml':
		case 'application/rdf+xml':
		case 'application/rss+xml':
		case 'text/xml':
			if (defined('RSS_ENABLED') and RSS_ENABLED === true) {
				return convertRSS($_response['body']);
			} else {
				return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
			}
			break;
		case 'text/plain':
			if (preg_match('/^\s*?<\?xml\b[^>]+?>\s*?<(?:rdf\:|rss\s|feed\s)[^>]+?>/si', $_response['body'])) {
				if (defined('RSS_ENABLED') and RSS_ENABLED === true) {
					return convertRSS($_response['body']);
				} else {
					return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
				}
			} else {
				$_response['body'] = str_replace("\x0", null, $_response['body']);
				$_response['body'] = preg_replace('/^\xef\xbb\xbf/', null , $_response['body']);
				return nl2br(htmlspecialchars(@mb_convert_encoding($_response['body'], INT_ENC, 'auto')));
			}
			break;
		default:
			return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
	}
}

/* -------------------------------------------------------------------------
	convertRSS
------------------------------------------------------------------------- */

function convertRSS(&$_content)
{
	global $remote_url;
	global $title;
	global $_remote_charset;
	if (preg_match('/^\s*$/s', $_content)) {
		$_content = sayError('ERROR_CONTENT_EMPTY');
		return false;
	}
	$_content = str_replace("\x0", null, $_content);
	$_content = preg_replace('/^\xef\xbb\xbf/', null , $_content);
	if (preg_match('/<\?xml\b[^>]+?\?>/si', $_content, $matches)) {
		$_xml_encoding = checkCharset(getAttribute('encoding', $matches[0]));
		$replace = '<?xml version="'.getAttribute('version', $matches[0]).'" encoding="UTF-8"?>';
		$_content = str_replace($matches[0], $replace, $_content);
	} else {
		$_content = '<?xml version="1.0" encoding="UTF-8"?>'.$_content;
	}
	if (!isset($_xml_encoding)) {
		$_xml_encoding = @mb_detect_encoding($_content);
	}
	switch ($_xml_encoding) {
		case 'SJIS':
		case 'Shift_JIS':
			$_xml_encoding = 'SJIS-win';
			break;
		case 'EUC-JP':
			$_xml_encoding = 'eucJP-win';
			break;
	}
	if ($_xml_encoding != 'UTF-8') {
		mb_convert_variables('UTF-8', $_xml_encoding, $_content);
	}
	require_once 'XML/RSS.php';
	$_xml_rss = new XML_RSS();
	$_xml_rss->setInputString($_content);
	if (PEAR::isError($_result = $_xml_rss->parse())) {
		$array = get_object_vars($_result);
		$_content = sayError('ERROR_XML_PARSEFAILED', $remote_url, $array['message']);
		return false;
	}
	if (!$_channel_info = $_xml_rss->getChannelInfo()) {
		$_content = sayError('ERROR_RSS_INVALID', $remote_url);
		return false;
	}
	if (INT_ENC != 'UTF-8') {
		$title = mb_convert_encoding($_channel_info['title'], INT_ENC, 'UTF-8');
	}
	$_content = '<p><a href="'.$_channel_info['link'].'">'.
		$_channel_info['title'].'</a>'.
			(isset($_channel_info['description'])? '<br />'.$_channel_info['description'].'</p>': '</p>');
	foreach ($_xml_rss->getItems() as $_item) {
		$_content .= '<p><a href="'.$_item['link'].'">'.$_item['title'].'</a>';
		if (isset($_item['dc:date'])) {
			$_time =& $_item['dc:date'];
		} elseif (isset($_item['pubdate'])) {
			$_time =& $_item['pubdate'];
		}
		if (isset($_time)) {
			if (-1 != $_unixtime = strtotime($_time)) {
				$_content .= '<br />'.date('Y/m/d H:i:s', $_unixtime).'</p>';
			} else {
				$_content .= '<br />'.$_time.'</p>';
			}
		} else {
			$_content .= '</p>';
		}
		if (isset($_item['content:encoded'])) {
			$_content .= '<p>'.$_item['content:encoded'].'</p>';
		} elseif (isset($_item['description'])) {
			$_content .= '<p>'.$_item['description'].'</p>';
		}
	}
	$_remote_charset = 'UTF-8';
	convertHTML($_content);
	return $_content;
}

/* -------------------------------------------------------------------------
	convertHTML
------------------------------------------------------------------------- */

function convertHTML(&$_content, $_is_framesrc = false)
{
	global $format_rule;
	global $client;
	global $output_enc;
	global $remote_url;
	global $rss_url;
	global $rss;
	global $mobile_url;
	global $title;
	global $local_args;
	global $force_trim;
	global $body_elements;
	global $form_hidden;
	global $urls_to_enable_accesskey;
	global $enable_accesskey;
	global $tags_to_remove;
	global $_current_url;
	global $_remote_charset;
	global $_base_href;
	global $_refresh_count;
	global $_is_error;
	global $_is_httperror;
	global $_kana_convopt;
	global $_element_serial;
	if ($_is_framesrc) {
		$local_args['l'] = 0;
	}
	if (isset($urls_to_enable_accesskey)
		and !urlMatch($remote_url, $urls_to_enable_accesskey)) {
		$enable_accesskey = false;
	}
	$_content = str_replace("\x0", null, $_content);
	$_content = preg_replace('/^\xef\xbb\xbf/', null , $_content);
	$_content = preg_replace('/<\?\w+[^>]*?>/si', null, $_content);
	$_content = preg_replace('/<!\[CDATA\[.*?\]\]>/si', null, $_content);
	$_content = preg_replace('/<!--(?!\/?pc2m_).*?-->/si', null, $_content);
	if (!isset($tags_to_remove) or empty($tags_to_remove)) {
		$tags_to_remove = array('script', 'style', 'iframe', 'noframes?');
	}
	foreach ($tags_to_remove as $value) {
		$_content = preg_replace('/<'.$value.'\b[^>]*?>.*?<\/'.$value.'\b[^>]*?>/si', null, $_content);
	}
	if (preg_match('/^\s*$/s', $_content)) {
		$_content = sayError('ERROR_CONTENT_EMPTY');
		return false;
	}
	$_content = preg_replace_callback(
		'/<textarea\b([^>]*?)>(.*?)<\/textarea\b[^>]*?>/si',
		create_function('$matches', '
			if (preg_match("/[<>]/", $matches[2])) {
				$matches[2] = htmlspecialchars($matches[2]);
			}
			return "<textarea".$matches[1].">".trim($matches[2])."</textarea>";
		'), $_content);
	$_content = preg_replace_callback(
		'/<pre\b[^>]*?>(.*?)<\/pre\b[^>]*?>/si',
		create_function('$matches', '
			return "<div>".nl2br(trim($matches[1]))."</div>";
		'), $_content);
	$_content = preg_replace_callback(
		'/<xmp\b[^>]*?>(.*?)<\/xmp\b[^>]*?>/si',
		create_function('$matches', '
			if (preg_match("/[<>]/", $matches[1])) {
				$matches[1] = htmlspecialchars($matches[1]);
			}
			return "<div>".nl2br(trim($matches[1]))."</div>";
		'), $_content);
	$_content = preg_replace_callback(
		'/<plaintext\b[^>]*?>(.*)$/si',
		create_function('$matches', '
			if (preg_match("/[<>]/", $matches[1])) {
				$matches[1] = htmlspecialchars($matches[1]);
			}
			return "<div>".nl2br(trim($matches[1]))."</div>";
		'), $_content);
	$_content = preg_replace('/<div\sclass=n[crn]><\/div>/s', null, $_content);
	if ($_remote_charset === null) {
		if (preg_match_all('/<meta\b[^>]*?>/si', $_content, $matches)) {
			$array = array();
			$limit = count($matches[0]);
			for ($i = 0; $i < $limit; $i++) {
				$array[$i] = array(
					strtolower(getAttribute('http-equiv', $matches[0][$i])),
					getAttribute('content', $matches[0][$i])
				);
			}
			foreach ($array as $value) {
				if ($value[0] == 'content-type') {
					if (preg_match('/\bcharset\s*=\s*([^;]+)/si', $value[1], $matches)) {
						$_remote_charset = checkCharset(trim($matches[1]));
					}
					break;
				}
			}
		}
	}
	if ($_remote_charset === null) {
		$_remote_charset = @mb_detect_encoding($_content);
	}
	if (INT_ENC != 'UTF-8') {
		mb_convert_variables(INT_ENC, $_remote_charset, $_content);
	} else {
		switch ($_remote_charset) {
			case 'Shift_JIS':
			case 'SJIS':
				mb_convert_variables(INT_ENC, 'SJIS-win', $_content);
				break;
			case 'EUC-JP':
				mb_convert_variables(INT_ENC, 'eucJP-win', $_content);
				break;
			default:
			mb_convert_variables(INT_ENC, $_remote_charset, $_content);
		}
	}
	if (!$_is_framesrc) {
		if (preg_match_all('/<frame\b[^>]*?>/si', $_content, $matches)) {
			$_content = null;
			$limit = count($matches[0]);
			for ($i = 0; $i < $limit; $i++) {
				if (null !== $_url = getAttribute("src", $matches[0][$i])) {
					$_content .= '<frame src="'.transAbsolutePath($_url).'">';
				}
			}
			if ($_content !== null) {
				return true;
			}
		}
	}
	$search = null;
	if ($local_args['f'] !== null) {
		$_fragment = preg_quote($local_args['f']);
		$_fragment = str_replace("'", "\'", $_fragment);
		$_id_search = true;
	} elseif (defined('FORCE_TRIM') and FORCE_TRIM === true) {
		foreach ($force_trim as $key => $value) {
			if (false !== strpos(strtolower($remote_url), strtolower($key))) {
				$_fragment = is_array($value[0])? '(?:'.implode('|', $value[0]).')': $value[0];
				$_id_search = $value[1]? true: false;
				break;
			}
		}
	}
	if (isset($_fragment)) {
		if ($_id_search) {
			$search = "'^(.*?)(<\w+\b[^>]*?\b(?:name|id)\s*?=\s*?[\'\"]?".$_fragment."[\'\"\s>].*)$'si";
		} else {
			$search = "'^(.*?)(".$_fragment.".*)$'s";
		}
		if (preg_match($search, $_content, $matches)) {
			$_content = "$matches[1]<!--pc2m_fragment-->$matches[2]";
		}
	}
	if (INT_ENC != 'UTF-8') {
		mb_convert_variables('UTF-8', INT_ENC, $_content);
	}
	$parser = new HTMLParser_Preformat;
	if ($local_args['a'] == 'c') {
		$format_rule = require 'FormatRule_Text.inc.php';
	}
	$parser->setRule($format_rule);
	$parser->setRoot('html');
	$parser->setGenericParent('body');
	$parser->setTagsToSave('base', 'meta', 'link', 'body');
	$parser->parse($_content);
	$_content = $parser->dump(INT_ENC);
	$_saved_tags = $parser->getSavedTags(INT_ENC);
	if ($local_args['a'] == 'c') {
		$_content = preg_replace(
			array(
				'/<(?:\/?div|br\s\/)>/',
				'/<hr\s\/>/',
				'/\t/',
				'/\x20{2,}/',
				'/\n\x20+/',
				'/\n{3,}/'
			),
			array(
				"\n",
				'----------',
				'',
				"\x20",
				"\n",
				"\n\n"
			),
		$_content);
		$_content = strip_tags($_content);
		replaceChars($_content);
		$_element_serial = 2;
		$x = '<form action="'.basename($_SERVER['SCRIPT_NAME']).'" 1>';
		$i = 0;
		while ($i < mb_strlen($_content)) {
			$_trimmed_segment = mb_strimwidth($_content, $i, 200, null);
			$x .= "<textarea $_element_serial>".trim($_trimmed_segment)."</textarea $_element_serial>";
			$i += mb_strlen($_trimmed_segment);
			$_element_serial++;
		}
		$x .= '</form 1>';
		$_content = $x;
		return true;
	}
	$_base_href = null;
	if (isset($_saved_tags['base'])) {
		foreach ($_saved_tags['base'] as $value) {
			if (isset($value['href'])) {
				$_base_href = transAbsolutePath($value['href']);
				break;
			}
		}
	}
	if (isset($_saved_tags['meta'])) {
		foreach ($_saved_tags['meta'] as $value) {
			if (isset($value['http-equiv'])
				and isset($value['content'])
				and strtolower($value['http-equiv']) == 'refresh') {
				if (preg_match('/^\d*\s*;?\s*url\s*=\s*([^\s]+)/i', $value['content'], $matches)) {
					$url = removeQuote(preg_replace('/^&quot;\s*(.+)\s*&quot;$/si', '$1', $matches[1]));
					$url = transAbsolutePath($url);
					if (preg_match('/^http/i', $url)
						and $_current_url['url'] != $url
						and $_refresh_count < MAX_META_REDIRECT) {
						$_refresh_count++;
						$_content = sendRequest($url, array(), array(), $_is_framesrc);
						return true;
					}
					break;
				}
			}
		}
	}
	if (isset($_saved_tags['link'])) {
		foreach ($_saved_tags['link'] as $value) {
			if (isset($value['media'])
				and isset($value['href'])
				and strtolower($value['media']) == 'handheld') {
				$mobile_url = transAbsolutePath($value['href']);
			} elseif (defined('RSS_ENABLED') and RSS_ENABLED === true
				and isset($value['rel'])
				and isset($value['href'])
				and isset($value['type'])
				and strtolower($value['rel']) == 'alternate'
				and preg_match('/^application\/(?:rss\+|rdf\+)?xml$/', $value['type'])) {
				$url = transAbsolutePath($value['href']);
				$_title = isset($value['title'])? $value['title']: getFilename($url);
				$url = addProxyURL($url);
				if (!isset($rss[$url])) {
					$rss[$url] = mb_convert_kana($_title, $_kana_convopt);
				}
			}
		}
	}
	if (!$_is_framesrc
		and preg_match_all('/<title>(.*?)<\/title>/s', $_content, $matches)) {
		$limit = count($matches[0]);
		for ($i = 0; $i < $limit; $i++) {
			$title = preg_replace('/(?:\r\n|\n)/', '', $matches[1][$i]);
			if ($title) {
				replaceChars($title);
				$title = mb_strimwidth($title, 0, 64, '...');
				if ($_is_httperror) {
					$_content = "$title<hr />$_content";
				}
				break;
			}
		}
	}
	if (false === strpos($_content, '<frame')) {
		$_content = preg_replace('/<body\b[^>]*?>/s', '<body>', $_content);
		$pos = strpos($_content, '<body>') +6;
		$_content = substr_replace($_content, '', 0, $pos);
		$pos = strrpos($_content, '</body>');
		$_content = substr_replace($_content, '', $pos);
	} else {
		$_content = preg_replace('/^.*<frameset\b[^>]*?>(.*?)<\/frameset>.*$/s', '$1', $_content);
	}
	$_content = preg_replace('/<!--pc2m_void-->.*?<!--\/pc2m_void-->/s', null, $_content);
	$_content = preg_replace('/<\/?map>/s', null, $_content);
	$_content = mb_decode_numericentity(
		preg_replace('/&#x([0-9a-fA-F]+);/e', '"&#".hexdec("\\1").";"', $_content),
		array(0x0021, 0x007E, 0x0000, 0xFFFF)
	);
	$_content = preg_replace('/<su[pb]>/s', '(', $_content);
	$_content = preg_replace('/<\/su[pb]>/s', ')', $_content);
	if ($local_args['a'] != 'c' and $local_args['l']
		and isset($_saved_tags['body'])) {
		$body_elements['background'] = null;
		$body_elements['bgcolor'] = null;
		$body_elements['text'] = null;
		$body_elements['link'] = null;
		$body_elements['alink'] = null;
		$body_elements['vlink'] = null;
		foreach ($_saved_tags['body'] as $value) {
			if ($local_args['v']
				and null === $body_elements['background'] and isset($value['background'])) {
				$body_elements['background'] = addImageProxyURL(transAbsolutePath($value['background']));
			}
			if (null === $body_elements['bgcolor'] and isset($value['bgcolor'])) {
				$body_elements['bgcolor'] = $value['bgcolor'];
				checkColorValue($body_elements['bgcolor']);
			}
			if (null === $body_elements['text'] and isset($value['text'])) {
				$body_elements['text'] = $value['text'];
				checkColorValue($body_elements['text']);
			}
			if (null === $body_elements['link'] and isset($value['link'])) {
				$body_elements['link'] = $value['link'];
				checkColorValue($body_elements['link']);
			}
			if (null === $body_elements['alink'] and isset($value['alink'])) {
				$body_elements['alink'] = $value['alink'];
				checkColorValue($body_elements['alink']);
			}
			if (null === $body_elements['vlink'] and isset($value['vlink'])) {
				$body_elements['vlink'] = $value['vlink'];
				checkColorValue($body_elements['vlink']);
			}
		}
		if ($body_elements['link'] == $body_elements['alink']) {
			$body_elements['alink'] = null;
		}
	}
	$_remains = array();
	$search = array();
	$replace = array();
	if (preg_match_all('/<!--pc2m_remain-->(.+?)<!--\/pc2m_remain-->/si', $_content, $matches)) {
		$limit = count($matches[0]);
		for ($i = 0; $i < $limit; $i++) {
			$_remains[] = $matches[1][$i];
			$search[] = $matches[0][$i];
			$replace[] = '<!--pc2m_untouch_'.(count($_remains) -1).'-->';
		}
	}
	if ($replace) {
		$_content = str_replace($search, $replace, $_content);
	}
	if (!$local_args['l']) {
		$array = array(
			'span', 'em', 'strong',
			'dfn', 'code', 'samp', 'kbd', 'var', 'cite', 'abbr', 'acronym', 'q',
			'i', 'b', 'big', 'small', 'u', 'font'
		);
		foreach ($array as $value) {
			$_content = preg_replace('/<\/?'.$value.'\b[^>]*?>/s', null, $_content);
		}
	} else {
		$_content = preg_replace('/<\/?span\b[^>]*?>/s', null, $_content);
		$_content = preg_replace_callback(
			'/<font\b[^>]*?>/si',
			create_function('$matches', '
				global $client;
				if (null !== $_color = getAttribute("color", $matches[0])) {
					checkColorValue($_color);
				}
				if (null !== $_size = getAttribute("size", $matches[0])) {
					$_size = preg_match("/^\d$/", $_size)? $_size: (int) $_size +3;
					if ($client->preferred_markup == "xhtml") {
						switch ($_size) {
							case 1:
								$_size = "xx-small";
								break;
							case 2:
								$_size = "x-small";
								break;
							case 3:
								$_size = "small";
								break;
							case 4:
								$_size = "medium";
								break;
							case 5:
								$_size = "large";
								break;
							case 6:
								$_size = "x-large";
								break;
							case 7:
								$_size = "xx-large";
								break;
						}
					}
				}
				if ($client->preferred_markup == "xhtml") {
					$array = array();
					if ($_size) {
						$array[] = "font-size:".$_size;
					}
					if ($_color) {
						$array[] = "color:".$_color;
					}
					return "<span".
						(!empty($array)? " style=\"".implode(";", $array)."\"": null).
						">";
				} else {
					return "<font".
						($_size? " size=\"".$_size."\"": null).
						($_color? " color=\"".$_color."\"": null).
						">";
				}
			'), $_content);
		if ($client->preferred_markup == 'xhtml') {
			$_content = preg_replace('/<\/font\b[^>]*?>/si', '</span>', $_content);
		} else {
			$_content = preg_replace('/<big>/s', '<font size="4">', $_content);
			$_content = preg_replace('/<small>/s', '<font size="2">', $_content);
			$_content = preg_replace('/<\/(?:big|small)>/s', '</font>', $_content);
			$_content = preg_replace('/<(\/?)em>/s', '<$1i>', $_content);
			$_content = preg_replace('/<(\/?)strong>/s', '<$1b>', $_content);
			$_content = preg_replace('/<\/?(?:dfn|code|samp|kbd|var|cite|abbr|acronym|q)>/s', null, $_content);
		}
	}
	if (defined('CONVERT_INDENT_TAGS') and CONVERT_INDENT_TAGS) {
		$search = array(
			'/<(\/?)(?:dl|dt|dd)>/',
			'/<\/?blockquote>/',
		);
		$replace = array(
			'<\\1p>',
			'<hr />',
		);
		$_content = preg_replace($search, $replace, $_content);
	}
	if (getTagPairs('li', $_content, $nodes)) {
		$search = array();
		$replace = array();
		foreach ($nodes as $node) {
			if (!preg_match('/<li\b[^>]*?>/', $_content)
				and preg_match('/<p\b[^>]*?>/s', $_content)) {
				$search[] = $node;
				$replace[] = preg_replace('/<(\/?)p\b[^>]*?>/s', '<$1div>', $node);
			}
		}
		$limit = count($search);
		for ($i = 0; $i < $limit; $i++) {
			if (false !== $offset = strpos($_content, $search[$i])) {
				$_content = substr_replace($_content, $replace[$i], $offset, strlen($search[$i]));
			}
		}
	}
	$_content = preg_replace_callback(
		'/<input\b[^>]+?>/s',
		create_function('$matches', '
			global $enable_accesskey;
			$_type = getAttribute("type", $matches[0]);
			$_name = getAttribute("name", $matches[0]);
			$_size = getAttribute("size", $matches[0]);
			$_maxlength = getAttribute("maxlength", $matches[0]);
			if (null !== $_value = getAttribute("value", $matches[0])) {
				if (preg_match("/[<>]/", $_value)) {
					$_value = htmlspecialchars($_value);
				}
			}
			$_accesskey = $enable_accesskey? getAttribute("accesskey", $matches[0]): null;
			$_istyle = getAttribute("istyle", $matches[0]);
			$_checked = getAttribute("checked", $matches[0]);
			if ($_name == "__VIEWSTATE" and strlen($_value) > 1000) {
				return null;
			}
			switch (strtolower($_type)) {
				case "image":
					$_name .= "x78x79";
					$_type = "submit";
					if (null === $_value = getAttribute("alt", $matches[0])) {
						$_value = "SUBMIT";
					}
					break;
				case "submit":
					if (!$_value) {
						$_value = "SUBMIT";
					}
					break;
				case "button":
					$_type = "submit";
					break;
				case "password":
					if (!isset($_SESSION) or !SHOW_PASSINPUT) {
						$x = "<font color=\"#ff0000\">".sayError("ERROR_PASSINPUT_DISABLED")."</font>";
						global $_is_error;
						$_is_error = false;
						return $x;
					} else {
						$_type = "text";
						if ($_istyle === null) {
							$_istyle = "3";
						}
					}
					break;
			}
			return "<input".
				($_type? " type=\"".$_type."\"": null).
				((null !== $_name)? " name=\"".$_name."\"": null).
				((null !== $_size)? " size=\"".$_size."\"": null).
				((null !== $_maxlength)? " maxlength=\"".$_maxlength."\"": null).
				((null !== $_value)? " value=\"".$_value."\"": null).
				((null !== $_accesskey)? " accesskey=\"".$_accesskey."\"": null).
				((null !== $_istyle)? " istyle=\"".$_istyle."\"": null).
				($_checked? " checked=\"".$_checked."\"": null).
				" />";
		'), $_content);
	$_content = preg_replace_callback(
		'/<button\b([^>]*?)>(.*?)<\/button>/s',
		create_function('$matches', '
			global $enable_accesskey;
			$_type = getAttribute("type", $matches[1]);
			if (strtolower($_type) != "submit") {
				$_type = "submit";
			}
			$_name = getAttribute("name", $matches[1]);
			if (null !== $_value = getAttribute("value", $matches[1])) {
				if (preg_match("/[<>]/", $_value)) {
					$_value = htmlspecialchars($_value);
				}
			}
			$_accesskey = $enable_accesskey? getAttribute("accesskey", $matches[1]): null;
			if (strtolower($_type) == "button") {
				$_type = "submit";
			}
			if (null === $_value) {
				return
					"<input type=\"".$_type."\"".
					($_name? " name=\"".$_name."\"": null).
					" value=\"".strip_tags($matches[2])."\"".
					((null !== $_accesskey)? " accesskey=\"".$_accesskey."\"": null).
					" />";
			} else {
				return "<input type=\"hidden\"".
					($_name? " name=\"".$_name."\"": null).
					" value=\"".$_value."\"><input type=\"".$_type."\"".
					" value=\"".strip_tags($matches[2])."\"".
					((null !== $_accesskey)? " accesskey=\"".$_accesskey."\"": null).
					" />";
			}
		'), $_content);
	$_content = preg_replace_callback(
		'/<form\b[^>]*?>/s',
		create_function('$matches', '
			global $client;
			global $_current_url;
			global $form_hidden;
			global $_remote_charset;
			if (null === $_action = getAttribute("action", $matches[0])) {
				$_action = $_current_url["url"];
			}
			$_action = transAbsolutePath($_action);
			if (null === $_method = getAttribute("method", $matches[0])) {
				$_method = "get";
			}
			if (null !== getAttribute("utn", $matches[0])) {
				return "<form action=\"".$_action."\" method=\"".$_method."\">";
			} else {
				return "<form action=\"".basename($_SERVER["SCRIPT_NAME"])."\"".
					" method=\"".($client->is_postcapable? "post": "get")."\"".
					">".
					$form_hidden.
					"<input type=\"hidden\" name=\"".KEY_PREFIX."e\" value=\"".$_remote_charset."\" />".
					"<input type=\"hidden\" name=\"".KEY_PREFIX."m\" value=\"".$_method."\" />".
					"<input type=\"hidden\" name=\"".KEY_PREFIX."u\" value=\"".$_action."\" />";
			}
		'), $_content);
	$_content = preg_replace_callback(
		'/(<a\b[^>]+?>)(.*?)<\/a>/s',
		create_function('$matches', '
			global $enable_accesskey;
			global $client;
			global $local_args;
			$_link_url = getAttribute("href", $matches[1]);
			if ($_link_url and $_link_url != "#") {
				$_link_url = transAbsolutePath($_link_url);
				$_accesskey = $enable_accesskey? getAttribute("accesskey", $matches[1]): null;
				$_title = getAttribute("title", $matches[1]);
			}
			$_valid_url = preg_match("/^(?:https?|mailto|tel)/", $_link_url);
			$_link = $_valid_url?
				"<a href=\"".addProxyURL($_link_url)."\"".
				($_accesskey? " accesskey=\"".$_accesskey."\"": null).">": null;
			$_link_close = $_valid_url? "</a>": null;
			$_inner_element = preg_replace("/<(?:p|ul|ol|li|dl|dt|dd)\b[^>]*?>/si", null, trim($matches[2]));
			$_inner_element = preg_replace("/<\/(?:p|ul|ol|li|dl|dt|dd)\b[^>]*?>/si", "<br />", $_inner_element);
			if (!preg_match_all("/<img\b[^>]+?>/si", $_inner_element, $matches)) {
				return $_link.$_inner_element.$_link_close;
			} else {
				if (IMAGE_CONVERTER and $local_args["v"]) {
					if (preg_match_all("/<img\b[^>]*?>/si", $_inner_element, $matches)) {
						$limit = count($matches[0]);
						for ($i = 0; $i < $limit; $i++) {
							$_url = transAbsolutePath(getAttribute("src", $matches[0][$i]));
							$_width = getAttribute("width", $matches[0][$i]);
							$_align = null;
							if ($local_args["l"]) {
								$_align = getAttribute("align", $matches[0][$i]);
							}
							$_max_image_width = $local_args["w"]? $local_args["w"]: $client->screen["width"];
							if ($_max_image_width > ALLOWABLE_PIXSIZE) {
								$_max_image_width = ALLOWABLE_PIXSIZE;
							}
							if ($local_args["v"] == 2
								or (!$_width
								or !is_numeric($_width)
								or $_width > $_max_image_width)) {
								$_url = addImageProxyURL($_url);
							}
							$replace = "<img src=\"".$_url."\"".
								($_align? " align=\"".$_align."\"": null).
								" pc2m_converted />";
							$_inner_element = str_replace($matches[0][$i], $replace, $_inner_element);
						}
					}
					return $_link.$_inner_element.$_link_close;
				}
				$limit = count($matches[0]);
				for ($i = 0; $i < $limit; $i++) {
					$_url = getAttribute("src", $matches[0][$i]);
					$_width = getAttribute("width", $matches[0][$i]);
					$_height = getAttribute("height", $matches[0][$i]);
					$_alt = getAttribute("alt", $matches[0][$i]);
					if ($_alt === null and isset($_title)) {
						$_alt = $_title;
					}
					if ($_alt === null) {
						$_alt = getAttribute("name", $matches[0][$i]);
					}
					if ($_alt === null) {
						$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
					} else {
						$_alt = preg_replace("/^\[(.+)\]$/", "$1", $_alt);
					}
					if (($_width or $_height)
						and (!is_numeric($_width.$_height)
						or (defined("IMG_THRESHOLD") and is_int(IMG_THRESHOLD)
						and (($_width and (int) $_width < IMG_THRESHOLD)
						or ($_height and (int) $_height < IMG_THRESHOLD))))) {
						$replace = "[".$_link.$_alt.$_link_close."]";
					} else {
						$replace = "[".$_link.$_alt.$_link_close.
							"<a href=\"".addProxyURL(transAbsolutePath($_url))."\">+</a>]";
					}
					$_result = str_replace($matches[0][$i], $replace, $_inner_element);
				}
				if (preg_match("/^(.+?)(\[.+)/s", $_result, $matches)) {
					if (preg_match("/^\s*(?:<br\b[^>]*?>\s*){0,}\s*$/s", $matches[1])) {
						$_result = "<br />".$matches[2];
					} elseif (!preg_match("/^\s+$/s", $matches[1])) {
						$_result = $_link.$matches[1].$_link_close.$matches[2];
					}
				}
				if (preg_match("/^(.+\])(.+)$/s", $_result, $matches)) {
					if (preg_match("/^\s*(?:<br\b[^>]*?>\s*){0,}\s*$/s", $matches[2])) {
						$_result = $matches[1]."<br />";
					} elseif (!preg_match("/^\s+$/s", $matches[2])) {
						$_result = $matches[1].$_link.$matches[2].$_link_close;
					}
				}
				if (preg_match_all("/\](.+?)\[/s", $_result, $matches)) {
					$limit = count($matches[0]);
					for ($i = 0; $i < $limit; $i++) {
						if (preg_match("/^\s*(?:<br\b[^>]*?>\s*){0,}\s*$/s", $matches[1][$i])) {
							$replace = "]<br />[";
						} elseif (!preg_match("/^\s+$/s", $matches[1][$i])) {
							$replace = "]".$_link.$matches[1][$i].$_link_close."[";
						}
						$_result = str_replace($matches[0][$i], $replace, $_result);
					}
				}
				return $_result;
			}
		'), $_content);
	$_content = preg_replace_callback(
		'/<img\b[^>]*?>/si',
		create_function('$matches', '
			global $client;
			global $local_args;
			if ($local_args["v"] and false !== strpos($matches[0], " pc2m_converted")) {
				return str_replace(" pc2m_converted", null, $matches[0]);
			}
			$_url = getAttribute("src", $matches[0]);
			$_width = getAttribute("width", $matches[0]);
			$_height = getAttribute("height", $matches[0]);
			if (($_width or $_height)
				and (!is_numeric($_width.$_height)
				or (defined("IMG_THRESHOLD")
				and (($_width and (int) $_width < IMG_THRESHOLD)
				or ($_height and (int) $_height < IMG_THRESHOLD))))) {
				return null;
			}
			if (IMAGE_CONVERTER and $local_args["v"]) {
				$_url = transAbsolutePath($_url);
				$_align = null;
				if ($local_args["l"]) {
					$_align = getAttribute("align", $matches[0]);
				}
				$_max_image_width = $local_args["w"]? $local_args["w"]: $client->screen["width"];
				if ($_max_image_width > ALLOWABLE_PIXSIZE) {
					$_max_image_width = ALLOWABLE_PIXSIZE;
				}
				if ($local_args["v"] == 2
					or (!$_width
					or !is_numeric($_width)
					or $_width > $_max_image_width)) {
					$_url = addImageProxyURL($_url);
				}
				return "<img src=\"".$_url."\"".
					($_align? " align=\"".$_align."\"": null).
					" />";
			} else {
				$_alt = getAttribute("alt", $matches[0]);
				if ($_alt === null) {
					$_alt = getAttribute("title", $matches[0]);
				}
				if ($_alt === null) {
					$_alt = getAttribute("name", $matches[0]);
				}
				if ($_alt === null) {
					$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
				} else {
					$_alt = preg_replace("/^\[(.+)\]$/", "$1", $_alt);
				}
				$_url = addProxyURL(transAbsolutePath($_url));
				return "[{$_alt}<a href=\"{$_url}\">+</a>]";
			}
		'), $_content);
	$_content = preg_replace_callback(
		'/<area\b[^>]+?>/si',
		create_function('$matches', '
			global $enable_accesskey;
			$_url = getAttribute("href", $matches[0]);
			if (null === $_url or $_url == "#") {
				return null;
			} else {
				$_accesskey = $enable_accesskey? getAttribute("accesskey", $matches[0]): null;
				if (null === $_alt = getAttribute("alt", $matches[0])) {
					if (null === $_alt = getAttribute("title", $matches[0])) {
						$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
					}
				}
				$_url = transAbsolutePath($_url);
				return preg_match("/^(?:https?|mailto|tel)/", $_url)?
					"<a href=\"".addProxyURL($_url)."\"".
					($_accesskey? " accesskey=\"".$_accesskey."\"": null).
					">".$_alt."</a>":
					null;
			}
		'), $_content);
	$_content = preg_replace_callback(
		'/<frame\b[^>]+?>/si',
		create_function('$matches', '
			$_url = getAttribute("src", $matches[0]);
			if (null === $_url) {
				return null;
			} else {
				if (null === $_alt = getAttribute("name", $matches[0])) {
					if (null === $_alt = getAttribute("title", $matches[0])) {
						$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
					}
				}
				return "<a href=\"".addProxyURL(transAbsolutePath($_url))."\"".
					">".$_alt."</a>";
			}
		'), $_content);
	$tags = array('div', 'center', 'textarea', 'select', 'option', 'ul', 'ol');
	if (!defined('CONVERT_INDENT_TAGS') or !CONVERT_INDENT_TAGS) {
		array_push($tags, 'blockquote', 'dl', 'dd');
	}
	if ($local_args['l']) {
		switch ($client->preferred_markup) {
			case 'chtml':
				array_push($tags, 'font');
				break;
			default:
				array_push($tags, 'span');
		}
	}
	foreach ($tags as $tag) {
		if (getTagPairs($tag, $_content, $nodes)) {
			$search = array();
			$replace = array();
			foreach ($nodes as $node) {
				preg_match('/^(<'.$tag.'\b[^>]*?)>(.*)(<\/'.$tag.')>/si', $node, $matches);
				$search[] = $node;
				$replace[] = "$matches[1] $_element_serial>$matches[2]$matches[3] $_element_serial>";
				$_element_serial++;
			}
			$limit = count($search);
			for ($i = 0; $i < $limit; $i++) {
				if (false !== $offset = strpos($_content, $search[$i])) {
					$_content = substr_replace($_content, $replace[$i], $offset, strlen($search[$i]));
				}
			}
		}
	}
	if ($local_args['l']) {
		$tags = array('td', 'th', 'tr', 'table');
		foreach ($tags as $tag) {
			if (getTagPairs($tag, $_content, $nodes)) {
				$search = array();
				$replace = array();
				foreach ($nodes as $node) {
					preg_match('/^(<'.$tag.'\b[^>]*?)>(.*)(<\/'.$tag.')>/si', $node, $matches);
					if ((null !== $_bgcolor = getAttribute('bgcolor', $matches[1])
						and true === checkColorValue($_bgcolor))) {
						$search[] = $node;
						$replace[] = "<coloredblock bgcolor=\"$_bgcolor\" $_element_serial>$matches[2]</coloredblock $_element_serial>";
						$_element_serial++;
					}
				}
				$limit = count($search);
				for ($i = 0; $i < $limit; $i++) {
					if (false !== $offset = strpos($_content, $search[$i])) {
						$_content = substr_replace($_content, $replace[$i], $offset, strlen($search[$i]));
					}
				}
			}
		}
	}
	if (getTagPairs('tr', $_content, $nodes)) {
		$search = array();
		$replace = array();
		foreach ($nodes as $node) {
			preg_match('/^(<tr\b[^>]*?)>(.*)(<\/tr)>/si', $node, $matches);
			$search[] = $node;
			$replace[] = '<div align="left"'.
				" $_element_serial>$matches[2]</div $_element_serial>";
			$_element_serial++;
		}
		$limit = count($search);
		for ($i = 0; $i < $limit; $i++) {
			if (false !== $offset = strpos($_content, $search[$i])) {
				$_content = substr_replace($_content, $replace[$i], $offset, strlen($search[$i]));
			}
		}
	}
	$_content = preg_replace('/<\/?table\b[^>]*?>/si', null, $_content);
	$search = array(
		'/<\/t[hd]>\s*<t[hd]\b[^>]*?>/s',
		'/<\/?t[hd]\b[^>]*?>/s',
		'/<(\/)caption\b[^>]*?>/s',
	);
	$replace = array(
		"\x20",
		'',
		'<\\1div>'
	);
	$_content = preg_replace($search, $replace, $_content);
	if ($client->preferred_markup == 'xhtml') {
		$_content = preg_replace('/<coloredblock\sbgcolor="([^"]+)"\s(\d+)>/',
			'<div align="left" style="padding:1px;background-color:$1" $2>', $_content);
		$_content = preg_replace('/<\/coloredblock\s(\d+)>/',
			'</div $1>', $_content);
	} else {
		$_content = preg_replace('/<coloredblock\sbgcolor="([^"]+)"\s(\d+)>/',
			'<table width="100%" bgcolor="$1" $2><tr $2r><td $2d>', $_content);
		$_content = preg_replace('/<\/coloredblock\s(\d+)>/',
			'</td $1d></tr $1r></table $1>', $_content);
	}
	$search = '/<((?!textarea))\b[^>]*?(?<!\/)>\s*(?:<br\b[^>]*?>\s*){0,}\s*<\/((?!textarea))\b[^>]*?>/s';
	while (preg_match($search, $_content, $matches)
		and $matches[1] == $matches[2]) {
		$_content = preg_replace($search, null, $_content);
	}
	$search = array(
		"'(?:<hr\b[^>]*?>\s*){2,}'si",
		"'(?:<br\b[^>]*?>\s*){3,}'si",
		"'(?:<p\b([^>]*?)>\s*){2,}'si",
		"'(?:<\/p\b[^>]*?>\s*){2,}'si",
	);
	$replace = array(
		"<hr />",
		"<br /><br />",
		"<p\\1>",
		"</p>",
	);
	$_content = preg_replace($search, $replace, $_content);
	replaceChars($_content);
	if ($_remains) {
		$limit = count($_remains);
		for ($i = 0; $i < $limit; $i++) {
			$_content = str_replace("<!--pc2m_untouch_$i-->", $_remains[$i], $_content);
		}
	}
	if (preg_match('/^\s*$/s', $_content)) {
		$_content = sayError('ERROR_CONTENT_EMPTY');
		return false;
	}
	return true;
}

/* -------------------------------------------------------------------------
	trimContent
------------------------------------------------------------------------- */

function trimContent(&$_content, $_trim_from = 0)
{
	global $client;
	global $remote_url;
	global $title;
	global $start_link;
	global $next_link;
	global $copy_link;
	global $next_trim;
	global $total_chars;
	global $local_args;
	global $script_self;
	global $form_hidden;
	global $_remote_args;
	global $_history_key;
	global $_element_serial;
	$_proceed = null;
	if ($local_args['a'] == 'h') {
		$_proceed .= KEY_PREFIX.'a=h';
	} else {
		if ($local_args['a'] == 'c') {
			$_proceed .= KEY_PREFIX.'a=c&amp;';
		}
		if ($local_args['m'] != 'post' or 0 !== strpos($remote_url, $local_args['u'])) {
			$_proceed .= KEY_PREFIX.'u='.urlencode($remote_url);
		} else {
			if (isset($_SESSION)) {
				$_proceed .= KEY_PREFIX.'u='.$_history_key;
			} else {
				$_proceed .= KEY_PREFIX.'m=post&amp;'.KEY_PREFIX.'e='.$local_args['e'].
					'&amp;'.KEY_PREFIX.'u='.urlencode($local_args['u']);
				foreach ($_remote_args as $key => $value) {
					if ($value != null) {
						$_proceed .= "&amp;$key=$value";
					}
				}
			}
		}
	}
	if ($local_args['a'] != 'h' and $local_args['a'] != 'c') {
		$copy_link = $script_self.KEY_PREFIX.'a=c&amp;'.$_proceed;
	}
	$_total_bytes = mb_strwidth($_content);
	$total_chars = mb_strlen($_content);
	if ($local_args['c']) {
		$_bytes_per_page = ((int) $local_args['c'] *1000);
	} else {
		if (defined('CACHESIZE_THRESHOLD') and $client->cache_size > CACHESIZE_THRESHOLD) {
			$_bytes_per_page = CACHESIZE_THRESHOLD;
		} else {
			$_bytes_per_page = $client->cache_size;
		}
	}
	$_wrapper_block = null;
	if ($_trim_from > 0) {
		$x = mb_substr($_content, $_trim_from);
		if (mb_strpos($x, '<') > mb_strpos($x, '>')) {
			$_trim_from = mb_strrpos(mb_substr($_content, 0, $_trim_from), '<');
		}
		$_cb = array();
		if (preg_match_all('/<\w+[^>]*?\s(\d+[rd]?)>/s', $_content, $matches, PREG_OFFSET_CAPTURE)) {
			$limit = count($matches[0]);
			for ($i = 0; $i < $limit; $i++) {
				$_cb[$matches[1][$i][0]] = array($matches[0][$i][0], $matches[0][$i][1]);
			}
			if (preg_match_all('/<\/\w+\s(\d+[rd]?)>/s', $_content, $matches, PREG_OFFSET_CAPTURE)) {
				$limit = count($matches[0]);
				for ($i = 0; $i < $limit; $i++) {
					$_cb[$matches[1][$i][0]][2] = $matches[0][$i][0];
					$_cb[$matches[1][$i][0]][3] = $matches[0][$i][1];
				}
			}
		}
		$_offset = strlen(mb_substr($_content, 0, $_trim_from));
		$_wrapper_block = null;
		foreach ($_cb as $value) {
			if (isset($value[1]) and isset($value[3])
				and $value[1] < $_offset and $value[3] >= $_offset) {
				$_wrapper_block .= (0 === strpos($value[0], '<table'))? $value[0].'<tr><td>': $value[0];
			}
		}
	}
	$_url_length = mb_strwidth($script_self.KEY_PREFIX.'u='.urlencode($remote_url));
	$_bytes_per_page -= (
		SIZE_REDUNDANCY
		+ mb_strwidth($form_hidden)
		+ mb_strwidth($_wrapper_block)
		+ ($_url_length * URL_REDUNDANCY)
	);
	if ($_trim_from > 0) {
		$_bytes_per_page -= $_url_length;
	}
	if ($_total_bytes > $_bytes_per_page) {
		$_bytes_per_page -= $_url_length;
	}
	if ($_bytes_per_page < 100) {
		$_content = sayError('ERROR_CACHESIZE_TOOSMALL');
		return false;
	}
	if ($_trim_from > 0 or $_total_bytes > $_bytes_per_page) {
		if ($_trim_from > 0) {
			$start_link = $script_self.KEY_PREFIX.'s=0&amp;'.$_proceed;
		}
		if ($_trim_from >= $total_chars) {
			$_content = sayError(
				'ERROR_DIVPOINT_OUTRANGE',
				number_format($_trim_from),
				number_format($total_chars),
				$start_link
			);
			return false;
		}
		$_content = mb_strimwidth($_content, $_trim_from, $_bytes_per_page);
		$_last_gt = mb_strrpos($_content, '>');
		if (mb_strrpos($_content, '<') > $_last_gt) {
			$_content = mb_substr($_content, 0, ($_last_gt +1));
		}
		$next_trim = $_trim_from + mb_strlen($_content);
		if ($total_chars > $next_trim) {
			$next_link = $script_self.KEY_PREFIX.'s='.$next_trim.'&amp;'.$_proceed;
		}
		$_content = $_wrapper_block.$_content;
	}
	$_content = preg_replace('/<(\/?\w+[^>]*?)\s\d+[rd]?>/s', '<$1>', $_content);
	if (INT_ENC != 'UTF-8') {
		mb_convert_variables('UTF-8', INT_ENC, $_content);
	}
	require_once 'HTMLParser.class.php';
	class HTMLParser_Postformat extends HTMLParser
	{
		var $out = '';
		var $html_empty_tags = array(
			'base', 'meta', 'link',
			'hr', 'br', 'basefont', 'param', 'img', 'area', 'input', 'isindex', 'col'
		);
		function openHandler(&$parser, $name, $attribs)
		{
			$name = strtolower($name);
			$this->out .= $this->_formatOpenTag($name, $attribs);
			if (!in_array($name, $this->html_empty_tags)) {
				array_unshift($this->current_node, $name);
			}
		}
		function closeHandler(&$parser, $name)
		{
			$name = strtolower(trim($name));
			if (!empty($this->current_node)) {
				if ($name == $this->current_node[0]) {
					$tagname = array_shift($this->current_node);
					$this->out .= "</$tagname>";
				}
			}
		}
		function dataHandler(&$parser, $data)
		{
			$data = preg_replace('/^[\t\r\n]*(.*)[\t\r\n]*$/', '$1', $data);
			if (strlen($data) > 0) {
				$this->out .= $data;
			}
		}
		function _formatOpenTag($name, $attribs)
		{
			$tag = "<$name";
			if (!empty($attribs)) {
				foreach ($attribs as $key => $value) {
					$tag .= " $key=\"$value\"";
				}
			}
			$tag .= in_array($name, $this->html_empty_tags)? ' />': '>';
			return $tag;
		}
		function dump($encoding)
		{
			if (!empty($this->current_node)) {
				foreach ($this->current_node as $value) {
					$this->out .= "</$value>";
				}
				$this->current_node = array();
			}
			mb_convert_variables($encoding, 'UTF-8', $this->out);
			return $this->out;
		}
	}
	$parser = new HTMLParser_Postformat;
	$parser->setRoot('html');
	$parser->parse($_content);
	$_content = $parser->dump(INT_ENC);
	return true;
}

/* -------------------------------------------------------------------------
	transcodeImage
------------------------------------------------------------------------- */

function transcodeImage($_original_resource, $_original_image)
{
	global $new_image;
	session_write_close();
	$_original_is_truecolor = imageIsTrueColor($_original_resource);
	list($_original_width, $_original_height, $_original_type) = $_original_image;
	list($_width, $_height, $_type, $_quality) = $new_image;
	$_new_resource = imageCreateTrueColor($_width, $_height);
	if (!$_original_is_truecolor) {
		$_totalcolors = imageColorsTotal($_original_resource);
		if (0 < $_transid = imageColorTransparent($_original_resource)) {
			$_transcolor = ($_transid < $_totalcolors)?
				imageColorsForIndex($_original_resource, $_transid):
				array('red' => '255', 'green' => '255', 'blue' => '255');
			imagefill($_new_resource, 0, 0,
				imageColorAllocate($_new_resource,
					$_transcolor['red'],
					$_transcolor['green'],
					$_transcolor['blue']
				)
			);
		}
	}
	imageCopyResampled(
		$_new_resource, $_original_resource,
		0, 0, 0, 0,
		$_width, $_height,
		$_original_width, $_original_height
	);
	$_use_ratio = false;
	if ($_quality != '' and preg_match('/^(\d{1,3})[^\d\s]/', $_quality, $matches)) {
		$_quality = $matches[1];
		$_use_ratio = true;
	}
	if ($_type != 2) {
		if ($_quality === '' or $_quality === null) {
			if (!$_original_is_truecolor) {
				if ($_width == $_original_width and $_height == $_original_height) {
					imageTrueColorToPalette($_new_resource, false, $_totalcolors);
				} elseif ($_totalcolors < 4) {
					imageTrueColorToPalette($_new_resource, !isset($_transcolor), 8);
				} else {
					imageTrueColorToPalette($_new_resource, !isset($_transcolor), 256);
					imagePaletteCopy($_new_resource, $_original_resource);
				}
			} else {
				imageTrueColorToPalette($_new_resource, true, pow(2, AVERAGE_PALETTE_BIT));
			}
			if (isset($_transcolor)) {
				imageColorTransparent($_new_resource,
					imageColorClosest($_new_resource,
						$_transcolor['red'],
						$_transcolor['green'],
						$_transcolor['blue']
					)
				);
			}
		} else {
			if ($_use_ratio) {
				if (!$_original_is_truecolor) {
					$i = imageColorsTotal($_original_resource);
					$_base = 1;
					while ($i > 2) {
						$i = $i /2;
						$_base++;
					}
				} else {
					$_base = AVERAGE_PALETTE_BIT;
				}
				if ($_quality == AVERAGE_COMPRESSION_RATIO) {
					$_bit = $_base;
				} elseif ($_quality < AVERAGE_COMPRESSION_RATIO) {
					$_bit = $_quality * (($_base -1) / AVERAGE_COMPRESSION_RATIO) +1;
				} elseif ($_quality > AVERAGE_COMPRESSION_RATIO) {
					$_bit = ($_quality -AVERAGE_COMPRESSION_RATIO) * ((8 - $_base) / (100 - AVERAGE_COMPRESSION_RATIO)) + $_base;
				}
				$_quality = pow(2, round($_bit));
			}
			if ($_quality < 1) {
				$_quality = 1;
			}
			if ($_quality > 256) {
				$_quality = 256;
			}
			imageTrueColorToPalette($_new_resource, true, $_quality);
		}
	}
	ob_start();
		switch ($_type) {
			case 1:
				$_output_type = 'image/gif';
				imageGIF($_new_resource);
				break;
			case 2:
				if ($_quality === '' or $_quality === null) {
					$_quality = AVERAGE_COMPRESSION_RATIO;
				}
				if ($_quality < 0) {
					$_quality = 0;
				}
				if ($_quality > 100) {
					$_quality = 100;
				}
				$_output_type = 'image/jpeg';
				imageJPEG($_new_resource, null, $_quality);
				break;
			case 3:
				$_output_type = 'image/png';
				imagePNG($_new_resource);
		}
		$_output_buffer = ob_get_contents();
		$_output_length = ob_get_length();
	ob_end_clean();
	imageDestroy($_original_resource);
	imageDestroy($_new_resource);
	header("Content-Type:".$_output_type);
	header("Content-Length:".$_output_length);
	echo $_output_buffer;
	exit;
}

function getNewImageInfo($_original_image)
{
	global $client;
	global $local_args;
	$_new_image = array(
		$local_args['w'],
		$local_args['h'],
		$local_args['t'],
		$local_args['q']
	);
	if (!$_new_image[2]) {
		$_new_image[2] = $_original_image[2];
	}
	switch ($client->screen['gif_support']
		+ $client->screen['jpg_support']
		+ $client->screen['png_support']) {
		case 1:
			if ($client->screen['gif_support']) {$_new_image[2] = 1;}
			if ($client->screen['jpg_support']) {$_new_image[2] = 2;}
			if ($client->screen['png_support']) {$_new_image[2] = 3;}
			break;
		case 2:
			switch ($_new_image[2]) {
				case 1:
					$_new_image[2] = $client->screen['gif_support']? 1: 3;
					break;
				case 2:
					$_new_image[2] = $client->screen['jpg_support']? 2: 3;
					break;
				case 3:
					$_new_image[2] = $client->screen['png_support']? 3: 1;
			}
			break;
	}
	if ($_new_image[3]) {
		if (preg_match('/^(\d{1,3})([^\d\s])/', $_new_image[3], $matches)) {
			$_new_image[3] = $matches[1];
			$_ratio_identifier = $matches[2];
		}
		if (isset($_ratio_identifier) or $_new_image[2] == 2) {
			if ($_new_image[3] < 0) {
				$_new_image[3] = 0;
			}
			if ($_new_image[3] > 100) {
				$_new_image[3] = 100;
			}
			if (isset($_ratio_identifier)) {
				$_new_image[3] = $_new_image[3].$_ratio_identifier;
			}
		} else {
			if ($_new_image[3] < 1) {
				$_new_image[3] = 1;
			}
			if ($_new_image[3] > 256) {
				$_new_image[3] = 256;
			}
		}
	}
	$_max_image_width = $local_args['w']? $local_args['w']: $client->screen['width'];
	if ($_max_image_width > ALLOWABLE_PIXSIZE) {
		$_max_image_width = ALLOWABLE_PIXSIZE;
	}
	if (!$_new_image[0] and !$_new_image[1]) {
		$_new_image[0] = $_max_image_width;
		$_new_image[1] = (int) round($_original_image[1] * $_new_image[0] / $_original_image[0]);
	} elseif (!$_new_image[0] and $_new_image[1]) {
		$_new_image[0] = (int) round($_original_image[0] * $_new_image[1] / $_original_image[1]);
		if ($_new_image[0] > ALLOWABLE_PIXSIZE) {
			$_new_image[0] = ALLOWABLE_PIXSIZE;
		}
	} elseif ($_new_image[0] and !$_new_image[1]) {
		$_new_image[1] = (int) round($_original_image[1] * $_new_image[0] / $_original_image[0]);
	}
	if ($_new_image[0] > $_original_image[0]) {
		$_new_image[0] = $_original_image[0];
	}
	if ($_new_image[1] > $_original_image[1]) {
		$_new_image[1] = $_original_image[1];
	}
	return array(
		$_new_image[0],
		$_new_image[1],
		$_new_image[2],
		$_new_image[3]
	);
}

/* -------------------------------------------------------------------------
	Miscellaneous Functions
------------------------------------------------------------------------- */

function sayError($_error_string)
{
	global $client;
	global $local_args;
	global $remote_url;
	global $form_hidden;
	global $_is_error;
	global $_kana_convopt;
	global $_template_path;
	$_is_error = true;
	if (false === $_messages = @include $_template_path.'ErrorMessages.inc.php') {
		$_message =& $_error_string;
	} else {
		if (isset($_messages[$_error_string])) {
			$_message =& $_messages[$_error_string];
		} else {
			$_message =& $_error_string;
		}
	}
	$args = func_get_args();
	$limit = count($args);
	for ($i = 1; $i < $limit; $i++) {
		$search = "'{%".$i."}'";
		$_message = preg_replace($search, "$args[$i]", $_message);
	}
	if ($_error_string == 'ERROR_CONFIRM_POST') {
		$_message .= '<br /><a href="'.
			$_SERVER['REQUEST_URI'].'&amp;'.KEY_PREFIX.'o=1">YES</a>|<a href="'.
			$_SERVER['REQUEST_URI'].'&amp;'.KEY_PREFIX.'o=0">NO</a>';
	} elseif ($_error_string == 'ERROR_AUTH_REQUIRED') {
		$_message .= '<br /><form action="'.basename($_SERVER['SCRIPT_NAME']).'" method="'.
			($client->is_postcapable? "post": "get")."\">".$form_hidden.'<input type="hidden" name="'.
			KEY_PREFIX.'e" value="SJIS"><input type="hidden" name="'.
			KEY_PREFIX.'m" value="get"><input type="hidden" name="'.
			KEY_PREFIX.'u" value="'.$remote_url.'"><input type="hidden" name="'.
			KEY_PREFIX.'r" value="'.$args[2].'">USER<input type="text" name="'.
			KEY_PREFIX.'i" istyle="3"><br />PASS<input type="text" name="'.
			KEY_PREFIX.'p" istyle="3"><br /><input type="submit" value="OK"></form>';
	}
	return mb_convert_kana($_message, $_kana_convopt);
}

function replaceChars(&$_string)
{
	global $replace_chars;
	$_string = mb_decode_numericentity($_string,
		array(
			0x2000, 0xDFFF, 0x0000, 0xFFFF,
			0xFA00, 0xFFFF, 0x0000, 0xFFFF,
		)
	);
	if (isset($replace_chars)) {
		$search = array();
		$replace = array();
		foreach ($replace_chars as $key => $value) {
			$search[] = $key;
			$replace[] = $value;
		}
		$_string = preg_replace($search, $replace, $_string);
	}
}

function checkCharset($_string)
{
	return (false !== $_string =@mb_preferred_mime_name($_string))? $_string: null;
}

function checkColorValue(&$_string)
{
	$_string = strtolower($_string);
	if (in_array($_string, array(
		'aqua', 'black', 'blue', 'fuchsia', 'gray', 'green',
		'lime', 'maroon', 'navy', 'olive', 'purple', 'red',
		'silver', 'teal', 'white', 'yellow'))
		or preg_match('/^#[0-9a-f]{6}$/', $_string)) {
		return true;
	} elseif (preg_match('/^[0-9a-f]{6}$/', $_string)) {
		$_string = '#'.$_string;
		return true;
	} else {
		$array = array(
			'aliceblue' => '#f0f8ff',
			'antiquewhite' => '#faebd7',
			'aquamarine' => '#7fffd4',
			'azure' => '#f0ffff',
			'beige' => '#f5f5dc',
			'bisque' => '#ffe4c4',
			'blanchedalmond' => '#ffebcd',
			'blueviolet' => '#8a2be2',
			'brown' => '#a52a2a',
			'burlywood' => '#deb887',
			'cadetblue' => '#5f9ea0',
			'chartreuse' => '#7fff00',
			'chocolate' => '#d2691e',
			'coral' => '#ff7f50',
			'cornflowerblue' => '#6495ed',
			'cornsilk' => '#fff8dc',
			'crimson' => '#dc143c',
			'cyan' => '#00ffff',
			'darkblue' => '#00008b',
			'darkcyan' => '#008b8b',
			'darkgoldenrod' => '#b8860b',
			'darkgray' => '#a9a9a9',
			'darkgreen' => '#006400',
			'darkkhaki' => '#bdb76b',
			'darkmagenta' => '#8b008b',
			'darkolivegreen' => '#556b2f',
			'darkorange' => '#ff8c00',
			'darkorchid' => '#9932cc',
			'darkred' => '#8b0000',
			'darksalmon' => '#e9967a',
			'darkseagreen' => '#8fbc8f',
			'darkslateblue' => '#483d8b',
			'darkslategray' => '#2f4f4f',
			'darkturquoise' => '#00ced1',
			'darkviolet' => '#9400d3',
			'deeppink' => '#ff1493',
			'deepskyblue' => '#00bfff',
			'dimgray' => '#696969',
			'dodgerblue' => '#1e90ff',
			'firebrick' => '#b22222',
			'floralwhite' => '#fffaf0',
			'forestgreen' => '#228b22',
			'gainsboro' => '#dcdcdc',
			'ghostwhite' => '#f8f8ff',
			'gold' => '#ffd700',
			'goldenrod' => '#daa520',
			'greenyellow' => '#adff2f',
			'honeydew' => '#f0fff0',
			'hotpink' => '#ff69b4',
			'indianred' => '#cd5c5c',
			'indigo' => '#4b0082',
			'ivory' => '#fffff0',
			'khaki' => '#f0e68c',
			'lavender' => '#e6e6fa',
			'lavenderblush' => '#fff0f5',
			'lawngreen' => '#7cfc00',
			'lemonchiffon' => '#fffacd',
			'lightblue' => '#add8e6',
			'lightcoral' => '#f08080',
			'lightcyan' => '#e0ffff',
			'lightgoldenrodyellow' => '#fafad2',
			'lightgreen' => '#90ee90',
			'lightgrey' => '#d3d3d3',
			'lightpink' => '#ffb6c1',
			'lightsalmon' => '#ffa07a',
			'lightseagreen' => '#20b2aa',
			'lightskyblue' => '#87cefa',
			'lightslategray' => '#778899',
			'lightsteelblue' => '#b0c4de',
			'lightyellow' => '#ffffe0',
			'limegreen' => '#32cd32',
			'linen' => '#faf0e6',
			'magenta' => '#ff00ff',
			'mediumaquamarine' => '#66cdaa',
			'mediumblue' => '#0000cd',
			'mediumorchid' => '#ba55d3',
			'mediumpurple' => '#9370db',
			'mediumseagreen' => '#3cb371',
			'mediumslateblue' => '#7b68ee',
			'mediumspringgreen' => '#00fa9a',
			'mediumturquoise' => '#48d1cc',
			'mediumvioletred' => '#c71585',
			'midnightblue' => '#191970',
			'mintcream' => '#f5fffa',
			'mistyrose' => '#ffe4e1',
			'moccasin' => '#ffe4b5',
			'navajowhite' => '#ffdead',
			'oldlace' => '#fdf5e6',
			'olivedrab' => '#6b8e23',
			'orange' => '#ffa500',
			'orangered' => '#ff4500',
			'orchid' => '#da70d6',
			'palegoldenrod' => '#eee8aa',
			'palegreen' => '#98fb98',
			'paleturquoise' => '#afeeee',
			'palevioletred' => '#db7093',
			'papayawhip' => '#ffefd5',
			'peachpuff' => '#ffdab9',
			'peru' => '#cd853f',
			'pink' => '#ffc0cb',
			'plum' => '#dda0dd',
			'powderblue' => '#b0e0e6',
			'rosybrown' => '#bc8f8f',
			'royalblue' => '#4169e1',
			'saddlebrown' => '#8b4513',
			'salmon' => '#fa8072',
			'sandybrown' => '#f4a460',
			'seagreen' => '#2e8b57',
			'seashell' => '#fff5ee',
			'sienna' => '#a0522d',
			'skyblue' => '#87ceeb',
			'slateblue' => '#6a5acd',
			'slategray' => '#708090',
			'snow' => '#fffafa',
			'springgreen' => '#00ff7f',
			'steelblue' => '#4682b4',
			'tan' => '#d2b48c',
			'thistle' => '#d8bfd8',
			'tomato' => '#ff6347',
			'turquoise' => '#40e0d0',
			'violet' => '#ee82ee',
			'wheat' => '#f5deb3',
			'whitesmoke' => '#f5f5f5',
			'yellowgreen' => '#9acd32'
		);
		if (isset($array[strtolower($_string)])) {
			$_string = $array[strtolower($_string)];
			return true;
		} else {
			$_string = null;
			return false;
		}
	}
}

function transAbsolutePath($_path)
{
	global $_base_href;
	global $_current_url;
	$_path = preg_replace('/[\t\r\n]/', '', trim($_path));
	$_wrapper = null;
	if ($_base_href
		and preg_match('/^(http:\/\/web\.archive\.org\/web\/\d{14}\/)/', $_current_url['url'], $matches)) {
		$_wrapper = $matches[1];
	}
	if (preg_match('/^\w+:/i', $_path)) {
		$searches = array(
			array(
				'http://mgw.hatena.ne.jp/?'
			),
			array(
				'http://www.google.com/gwt/n?',
				'u'
			)
		);
		foreach ($searches as $value) {
			if (0 === strpos($_path, $value[0])) {
				$_path = str_replace($value[0], null, $_path);
				if (isset($value[1])) {
					$_path = preg_replace('/^.*\b'.$value[1].'=([^&]+).*$/', '$1', $_path);
				}
				if (false === strpos($_path, '?')
					and (preg_match('/%(?:26|2E|2F|3A|3F|3D)/i', $_path))) {
					$_path = urldecode($_path);
				}
				break;
			}
		}
		return $_wrapper.$_path;
	}
	if (preg_match('/^\/\/\w/i', $_path)) {
		return $_wrapper.'http:'.$_path;
	}
	if (!isset($_base_href)) {
		$_remote_host = $_current_url['scheme'].'://'.$_current_url['host'].
			((isset($_current_url['port']) and $_current_url['port'] != 80)?
			':'.$_current_url['port']: null);
		$_remote_path = isset($_current_url['path'])? $_current_url['path']: '/';
		$_remote_dir = $_remote_path? getDirName($_remote_path): '/';
	} else {
		$array = parse_url($_base_href);
		$_remote_host = $array['scheme'].'://'.$array['host'].
			((isset($array['port']) and $array['port'] != 80)?
			':'.$array['port']: null);
		$_remote_path = isset($array['path'])? $array['path']: '/';
		$_remote_dir = $_remote_path? getDirName($_remote_path): '/';
	}
	$_path = preg_replace('/^\.\//', null, $_path);
	$search = "'^((?:\.\.\/){1,})'";
	if (preg_match($search, $_path, $matches)) {
		$_path = substr($_path, strlen($matches[1]));
		$count = strlen($matches[1]) / 3;
		$array = explode('/', $_remote_dir);
		array_pop($array);
		while ($count) {
			array_pop($array);
			$count--;
		}
		$_remote_dir = implode('/', $array);
		$_remote_dir .= '/';
	}
	if (preg_match('/^\//', $_path)) {
		$_path = $_remote_host.$_path;
	}
	if (preg_match('/^#/', $_path)) {
		$_url = isset($_current_url['fragment'])?
			str_replace('#'.$_current_url['fragment'], null, $_current_url['url']):
			$_current_url['url'];
		$_path = $_url.$_path;
	}
	if (preg_match('/^(?!https?:\/\/)/i', $_path)) {
		$_path = $_remote_host.$_remote_dir.$_path;
	}
	return $_wrapper.$_path;
}

function addProxyURL($_url)
{
	global $script_self;
	global $fancy_url_prefix;
	if (preg_match('/^https?:\/\/www\.amazon\.co\.jp/i', $_url)) {
		if (preg_match('/\/exec\/obidos\/(?:ASIN\/|ISBN(?:=|%3D))(\w{10}).*?\/?(\w+-22)?/i', $_url, $matches)) {
			$_asin = $matches[1];
			$_associd = isset($matches[2])? $matches[2]: null;
		} elseif (preg_match('/\/exec\/obidos\/redirect\?(.+)$/i', $_url, $matches)) {
			$_query = $matches[1];
			if (preg_match('/&?\btag=(\w+-22)&?/i', $_query, $matches)) {
				$_associd = $matches[1];
			}
			if (preg_match('/&?\bpath=[^&]*?(?:ASIN(?:\/|%2F)|ISBN(?:=|%3D))(\w{10})&?/i', $_query, $matches)) {
				$_asin = $matches[1];
			}
		}
		if (isset($_asin)) {
			return 'http://www.amazon.co.jp/gp/aw/rd.html?a='.
				$_asin.'&amp;uid=NULLGWDOCOMO&amp;url=/gp/aw/d.html&amp;lc=msn'.
				(isset($_associd)? '&amp;at='.$_associd: null).'&amp;dl=1';
		}
	}
	if (!preg_match('/^https?:\/\//', $_url)) {
		return $_url;
	}
	if (defined('USE_DATABASE') and USE_DATABASE == true) {
		global $dbconf;
		switch ($dbconf['dbtype']) {
			case 'mysql':
				$_is_error = false;
				$_id = md5($_url);
				$_result = mysql_query("
					SELECT *
					FROM `$dbconf[prefix]urls`
					WHERE `keyid` = '$_id'
				") or $_is_error = true;
				if (false === mysql_fetch_array($_result)) {
					mysql_query("
						INSERT
						INTO `$dbconf[prefix]urls` (`keyid`, `url`, `is_image`, `registered`)
						VALUES ('$_id', '".urlencode($_url)."', 0, '".date('Y-m-d H:i:s')."')
					") or $_is_error = true;
				}
				if (!$_is_error) {
					if (defined('FANCY_URL_PREFIX') and defined('ALWAYS_USE_FANCY_URL') and ALWAYS_USE_FANCY_URL) {
						return "{$fancy_url_prefix}b$_id";
					} else {
						return $script_self.KEY_PREFIX.'u=b'.$_id;
					}
				}
				break;
			default:
				global $mdb2;
				$_is_error = false;
				$_id = md5($_url);
				$result = $mdb2->query("
					SELECT *
					FROM `$dbconf[prefix]urls`
					WHERE `keyid` = '$_id'
					");
				if (PEAR::isError($result)) {
					$_is_error = true;
				} elseif (null === $myrow = $result->fetchRow()) {
					$result->free();
					$result = $mdb2->query("
						INSERT
						INTO `$dbconf[prefix]urls` (`keyid`, `url`, `is_image`, `registered`)
						VALUES ('$_id', '".urlencode($_url)."', 0, '".date('Y-m-d H:i:s')."')
						");
					if (PEAR::isError($result)) {
						$_is_error = true;
					} else {
						$result->free();
					}
				}
				if (!$_is_error) {
					if (defined('FANCY_URL_PREFIX') and defined('ALWAYS_USE_FANCY_URL') and ALWAYS_USE_FANCY_URL) {
						return "{$fancy_url_prefix}b$_id";
					} else {
						return $script_self.KEY_PREFIX.'u=b'.$_id;
					}
				}
		}
	}
	if (defined('FANCY_URL_PREFIX') and defined('ALWAYS_USE_FANCY_URL') and ALWAYS_USE_FANCY_URL) {
		return $fancy_url_prefix.str_replace('http://', '', $_url);
	} else {
		$array = explode('?', $_url);
		$x = array_shift($array);
		return empty($array)?
			$script_self.KEY_PREFIX.'u='.urlencode($x):
			$script_self.KEY_PREFIX.'y='.urlencode(implode('?', $array)).'&amp;'.KEY_PREFIX.'u='.urlencode($x);
	}
}

function addImageProxyURL($_url)
{
	global $local_args;
	global $script_self;
	if (defined('USE_DATABASE') and USE_DATABASE == true) {
		global $dbconf;
		switch ($dbconf['dbtype']) {
			case 'mysql':
				$_is_error = false;
				$_id = md5($_url);
				$_result = mysql_query("
					SELECT *
					FROM `$dbconf[prefix]urls`
					where `keyid` = '$_id'
				") or $_is_error = true;
				if (false === mysql_fetch_array($_result)) {
					mysql_query("
						INSERT
						INTO `$dbconf[prefix]urls` (`keyid`, `url`, `is_image`, `registered`)
						VALUES ('$_id', '".urlencode($_url)."', 1, '".date('Y-m-d H:i:s')."')
					") or $_is_error = true;
				}
				if (!$_is_error) {
					$_url = "b$_id";
				}
				break;
			default:
				global $mdb2;
				$_is_error = false;
				$_id = md5($_url);
				$result = $mdb2->query("
					SELECT *
					FROM `$dbconf[prefix]urls`
					WHERE `keyid` = '$_id'
					");
				if (PEAR::isError($result)) {
					$_is_error = true;
				} elseif (null === $myrow = $result->fetchRow()) {
					$result->free();
					$result = $mdb2->query("
						INSERT
						INTO `$dbconf[prefix]urls` (`keyid`, `url`, `is_image`, `registered`)
						VALUES ('$_id', '".urlencode($_url)."', 0, '".date('Y-m-d H:i:s')."')
						");
					if (PEAR::isError($result)) {
						$_is_error = true;
					} else {
						$result->free();
					}
				}
				if (!$_is_error) {
					$_url = "b$_id";
				}
		}
	}
	$image_converter = IMAGE_CONVERTER.'?';
	if ($local_args['d'] !== null and !ENABLE_SESSION_COOKIE) {
		$image_converter = $image_converter.strip_tags(SID).'&amp;';
	}
	$array = explode('?', $_url);
	$x = array_shift($array);
	return $image_converter.
		KEY_PREFIX.'a=i&amp;'.
		($local_args['w']? KEY_PREFIX.'w='.$local_args['w'].'&amp;': null).
		($local_args['h']? KEY_PREFIX.'h='.$local_args['h'].'&amp;': null).
		($local_args['t']? KEY_PREFIX.'t='.$local_args['t'].'&amp;': null).
		($local_args['q']? KEY_PREFIX.'q='.$local_args['q'].'&amp;': null).
		(empty($array)?
			KEY_PREFIX.'u='.urlencode($x):
			KEY_PREFIX.'y='.urlencode(implode('?', $array)).'&amp;'.KEY_PREFIX.'u='.urlencode($x));
}

function getDirName($_path)
{
	return substr($_path, 0, strrpos($_path, '/') +1);
}

function removeQuote($_string)
{
	return preg_replace('/^\s*[\'\"](.+)[\'\"]\s*$/s', '$1', $_string);
}

function getAttribute($_param, $_string)
{
	$search = "'[\s\'\"]\b".$_param."\b\s*=\s*([^\s\'\">]+|\'[^\']+\'|\"[^\"]+\")'si";
	if (preg_match($search, $_string, $matches)) {
		return removeQuote($matches[1]);
	} else {
		return null;
	}
}

function getFilename($_url)
{
	if (preg_match('/^(\w+):(.+)$/', $_url, $matches)
		and !preg_match('/^(?:https?|ftps?)/', $matches[1])) {
		return $matches[2];
	} else {
		$array = @parse_url($_url);
		if ($array) {
			if (isset($array['path']) and basename($array['path']) != null) {
				return preg_replace('/^(.+)\.\w+$/', '$1', basename($array['path']));
			} elseif (isset($array['fragment'])) {
				return $array['fragment'];
			} elseif (isset($array['host'])) {
				return preg_replace('/^www\./', null, $array['host']);
			}
		} else {
			return $_url;
		}
	}
}

function generateId($_length)
{
	$x = "0123456789abcdefghijklmnopqrstuvwxyz";
	$_id = null;
	for ($i = 0; $i < $_length; $i++) {
		$_id .= substr($x, mt_rand(0, strlen($x) -1), 1);
	}
	return $_id;
}

function sortMultiArray($array, $_sortby)
{
	$_keys = array();
	foreach ($array as $key => $value) {
		$_keys[$key] = $value[$_sortby];
	}
	array_multisort($_keys, SORT_NUMERIC, SORT_DESC, $array);
	return $array;
}

function extractURLfromJS($_string)
{
	$_urls = array();
	if (preg_match_all('/(?:\bwindow\.open|\blocation\.replace|\blocation\.assign)\s*\(([^\)]+?)\)/s', $_string, $matches)) {
		foreach ($matches[1] as $value) {
			$array = explode(', ', $value);
			if (preg_match('/^\s*(\'\s*[^\'\s]+\s*\'|\"\s*[^\"\s]+\s*\")\s*$/s', $array[0], $matches)) {
				$_urls[] = removeQuote($matches[1]);
			}
		}
	}
	if (preg_match_all('/\blocation\.href\s*=\s*(\'\s*[^\'\s]+\s*\'|\"\s*[^\"\s]+\s*\")\s*[;}]/s', $_string, $matches)) {
		foreach ($matches[1] as $value) {
			$_urls[] = removeQuote($value);
		}
	}
	if (preg_match_all('/\blocation\.href\s*=\s*(\'\s*[^\'\s]+\s*\'|\"\s*[^\"\s]+\s*\")\s*$/s', $_string, $matches)) {
		foreach ($matches[1] as $value) {
			$_urls[] = removeQuote($value);
		}
	}
	return $_urls;
}

function getTagPairs($_tag, $_string, &$matched_pairs)
{
	$matched_pairs = array();
	if (!preg_match_all('/<'.$_tag.'\b[^>]*?>/si', $_string, $matches, PREG_OFFSET_CAPTURE)) {
		return false;
	}
	$_opentags = $matches[0];
	preg_match_all('/<\/'.$_tag.'\b[^>]*?>/si', $_string, $matches, PREG_OFFSET_CAPTURE);
	$_closetags = $matches[0];
	foreach ($_closetags as $value) {
		$limit = count($_opentags);
		for ($i = 0; $i < $limit; $i++) {
			if ($value[1] > $_opentags[$i][1]
				and (!isset($_opentags[$i +1][1]) or $value[1] < $_opentags[$i +1][1])) {
				if (!isset($_opentags[$i][2])) {
					$_opentags[$i][2] = $value[0];
					$_opentags[$i][3] = $value[1];
				} else {
					for ($ii = $i; $ii >= 0; $ii--) {
						if (!isset($_opentags[$ii][2])) {
							$_opentags[$ii][2] = $value[0];
							$_opentags[$ii][3] = $value[1];
							break;
						}
					}
				}
				break;
			}
		}
	}
	$limit = count($_opentags);
	for ($i = 0; $i < $limit; $i++) {
		$result = substr($_string, $_opentags[$i][1],
			$_opentags[$i][3] - $_opentags[$i][1] + strlen($_opentags[$i][2]));
		$matched_pairs[] = $result;
	}
	return true;
}

function formatXhtml(&$_string)
{
	$_string = preg_replace('/&(?!(?:[a-zA-Z]+|#[0-9]+|#x[0-9a-fA-F]+);)/', '&amp;', $_string);
	$_string = preg_replace_callback(
		'/<((?:base|meta|link|hr|br|basefont|param|img|area|input|isindex|col)\b[^>]*?)(?<!\/)>/si',
		create_function('$matches', '
			return "<".$matches[1]." />";
		'), $_string);
}

function urlMatch($url, $urls)
{
	$array = parse_url($url);
	foreach ($urls as $value) {
		if (isset($value[0]) and preg_match('/'.preg_quote($value[0], '/').'$/', $array['host'])) {
			if (!isset($value[1]) or empty($value[1])) {
				return true;
			} elseif (isset($array['path'])) {
				foreach ($value[1] as $path) {
					if (preg_match('/^'.preg_quote($path, '/').'/', $array['path'])) {
						return true;
					}
				}
			}
		}
	}
	return false;
}

function formatHtml(&$_string)
{
	$_string = preg_replace('/(<[^>]*?)\s?\/>/s', '$1>', $_string);
	$array = array(
		'checked', 'compact', 'controls', 'declare', 'defer', 'disabled',
		'ismap', 'mayscript', 'multiple', 'nohref', 'noshade', 'nowrap',
		'readonly', 'selected', 'utn', 'wrap'
	);
	foreach ($array as $value) {
		$_string = str_replace("$value=\"$value\"", $value, $_string);
	}
}

function dbgc()
{
	global $dbconf;
	switch ($dbconf['dbtype']) {
		case 'mysql':
			$_result = mysql_query("
				SELECT *
				FROM `$dbconf[prefix]gc`
				WHERE 1
			") or exit(mysql_error());
			if (false === $myrow = mysql_fetch_array($_result)) {
				mysql_query("
					INSERT
					INTO `$dbconf[prefix]gc` (`keyid`, `lastgc`)
					VALUES (1, '".date('Y-m-d H:i:s')."')
				") or exit(mysql_error());
			} elseif (DBGC_INTERVAL < time() - strtotime($myrow['lastgc'])) {
				mysql_query("
					DELETE
					FROM `$dbconf[prefix]urls`
					WHERE `lastupdated` IS NOT NULL
						AND `lastupdated` < '".date('Y-m-d H:i:s', time() - DBGC_RECORDEXPIRE_SINCELAST)."'
				") or exit(mysql_error());
				mysql_query("
					DELETE
					FROM `$dbconf[prefix]urls`
					WHERE `lastupdated` IS NULL
						AND `registered` < '".date('Y-m-d H:i:s', time() - DBGC_RECORDEXPIRE_NOTINUSE)."'
				") or exit(mysql_error());
				mysql_query("
					OPTIMIZE
					TABLE `$dbconf[prefix]urls`
				") or exit(mysql_error());
				mysql_query("
					UPDATE
					`$dbconf[prefix]gc`
					SET `lastgc` = '".date('Y-m-d H:i:s')."'
					WHERE 1
				") or exit(mysql_error());
			}
			break;
		default:
			global $mdb2;
			$result = $mdb2->query("
				SELECT *
				FROM `$dbconf[prefix]gc`
				WHERE 1
				");
			if (PEAR::isError($result)) {
				exit ($mdb2->getMessage());
			}
			if (null === $myrow = $result->fetchRow(MDB2_FETCHMODE_ASSOC)) {
				$result = $mdb2->query("
					INSERT
					INTO `$dbconf[prefix]gc` (`keyid`, `lastgc`)
					VALUES (1, '".date('Y-m-d H:i:s')."')
					");
				if (PEAR::isError($result)) {
					exit ($mdb2->getMessage());
				}
				$result->free();
			} elseif (DBGC_INTERVAL < time() - strtotime($myrow['lastgc'])) {
				$result->free();
				$result = $mdb2->query("
					DELETE
					FROM `$dbconf[prefix]urls`
					WHERE `lastupdated` IS NOT NULL
						AND `lastupdated` < '".date('Y-m-d H:i:s', time() - DBGC_RECORDEXPIRE_SINCELAST)."'
					");
				if (PEAR::isError($result)) {
					exit ($mdb2->getMessage());
				}
				$result->free();
				$result = $mdb2->query("
					DELETE
					FROM `$dbconf[prefix]urls`
					WHERE `lastupdated` IS NULL
						AND `registered` < '".date('Y-m-d H:i:s', time() - DBGC_RECORDEXPIRE_NOTINUSE)."'
					");
				if (PEAR::isError($result)) {
					exit ($mdb2->getMessage());
				}
				$result->free();
				$result = $mdb2->query("
					OPTIMIZE
					TABLE `$dbconf[prefix]urls`
					");
				if (PEAR::isError($result)) {
					exit ($mdb2->getMessage());
				}
				$result->free();
				$result = $mdb2->query("
					UPDATE
					`$dbconf[prefix]gc`
					SET `lastgc` = '".date('Y-m-d H:i:s')."'
					WHERE 1
					");
				if (PEAR::isError($result)) {
					exit ($mdb2->getMessage());
				}
				$result->free();
			}
	}
}

?>
