/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.gui.GUIXmlAttributeDialog;
import jp.sourceforge.jhime.pectin.gui.GUIXmlPIElementDialog;
import jp.sourceforge.jhime.pectin.model.XmlModelAttribute;
import jp.sourceforge.jhime.pectin.model.XmlModelPi;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;
import jp.sourceforge.jhime.pectin.xml.XMLDocumentUser;
import org.w3c.dom.Element;

public class GUIXmlPIDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private XMLDocument xmlDoc;
    private JButton okBtn;
    private JButton cancelBtn;
    private JComboBox documentBox;
    private JList elementList;
    private DefaultListModel elementModel;
    private JList attributeList;
    private DefaultListModel attributeModel;
    private JButton elmAppendBtn;
    private JButton elmRemoveBtn;
    private JButton elmUpdateBtn;
    private JButton elmUpBtn;
    private JButton elmDownBtn;
    private JButton atrAppendBtn;
    private JButton atrRemoveBtn;
    private JButton atrUpdateBtn;
    private JButton atrUpBtn;
    private JButton atrDownBtn;

    public GUIXmlPIDialog(GUIFrame obj) {
        super((Frame)null, "XML\u51e6\u7406\u547d\u4ee4\u5b9a\u7fa9", true);
        int h;
        int w;
        this.appObject = obj;
        this.xmlDoc = XMLDocumentUser.newInstance();
        this.paramInitialize();
        if (this.documentBox.getItemCount() <= 0) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
            return;
        }
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        this.getContentPane().add((Component)new JLabel(""), "West");
        this.getContentPane().add((Component)new JLabel(""), "East");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.initStatus();
        this.pack();
        Rectangle rect = this.getGraphicsConfiguration().getBounds();
        if (rect.x < 0) {
            int x = rect.x;
            w = 500;
        } else {
            w = rect.width / 2;
            int x = (rect.width - w) / 2;
        }
        if (rect.y < 0) {
            int y = rect.y;
            h = 400;
        } else {
            h = rect.height / 2;
            boolean y = false;
        }
        this.setSize(w, h);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u9589\u3058\u308b");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.transform();
                GUIXmlPIDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.okBtn);
        return pan;
    }

    private void paramInitialize() {
        this.documentBox = new JComboBox(this.xmlDoc.getDocumentList());
        this.elementModel = new DefaultListModel();
        this.elementList = new JList(this.elementModel);
        this.attributeModel = new DefaultListModel();
        this.attributeList = new JList(this.attributeModel);
        ImageIcon iconAdd = new ImageIcon(ClassLoader.getSystemResource("images/add.png"));
        ImageIcon iconDelete = new ImageIcon(ClassLoader.getSystemResource("images/delete.png"));
        ImageIcon iconWrench = new ImageIcon(ClassLoader.getSystemResource("images/wrench.png"));
        ImageIcon iconUp = new ImageIcon(ClassLoader.getSystemResource("images/arrow_up.png"));
        ImageIcon iconDown = new ImageIcon(ClassLoader.getSystemResource("images/arrow_down.png"));
        this.elmAppendBtn = new JButton(iconAdd);
        this.elmRemoveBtn = new JButton(iconDelete);
        this.elmUpdateBtn = new JButton(iconWrench);
        this.elmUpBtn = new JButton(iconUp);
        this.elmDownBtn = new JButton(iconDown);
        this.atrAppendBtn = new JButton(iconAdd);
        this.atrRemoveBtn = new JButton(iconDelete);
        this.atrUpdateBtn = new JButton(iconWrench);
        this.atrUpBtn = new JButton(iconUp);
        this.atrDownBtn = new JButton(iconDown);
        this.elmAppendBtn.setToolTipText("\u51e6\u7406\u547d\u4ee4\u306e\u8ffd\u52a0");
        this.elmRemoveBtn.setToolTipText("\u51e6\u7406\u547d\u4ee4\u306e\u524a\u9664");
        this.elmUpdateBtn.setToolTipText("\u51e6\u7406\u547d\u4ee4\u306e\u4fee\u6b63");
        this.elmUpBtn.setToolTipText("\uff11\u3064\u4e0a\u3078");
        this.elmDownBtn.setToolTipText("\uff11\u3064\u4e0b\u3078");
        this.atrAppendBtn.setToolTipText("\u5c5e\u6027\u306e\u8ffd\u52a0");
        this.atrRemoveBtn.setToolTipText("\u5c5e\u6027\u306e\u524a\u9664");
        this.atrUpdateBtn.setToolTipText("\u5c5e\u6027\u306e\u4fee\u6b63");
        this.atrUpBtn.setToolTipText("\uff11\u3064\u4e0a\u3078");
        this.atrDownBtn.setToolTipText("\uff11\u3064\u4e0b\u3078");
    }

    private JPanel createContentsPanel() {
        this.addAction();
        JScrollPane elmScrPane = new JScrollPane(this.elementList);
        JScrollPane atrScrPane = new JScrollPane(this.attributeList);
        JPanel elmBtnPane = new JPanel(new GridLayout(1, 5));
        elmBtnPane.add(this.elmAppendBtn);
        elmBtnPane.add(this.elmRemoveBtn);
        elmBtnPane.add(this.elmUpdateBtn);
        elmBtnPane.add(this.elmUpBtn);
        elmBtnPane.add(this.elmDownBtn);
        JPanel atrBtnPane = new JPanel(new GridLayout(1, 5));
        atrBtnPane.add(this.atrAppendBtn);
        atrBtnPane.add(this.atrRemoveBtn);
        atrBtnPane.add(this.atrUpdateBtn);
        atrBtnPane.add(this.atrUpBtn);
        atrBtnPane.add(this.atrDownBtn);
        JPanel elmPan = new JPanel(new BorderLayout());
        elmPan.add((Component)new JLabel("\u51e6\u7406\u547d\u4ee4\u30ea\u30b9\u30c8"), "North");
        elmPan.add((Component)elmScrPane, "Center");
        elmPan.add((Component)elmBtnPane, "South");
        JPanel atrPan = new JPanel(new BorderLayout());
        atrPan.add((Component)new JLabel("\u5c5e\u6027\u30ea\u30b9\u30c8"), "North");
        atrPan.add((Component)atrScrPane, "Center");
        atrPan.add((Component)atrBtnPane, "South");
        JPanel pan = new JPanel(new GridLayout(1, 2, 10, 5));
        pan.add(elmPan);
        pan.add(atrPan);
        GUIGridPanel gpan = new GUIGridPanel();
        gpan.gridLayoutComponent(new JLabel("\u6587\u66f8\u578b"), 0, 0);
        gpan.gridLayoutComponent(this.documentBox, 1, 0);
        JPanel docPane = new JPanel(new FlowLayout(0));
        docPane.add(gpan);
        JPanel ppan = new JPanel(new BorderLayout());
        ppan.add((Component)docPane, "North");
        ppan.add((Component)pan, "Center");
        return ppan;
    }

    private void addAction() {
        this.documentBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.actionDocumentList();
            }
        });
        this.elementList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GUIXmlPIDialog.this.actionElementList();
            }
        });
        this.elmAppendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.actionElementAppend();
            }
        });
        this.atrAppendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.actionAttributeAppend();
            }
        });
        this.elmRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.actionElementDelete();
            }
        });
        this.atrRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.actionAttributeDelete();
            }
        });
        this.elmUpdateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.actionElementUpdate();
            }
        });
        this.atrUpdateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.actionAttributeUpdate();
            }
        });
        this.elementList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUIXmlPIDialog.this.actionElementUpdate();
                }
            }
        });
        this.attributeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUIXmlPIDialog.this.actionAttributeUpdate();
                }
            }
        });
        this.elmUpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.actionElementUpDown(true);
            }
        });
        this.atrUpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.actionAttributeUpDown(true);
            }
        });
        this.elmDownBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.actionElementUpDown(false);
            }
        });
        this.atrDownBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIDialog.this.actionAttributeUpDown(false);
            }
        });
    }

    private void setElementBtnEnabled(boolean flag) {
        this.elmAppendBtn.setEnabled(flag);
        this.elmUpdateBtn.setEnabled(flag);
        this.elmRemoveBtn.setEnabled(flag);
        this.elmUpBtn.setEnabled(flag);
        this.elmDownBtn.setEnabled(flag);
    }

    private void setAttributeBtnEnabled(boolean flag) {
        this.atrAppendBtn.setEnabled(flag);
        this.atrUpdateBtn.setEnabled(flag);
        this.atrRemoveBtn.setEnabled(flag);
        this.atrUpBtn.setEnabled(flag);
        this.atrDownBtn.setEnabled(flag);
    }

    private void initStatus() {
        this.setElementBtnEnabled(false);
        this.setAttributeBtnEnabled(false);
        try {
            this.documentBox.setSelectedIndex(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void actionDocumentList() {
        String documentName = (String)this.documentBox.getSelectedItem();
        if (documentName == null) {
            this.setElementBtnEnabled(false);
            this.setAttributeBtnEnabled(false);
            return;
        }
        this.setElementBtnEnabled(true);
        this.elementModel.clear();
        this.attributeModel.clear();
        this.elementModel = this.xmlDoc.getPIElementList(this.elementModel, documentName);
        this.elementList.setSelectedIndex(0);
    }

    private void actionElementList() {
        String documentName = (String)this.documentBox.getSelectedItem();
        String elementName = (String)this.elementList.getSelectedValue();
        if (documentName == null || elementName == null) {
            this.setAttributeBtnEnabled(false);
            return;
        }
        this.setAttributeBtnEnabled(true);
        this.attributeModel.clear();
        this.attributeModel = this.xmlDoc.getPiAttributeList(this.attributeModel, documentName, elementName);
        this.attributeList.setSelectedIndex(0);
    }

    private void transform() {
        this.xmlDoc.transform();
        this.appObject.getUserXmlPanel().update();
    }

    private void actionElementAppend() {
        String documentName = (String)this.documentBox.getSelectedItem();
        GUIXmlPIElementDialog dlg = new GUIXmlPIElementDialog(this.appObject, documentName);
        if (dlg.getModel() == null) {
            return;
        }
        String docElement = (String)this.documentBox.getSelectedItem();
        if (!this.xmlDoc.appendPi(docElement, dlg.getModel())) {
            return;
        }
        this.elementModel.addElement(dlg.getModel().getName());
        this.elementList.setSelectedIndex(this.elementModel.size() - 1);
    }

    private void actionElementDelete() {
        String elementName = (String)this.elementList.getSelectedValue();
        if (elementName == null) {
            return;
        }
        Object[] options = new Object[]{"\u524a\u9664\u3059\u308b", "\u524a\u9664\u3057\u306a\u3044"};
        int ret = StaticUtil.warningMessage(elementName + " \u51e6\u7406\u547d\u4ee4\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", "\u51e6\u7406\u547d\u4ee4\u524a\u9664\u78ba\u8a8d", options, 1);
        if (ret != 0) {
            return;
        }
        String docElement = (String)this.documentBox.getSelectedItem();
        if (!this.xmlDoc.removePi(docElement, elementName)) {
            return;
        }
        int idx = this.elementModel.indexOf(elementName);
        this.elementModel.removeElement(elementName);
        if (idx >= this.elementModel.size()) {
            idx = this.elementModel.size() - 1;
        }
        if (idx < 0) {
            this.setAttributeBtnEnabled(false);
            this.attributeModel.clear();
            return;
        }
        this.elementList.setSelectedIndex(idx);
        this.elementList.requestFocusInWindow();
    }

    private void actionElementUpdate() {
        String documentName = (String)this.documentBox.getSelectedItem();
        String piName = (String)this.elementList.getSelectedValue();
        if (documentName == null || piName == null) {
            return;
        }
        XmlModelPi model = this.xmlDoc.getPiModel(documentName, piName);
        if (model == null) {
            return;
        }
        GUIXmlPIElementDialog dlg = new GUIXmlPIElementDialog(this.appObject, documentName, model);
        if (dlg.getModel() == null) {
            return;
        }
        if (!this.xmlDoc.updatePi(documentName, piName, dlg.getModel())) {
            return;
        }
        int idx = this.elementList.getSelectedIndex();
        this.elementModel.set(idx, dlg.getModel().getName());
        this.elementList.setSelectedIndex(idx);
        this.elementList.requestFocusInWindow();
    }

    private void actionElementUpDown(boolean upFlag) {
        int eIdx;
        int sIdx;
        int idx = this.elementList.getSelectedIndex();
        if (upFlag) {
            if (idx <= 0) {
                return;
            }
            sIdx = idx - 1;
            eIdx = idx;
        } else {
            if (idx >= this.elementModel.size() - 1) {
                return;
            }
            sIdx = idx;
            eIdx = idx + 1;
        }
        String elm1 = (String)this.elementModel.get(sIdx);
        String elm2 = (String)this.elementModel.get(eIdx);
        String documentName = (String)this.documentBox.getSelectedItem();
        if (!this.xmlDoc.piUpDown(documentName, elm1, elm2)) {
            return;
        }
        this.elementModel.set(sIdx, elm2);
        this.elementModel.set(eIdx, elm1);
        if (!upFlag) {
            sIdx = eIdx;
        }
        this.elementList.setSelectedIndex(sIdx);
        this.elementList.requestFocusInWindow();
    }

    private void actionAttributeAppend() {
        String elementName;
        String documentName = (String)this.documentBox.getSelectedItem();
        Element element = this.xmlDoc.getPiByNameAttribute(documentName, elementName = (String)this.elementList.getSelectedValue());
        GUIXmlAttributeDialog dlg = new GUIXmlAttributeDialog(this.appObject, element);
        if (dlg.getModel() == null) {
            return;
        }
        if (!this.xmlDoc.appendAttributeElement(element, dlg.getModel())) {
            return;
        }
        this.attributeModel.addElement(dlg.getModel().getName());
    }

    private void actionAttributeDelete() {
        String elementName;
        String attributeName = (String)this.attributeList.getSelectedValue();
        if (attributeName == null) {
            return;
        }
        Object[] options = new Object[]{"\u524a\u9664\u3059\u308b", "\u524a\u9664\u3057\u306a\u3044"};
        int ret = StaticUtil.warningMessage(attributeName + " \u5c5e\u6027\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", "\u5c5e\u6027\u524a\u9664\u78ba\u8a8d", options, 1);
        if (ret != 0) {
            return;
        }
        String documentName = (String)this.documentBox.getSelectedItem();
        Element element = this.xmlDoc.getPiByNameAttribute(documentName, elementName = (String)this.elementList.getSelectedValue());
        if (!this.xmlDoc.removeAttributeElement(element, attributeName)) {
            return;
        }
        int idx = this.attributeModel.indexOf(attributeName);
        this.attributeModel.removeElement(attributeName);
        if (idx >= this.attributeModel.size()) {
            idx = this.attributeModel.size() - 1;
        }
        if (idx < 0) {
            return;
        }
        this.attributeList.setSelectedIndex(idx);
        this.attributeList.requestFocusInWindow();
    }

    private void actionAttributeUpdate() {
        XmlModelAttribute model;
        String documentName = (String)this.documentBox.getSelectedItem();
        String piName = (String)this.elementList.getSelectedValue();
        String attributeName = (String)this.attributeList.getSelectedValue();
        if (null == documentName || null == piName || null == attributeName) {
            return;
        }
        Element piElement = this.xmlDoc.getPiByNameAttribute(documentName, piName);
        GUIXmlAttributeDialog dlg = new GUIXmlAttributeDialog(this.appObject, piElement, model = this.xmlDoc.getAttributeModel(documentName, piElement, attributeName));
        if (dlg.getModel() == null) {
            return;
        }
        if (!this.xmlDoc.updateAttributeElement(piElement, attributeName, dlg.getModel())) {
            return;
        }
        int idx = this.attributeList.getSelectedIndex();
        this.attributeModel.set(idx, dlg.getModel().getName());
        this.attributeList.setSelectedIndex(idx);
        this.attributeList.requestFocusInWindow();
    }

    private void actionAttributeUpDown(boolean upFlag) {
        int eIdx;
        int sIdx;
        int idx = this.attributeList.getSelectedIndex();
        if (upFlag) {
            if (idx <= 0) {
                return;
            }
            sIdx = idx - 1;
            eIdx = idx;
        } else {
            if (idx >= this.attributeModel.size() - 1) {
                return;
            }
            sIdx = idx;
            eIdx = idx + 1;
        }
        String attr1 = (String)this.attributeModel.get(sIdx);
        String attr2 = (String)this.attributeModel.get(eIdx);
        String documentName = (String)this.documentBox.getSelectedItem();
        String piName = (String)this.elementList.getSelectedValue();
        Element piElement = this.xmlDoc.getPiByNameAttribute(documentName, piName);
        if (!this.xmlDoc.attributeUpDown(piElement, attr1, attr2)) {
            return;
        }
        this.attributeModel.set(sIdx, attr2);
        this.attributeModel.set(eIdx, attr1);
        if (!upFlag) {
            sIdx = eIdx;
        }
        this.attributeList.setSelectedIndex(sIdx);
        this.attributeList.requestFocusInWindow();
    }

    public void windowClosing(WindowEvent e) {
        this.transform();
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

