/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jp.sourceforge.jhime.pectin.gui.GUICodeAttributeDialog;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIXmlAttributePanel;
import jp.sourceforge.jhime.pectin.model.XmlModel;
import jp.sourceforge.jhime.pectin.model.XmlModelAttribute;
import jp.sourceforge.jhime.pectin.model.XmlModelAttributeList;
import jp.sourceforge.jhime.pectin.model.XmlModelCode;
import jp.sourceforge.jhime.pectin.model.XmlModelDtd;
import jp.sourceforge.jhime.pectin.model.XmlModelElement;
import jp.sourceforge.jhime.pectin.model.XmlModelPi;
import jp.sourceforge.jhime.pectin.model.XmlModelTemplate;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;
import org.w3c.dom.Element;

public class GUIXmlTreePanel
extends JPanel {
    private GUIFrame appObject;
    private JComboBox documentBox;
    private JTree documentTree;
    private XMLDocument xmlDoc;
    private JPanel btnPanel;

    public GUIXmlTreePanel(GUIFrame obj, XMLDocument doc) {
        this.appObject = obj;
        this.xmlDoc = doc;
        this.paramInitialize();
        this.setLayout(new BorderLayout());
        this.add((Component)this.documentBox, "North");
        this.add((Component)new JScrollPane(this.documentTree), "Center");
        this.btnPanel = this.createButtonPanel();
        this.add((Component)this.btnPanel, "South");
    }

    private void paramInitialize() {
        Vector vector = this.xmlDoc.getDocumentList();
        if (null == vector) {
            vector = new Vector();
        }
        this.documentBox = new JComboBox(vector);
        this.documentBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GUIXmlTreePanel.this.actionDocumentBox();
            }
        });
        this.documentTree = new JTree(new Vector());
        TreeSelectionModel tsm = this.documentTree.getSelectionModel();
        tsm.setSelectionMode(1);
        this.documentTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TreePath selPath = GUIXmlTreePanel.this.documentTree.getSelectionPath();
                    if (null == selPath) {
                        return;
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                    Object obj = node.getUserObject();
                    if (obj.getClass().getName().equals("XmlTreeModel")) {
                        return;
                    }
                    GUIXmlTreePanel.this.actionList((XmlModel)obj);
                }
            }
        });
        if (this.documentBox.getItemCount() > 0) {
            this.documentBox.setSelectedIndex(0);
            this.actionDocumentBox();
        }
    }

    private JPanel createButtonPanel() {
        JPanel pane = new JPanel(new FlowLayout(2));
        ImageIcon icon = new ImageIcon(ClassLoader.getSystemResource("images/application_form.png"));
        JButton attrBtn = new JButton(icon);
        attrBtn.setToolTipText("\u5c5e\u6027\u8a2d\u5b9a");
        attrBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreePath selPath = GUIXmlTreePanel.this.documentTree.getSelectionPath();
                if (null == selPath) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                Object obj = node.getUserObject();
                if (obj.getClass().getName().equals("XmlTreeModel")) {
                    return;
                }
                GUIXmlTreePanel.this.actionAttributePanel((XmlModel)obj);
            }
        });
        pane.add(attrBtn);
        return pane;
    }

    private void actionList(XmlModel objModel) {
        if (this.appObject.getViewCount() <= 0) {
            return;
        }
        String type = objModel.getType();
        if (type.equals("template")) {
            this.actionTemplate((XmlModelTemplate)objModel);
        } else if (type.equals("pi")) {
            this.actionPi((XmlModelPi)objModel);
        } else if (type.equals("dtd")) {
            this.actionDtd((XmlModelDtd)objModel);
        } else if (type.equals("attributeList")) {
            this.actionAttributeList((XmlModelAttributeList)objModel);
        } else if (type.equals("element")) {
            this.actionElement((XmlModelElement)objModel, false);
        } else if (type.equals("code")) {
            this.actionCode((XmlModelCode)objModel);
        }
    }

    private void actionAttributePanel(XmlModel objModel) {
        if (this.appObject.getViewCount() <= 0) {
            return;
        }
        String type = objModel.getType();
        if (type.equals("element")) {
            this.actionElement((XmlModelElement)objModel, true);
        }
    }

    protected void actionDocumentBox() {
        if (this.documentBox.getSelectedIndex() < 0) {
            return;
        }
        String documentName = (String)this.documentBox.getSelectedItem();
        Vector vector = this.xmlDoc.getTreeModel(documentName);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)new JTree(vector).getModel().getRoot();
        ((DefaultTreeModel)this.documentTree.getModel()).setRoot(root);
    }

    protected void insert(String str) {
        this.appObject.getView().insertTag(str, "");
    }

    protected void insert(String sStr, String eStr) {
        this.appObject.getView().insertTag(sStr, eStr);
    }

    protected String getDocumentBox() {
        return (String)this.documentBox.getSelectedItem();
    }

    protected XMLDocument getXMLDocument() {
        return this.xmlDoc;
    }

    public void setBtnPanel(boolean flag) {
        this.btnPanel.setVisible(flag);
    }

    public int getDocumentCount() {
        return this.documentBox.getItemCount();
    }

    public void update() {
        int idx = this.documentBox.getSelectedIndex();
        ((DefaultComboBoxModel)this.documentBox.getModel()).removeAllElements();
        Vector docList = this.xmlDoc.getDocumentList();
        for (int i = 0; i < docList.size(); ++i) {
            this.documentBox.addItem(docList.get(i));
        }
        if (this.documentBox.getItemCount() > 0) {
            this.documentBox.setSelectedIndex(0);
        } else {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)new JTree(new Vector()).getModel().getRoot();
            ((DefaultTreeModel)this.documentTree.getModel()).setRoot(root);
        }
    }

    public void actionTemplate(XmlModelTemplate model) {
        this.insert(model.getString());
    }

    public void actionPi(XmlModelPi model) {
        DefaultListModel list = new DefaultListModel();
        String documentName = this.getDocumentBox();
        String piName = model.getName();
        if (null == this.documentBox || null == piName) {
            return;
        }
        XMLDocument doc = this.getXMLDocument();
        Element piElement = doc.getPiByNameAttribute(documentName, piName);
        list = doc.getPiAttributeList(list, documentName, piName);
        Vector<XmlModelAttribute> vector = new Vector<XmlModelAttribute>();
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            XmlModelAttribute attrModel = doc.getAttributeModel(documentName, piElement, name);
            vector.add(attrModel);
        }
        GUIXmlAttributePanel panel = new GUIXmlAttributePanel(this.appObject, piName, vector);
        GUICodeAttributeDialog dlg = new GUICodeAttributeDialog(this.appObject, piName, panel);
        String attrStr = dlg.getString();
        if (null == attrStr) {
            return;
        }
        String piStr = "<?" + piName + attrStr + "?>";
        this.insert(piStr);
    }

    public void actionDtd(XmlModelDtd model) {
        this.insert(model.getString());
    }

    public void actionAttributeList(XmlModelAttributeList model) {
        DefaultListModel list = new DefaultListModel();
        String documentName = this.getDocumentBox();
        String listName = model.getName();
        if (null == this.documentBox || null == listName) {
            return;
        }
        XMLDocument doc = this.getXMLDocument();
        Element listElement = doc.getAttributeListByNameAttribute(documentName, listName);
        list = doc.getAttributeListAttributeList(list, documentName, listName);
        Vector<XmlModelAttribute> vector = new Vector<XmlModelAttribute>();
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            XmlModelAttribute attrModel = doc.getAttributeModel(documentName, listElement, name);
            vector.add(attrModel);
        }
        GUIXmlAttributePanel panel = new GUIXmlAttributePanel(this.appObject, listName, vector);
        GUICodeAttributeDialog dlg = new GUICodeAttributeDialog(this.appObject, listName, panel);
        String attrStr = dlg.getString();
        if (null == attrStr) {
            return;
        }
        this.insert(attrStr);
    }

    public void actionElement(XmlModelElement model, boolean attrFlag) {
        String documentName = this.getDocumentBox();
        String elementName = model.getName();
        if (null == this.documentBox || null == elementName) {
            return;
        }
        DefaultListModel list = new DefaultListModel();
        StringBuffer attrBuff = new StringBuffer();
        attrFlag |= model.getAttribute();
        XMLDocument doc = this.getXMLDocument();
        Element element = doc.getElementByNameAttribute(documentName, elementName);
        list = doc.getElementAttributeList(list, documentName, elementName);
        Vector<XmlModelAttribute> vector = new Vector<XmlModelAttribute>();
        Vector<GUIXmlAttributePanel> paneArray = new Vector<GUIXmlAttributePanel>();
        int page = 1;
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            if (name.equals("#")) {
                GUIXmlAttributePanel pane1 = new GUIXmlAttributePanel(this.appObject, elementName, vector);
                pane1.setTitle("\u57fa\u672c\u5c5e\u6027(" + Integer.toString(page) + ")");
                paneArray.add(pane1);
                ++page;
                vector = new Vector();
                continue;
            }
            XmlModelAttribute attrModel = doc.getAttributeModel(documentName, element, name);
            attrFlag |= attrModel.getRequired();
            attrBuff.append(attrModel.getString());
            vector.add(attrModel);
        }
        if (vector.size() > 0) {
            GUIXmlAttributePanel pane1 = new GUIXmlAttributePanel(this.appObject, elementName, vector);
            pane1.setTitle("\u57fa\u672c\u5c5e\u6027(" + Integer.toString(page) + ")");
            paneArray.add(pane1);
        }
        list.clear();
        list = doc.getElementAttributeListList(list, documentName, elementName);
        DefaultListModel list2 = new DefaultListModel();
        for (int i = 0; i < list.size(); ++i) {
            String listName = (String)list.get(i);
            Element attrListElement = doc.getAttributeListByNameAttribute(documentName, listName);
            list2.clear();
            list2 = doc.getAttributeListAttributeList(list2, documentName, listName);
            Vector<XmlModelAttribute> vector2 = new Vector<XmlModelAttribute>();
            for (int j = 0; j < list2.size(); ++j) {
                String name = (String)list2.get(j);
                XmlModelAttribute attrModel = doc.getAttributeModel(documentName, attrListElement, name);
                attrFlag |= attrModel.getRequired();
                attrBuff.append(attrModel.getString());
                vector2.add(attrModel);
            }
            GUIXmlAttributePanel panew = new GUIXmlAttributePanel(this.appObject, listName, vector2);
            panew.setTitle(listName);
            paneArray.add(panew);
        }
        String attrStr = "";
        if (attrFlag) {
            GUICodeAttributeDialog dlg = new GUICodeAttributeDialog(this.appObject, elementName, paneArray);
            attrStr = dlg.getString();
            if (null == attrStr) {
                return;
            }
        } else {
            attrStr = attrBuff.toString();
        }
        String sStr = "<" + elementName + attrStr;
        String eStr = "</" + elementName + ">";
        if (model.getEmpty()) {
            sStr = sStr + " />";
            this.insert(sStr);
        } else {
            sStr = sStr + ">";
            this.insert(sStr, eStr);
        }
    }

    public void actionCode(XmlModelCode model) {
        this.insert(model.getString());
    }
}

