/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.plugins.DefaultCSSDocument;
import jp.sourceforge.jhime.pectin.plugins.DefaultXMLDocument;
import jp.sourceforge.jhime.pectin.plugins.Plugin;
import jp.sourceforge.jhime.pectin.plugins.PluginXMLDocument;

public class PluginTreePanel
extends JPanel {
    private GUIFrame appObject;
    private JComboBox documentBox;
    private JTree documentTree;
    private JPanel treePanel;
    private JButton selectBtn;

    public PluginTreePanel(GUIFrame obj) {
        this.appObject = obj;
        this.paramInitialize();
        this.setLayout(new BorderLayout());
        this.add((Component)this.documentBox, "North");
        this.add((Component)this.treePanel, "Center");
        this.add((Component)this.selectBtn, "South");
        if (this.documentBox.getItemCount() > 0) {
            this.documentBox.setSelectedIndex(0);
            this.actionDocumentBox();
        }
    }

    private void paramInitialize() {
        DefaultXMLDocument doc1 = new DefaultXMLDocument(this.appObject);
        DefaultCSSDocument doc2 = new DefaultCSSDocument(this.appObject);
        this.documentBox = new JComboBox();
        this.documentBox.addItem(doc1);
        this.documentBox.addItem(doc2);
        Plugin plugin = new Plugin(this.appObject);
        Vector plugins = plugin.getPlugins();
        for (int i = 0; i < plugins.size(); ++i) {
            PluginXMLDocument xmlDoc = (PluginXMLDocument)plugins.get(i);
            this.documentBox.addItem(xmlDoc);
        }
        this.documentBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PluginTreePanel.this.actionDocumentBox();
            }
        });
        this.documentTree = new JTree(new Vector());
        TreeSelectionModel tsm = this.documentTree.getSelectionModel();
        tsm.setSelectionMode(1);
        this.documentTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PluginTreePanel.this.listClickAction();
                }
            }
        });
        this.treePanel = new JPanel(new BorderLayout());
        this.treePanel.add((Component)new JScrollPane(this.documentTree), "Center");
        this.selectBtn = new JButton("\u9805\u76ee\u9078\u629e");
        this.selectBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginTreePanel.this.listButtonAction();
            }
        });
    }

    private void actionDocumentBox() {
        if (this.documentBox.getSelectedIndex() < 0) {
            return;
        }
        PluginXMLDocument document = (PluginXMLDocument)this.documentBox.getSelectedItem();
        Vector vector = document.getDocumentList();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)new JTree(vector).getModel().getRoot();
        ((DefaultTreeModel)this.documentTree.getModel()).setRoot(root);
        this.selectBtn.setText(document.getSelectButtonTitle());
        this.selectBtn.setVisible(document.getSelectButtonStatus());
    }

    private void listClickAction() {
        if (this.appObject.getViewCount() <= 0) {
            return;
        }
        TreePath selPath = this.documentTree.getSelectionPath();
        if (null == selPath) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        Object obj = node.getUserObject();
        PluginXMLDocument document = (PluginXMLDocument)this.documentBox.getSelectedItem();
        document.createString(obj);
        int mode = document.getInsertMode();
        if (PluginXMLDocument.INSERT_SINGLE_MODE == mode) {
            this.insert(document.getStartString());
        } else if (PluginXMLDocument.INSERT_RANGE_MODE == mode) {
            this.insert(document.getStartString(), document.getEndString());
        } else {
            this.appObject.getView().setFocus();
        }
    }

    private void listButtonAction() {
        if (this.appObject.getViewCount() <= 0) {
            return;
        }
        TreePath selPath = this.documentTree.getSelectionPath();
        if (null == selPath) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        Object obj = node.getUserObject();
        PluginXMLDocument document = (PluginXMLDocument)this.documentBox.getSelectedItem();
        document.createStringAlias(obj);
        int mode = document.getInsertMode();
        if (PluginXMLDocument.INSERT_SINGLE_MODE == mode) {
            this.insert(document.getStartString());
        } else if (PluginXMLDocument.INSERT_RANGE_MODE == mode) {
            this.insert(document.getStartString(), document.getEndString());
        } else {
            this.appObject.getView().setFocus();
        }
    }

    private void insert(String str) {
        this.appObject.getView().insertTag(str, "");
    }

    private void insert(String sStr, String eStr) {
        this.appObject.getView().insertTag(sStr, eStr);
    }

    public int getDocumentCount() {
        return this.documentBox.getItemCount();
    }
}

