/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jp.sourceforge.jhime.pectin.action.FindMenuAction;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.util.StaticUtil;

public class FindMenuActionHandler
implements ActionListener {
    private GUIFrame appObject;
    private FindMenuAction menuObject;
    public static final String FIND = "find";
    public static final String NEXT = "next";
    public static final String PREV = "prev";
    public static final String REPLACE = "replace";
    public static final String REPLACENEXT = "replacenext";
    public static final String LINEJUMP = "linejump";

    public FindMenuActionHandler(GUIFrame obj) {
        this.appObject = obj;
    }

    public FindMenuActionHandler(GUIFrame obj, FindMenuAction menu) {
        this.appObject = obj;
        this.menuObject = menu;
    }

    private void actionFind() {
        this.appObject.getFindDialog().setVisible(true);
    }

    private void actionNext() {
        this.appObject.getFindDialog().getNextFind();
    }

    private void actionPrev() {
        this.appObject.getFindDialog().getPrevFind();
    }

    private void actionReplace() {
        this.appObject.getFindDialog().getReplace();
    }

    private void actionReplaceNext() {
        this.appObject.getFindDialog().getReplaceNext();
    }

    private void actionLineJump() {
        String str = StaticUtil.inputMessage("\u79fb\u52d5\u3059\u308b\u884c\u756a\u53f7", "\u6307\u5b9a\u884c\u3078\u306e\u79fb\u52d5");
        if (str == null) {
            return;
        }
        try {
            int n = Integer.parseInt(str);
            if (--n < 0) {
                throw new NumberFormatException();
            }
            int offset = this.appObject.getView().getOffsetLine(n);
            if (offset < 0) {
                StaticUtil.errorMessage("\u7bc4\u56f2\u5916\u306e\u884c\u756a\u53f7\u3067\u3059\u3002", "\u884c\u756a\u53f7\u30a8\u30e9\u30fc");
                return;
            }
            this.appObject.getView().setCaretPosition(offset);
        }
        catch (NumberFormatException e) {
            StaticUtil.errorMessage("\u884c\u756a\u53f7\u304c\u4e0d\u6b63\u3067\u3059\u3002", "\u884c\u756a\u53f7\u30a8\u30e9\u30fc");
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(FIND)) {
            this.actionFind();
        } else if (command.equals(NEXT)) {
            this.actionNext();
        } else if (command.equals(PREV)) {
            this.actionPrev();
        } else if (command.equals(REPLACE)) {
            this.actionReplace();
        } else if (command.equals(REPLACENEXT)) {
            this.actionReplaceNext();
        } else if (command.equals(LINEJUMP)) {
            this.actionLineJump();
        }
        this.appObject.getView().setFocus();
    }
}

