/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.ftp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.sourceforge.jhime.pectin.ftp.FTP;
import jp.sourceforge.jhime.pectin.ftp.Host;
import jp.sourceforge.jhime.pectin.util.StaticUtil;

public class FtpDialog
extends JDialog
implements WindowListener {
    private JFrame frame;
    private JButton connectBtn;
    private JButton closeBtn;
    private Host host;
    private FTP ftp;
    private Thread ftpThread;
    private JTextArea textArea = new JTextArea("\u63a5\u7d9a\u4e2d...");
    private JButton listBtn = new JButton("LIST");
    private JButton cwdBtn = new JButton("CWD");
    private JButton cdupBtn = new JButton("CDUP");
    private JButton typeBtn = new JButton("TYPE");
    private JButton mkdBtn = new JButton("MKD");
    private JButton rmdBtn = new JButton("RMD");
    private JButton deleBtn = new JButton("DEL");
    private JButton renBtn = new JButton("REN");
    private JButton downloadBtn = new JButton("DOWNLOAD");
    private JButton uploadBtn = new JButton("UPLOAD");

    public FtpDialog(JFrame frame, Host host) {
        super((Frame)frame, "FTP\u30af\u30e9\u30a4\u30a2\u30f3\u30c8");
        this.frame = frame;
        this.host = host;
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel opan = this.createOperationPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)opan, "North");
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.closeBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        if (dim.width < 500) {
            dim.width = 500;
        }
        if (dim.height < 400) {
            dim.height = 400;
        }
        this.setSize(dim.width + 50, dim.height + 10);
    }

    private JPanel createButtonPanel() {
        this.connectBtn = new JButton("\u518d\u63a5\u7d9a");
        this.closeBtn = new JButton("\u9589\u3058\u308b");
        this.connectBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.reConnect();
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.disConnect();
                FtpDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.connectBtn);
        pan.add(this.closeBtn);
        return pan;
    }

    private JPanel createOperationPanel() {
        this.listBtn.setToolTipText("\u73fe\u5728\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u5185\u5bb9\u306e\u4e00\u89a7\u8868\u793a");
        this.cwdBtn.setToolTipText("\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u5909\u66f4");
        this.cdupBtn.setToolTipText("\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u89aa\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u5909\u66f4");
        this.typeBtn.setToolTipText("\u30a2\u30b9\u30ad\u30fc\u8ee2\u9001\u30e2\u30fc\u30c9\uff0f\u30d0\u30a4\u30ca\u30ea\u8ee2\u9001\u30e2\u30fc\u30c9\u306e\u5207\u308a\u63db\u3048");
        this.mkdBtn.setToolTipText("\u65b0\u898f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210");
        this.rmdBtn.setToolTipText("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u524a\u9664");
        this.deleBtn.setToolTipText("\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664");
        this.renBtn.setToolTipText("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff0f\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u5909\u66f4");
        this.downloadBtn.setToolTipText("\u30d5\u30a1\u30a4\u30eb\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9");
        this.uploadBtn.setToolTipText("\u30d5\u30a1\u30a4\u30eb\u306e\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9");
        this.listBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.ftpCommand(3);
            }
        });
        this.cwdBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.ftpCwdCommand();
            }
        });
        this.cdupBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.ftpCommand(5);
            }
        });
        this.typeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.ftpTypeCommand();
            }
        });
        this.mkdBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.ftpMkdCommand();
            }
        });
        this.rmdBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.ftpRmdCommand();
            }
        });
        this.deleBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.ftpDeleCommand();
            }
        });
        this.renBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.ftpRenameCommand();
            }
        });
        this.downloadBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.ftpDownloadCommand();
            }
        });
        this.uploadBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpDialog.this.ftpUploadCommand();
            }
        });
        JPanel pane = new JPanel(new GridLayout(2, 5));
        pane.add(this.listBtn);
        pane.add(this.cwdBtn);
        pane.add(this.cdupBtn);
        pane.add(this.typeBtn);
        pane.add(this.mkdBtn);
        pane.add(this.rmdBtn);
        pane.add(this.deleBtn);
        pane.add(this.renBtn);
        pane.add(this.downloadBtn);
        pane.add(this.uploadBtn);
        return pane;
    }

    private JPanel createPanel() {
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        JPanel pane = new JPanel(new BorderLayout(10, 0));
        JScrollPane spane = new JScrollPane(this.textArea);
        pane.add((Component)spane, "Center");
        return pane;
    }

    private void connect() {
        if (null == this.ftp) {
            return;
        }
        this.ftp.setJob(1);
        this.ftpThread = new Thread(this.ftp);
        this.ftpThread.start();
    }

    private void disConnect() {
        if (null == this.ftp) {
            return;
        }
        this.ftp.setJob(2);
        this.ftpThread = new Thread(this.ftp);
        this.ftpThread.start();
        while (this.ftpThread.isAlive()) {
        }
        this.ftpThread = null;
    }

    private void reConnect() {
        this.disConnect();
        this.ftp = FTP.getInstance();
        this.ftp.setHost(this.host, this);
        this.connect();
    }

    private void ftpCommand(int command) {
        if (null == this.ftp) {
            return;
        }
        this.ftp.setJob(command);
        this.ftpThread = new Thread(this.ftp);
        this.ftpThread.start();
    }

    private void ftpCwdCommand() {
        String str = StaticUtil.inputMessage("\u5909\u66f4\u5148\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u3092\u5165\u308c\u3066\u304f\u3060\u3055\u3044", "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u5909\u66f4");
        if (null == str) {
            return;
        }
        this.ftp.setString(str);
        this.ftpCommand(4);
    }

    private void ftpTypeCommand() {
        boolean ascii = this.ftp.getTypeMode();
        this.ftp.setTypeMode(!ascii);
        this.ftpCommand(6);
    }

    private void ftpMkdCommand() {
        String str = StaticUtil.inputMessage("\u65b0\u3057\u304f\u4f5c\u6210\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u3092\u5165\u308c\u3066\u304f\u3060\u3055\u3044", "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u65b0\u898f\u4f5c\u6210");
        if (null == str) {
            return;
        }
        this.ftp.setString(str);
        this.ftpCommand(7);
    }

    private void ftpRmdCommand() {
        String str = StaticUtil.inputMessage("\u524a\u9664\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u3092\u5165\u308c\u3066\u304f\u3060\u3055\u3044", "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u524a\u9664");
        if (null == str) {
            return;
        }
        this.ftp.setString(str);
        this.ftpCommand(8);
    }

    private void ftpDeleCommand() {
        String str = StaticUtil.inputMessage("\u524a\u9664\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u5165\u308c\u3066\u304f\u3060\u3055\u3044", "\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664");
        if (null == str) {
            return;
        }
        this.ftp.setString(str);
        this.ftpCommand(9);
    }

    private void ftpRenameCommand() {
        String oldName = StaticUtil.inputMessage("\u5909\u66f4\u524d\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff0f\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u5165\u308c\u3066\u304f\u3060\u3055\u3044", "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff0f\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u5909\u66f4(1/2)");
        if (null == oldName) {
            return;
        }
        String newName = StaticUtil.inputMessage("\u65b0\u3057\u3044\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff0f\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u5165\u308c\u3066\u304f\u3060\u3055\u3044", "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff0f\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u5909\u66f4(2/2)");
        if (null == newName) {
            return;
        }
        this.ftp.setString(oldName, newName);
        this.ftpCommand(10);
    }

    private void ftpDownloadCommand() {
        String str = StaticUtil.inputMessage("\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u5165\u308c\u3066\u304f\u3060\u3055\u3044", "\u30d5\u30a1\u30a4\u30eb\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9");
        if (null == str) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u5148\u306e\u6307\u5b9a");
        fc.setFileSelectionMode(1);
        if (0 != fc.showDialog(this, null)) {
            return;
        }
        String path = fc.getSelectedFile().getPath() + System.getProperty("file.separator");
        FTP fftp = FTP.getInstance();
        fftp.setJob(12);
        Thread thread = new Thread(fftp);
        thread.start();
        while (thread.isAlive()) {
        }
        Vector result = fftp.getNlstResult();
        if (null == result || result.size() < 1) {
            return;
        }
        Vector<String> downloadFile = new Vector<String>();
        String regex = str.replaceAll("\\.", "\\\\\\.");
        regex = regex.replaceAll("\\*", ".*");
        regex = regex.replaceAll("\\?", ".");
        for (int i = 0; i < result.size(); ++i) {
            String fileName = (String)result.get(i);
            if (!Pattern.matches(regex, fileName)) continue;
            File file = new File(path + fileName);
            if (file.exists()) {
                ArrayList<String> msg = new ArrayList<String>();
                msg.add(fileName + " \u3092\u4e0a\u66f8\u304d\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f");
                Object[] options = new Object[]{"\u4fdd\u5b58\u3057\u306a\u3044", "\u4fdd\u5b58\u3059\u308b", "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306e\u4e2d\u6b62"};
                int ret = StaticUtil.warningMessage(msg.toArray(), "\u7d42\u4e86\u78ba\u8a8d", options, 0);
                if (ret == 1) {
                    downloadFile.add(fileName);
                    continue;
                }
                if (ret != 2) continue;
                this.setText("\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f");
                return;
            }
            downloadFile.add(fileName);
        }
        if (downloadFile.size() < 1) {
            this.setText("\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        this.ftp.setString(path);
        this.ftp.setNlstResult(downloadFile);
        this.ftpCommand(11);
    }

    private void ftpUploadCommand() {
        File dir = new File(this.host.getLocalDir());
        JFileChooser fc = new JFileChooser(dir);
        fc.setDialogTitle("\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a");
        fc.setMultiSelectionEnabled(true);
        if (0 != fc.showDialog(this, null)) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < files.length; ++i) {
            vector.add(files[i]);
        }
        if (vector.size() < 1) {
            this.setText("\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        this.ftp.setNlstResult(vector);
        this.ftpCommand(13);
    }

    public void start() {
        this.ftp = FTP.getInstance();
        this.ftp.setHost(this.host, this);
        this.connect();
        this.setModal(true);
        this.setLocationRelativeTo(this.frame);
        this.setVisible(true);
    }

    public void setText(String str) {
        if (null == str || 0 == str.trim().length()) {
            return;
        }
        int lastIdx = str.length() - 1;
        char lastChar = str.charAt(lastIdx);
        if ('\n' == lastChar) {
            this.textArea.append(str);
        } else {
            this.textArea.append(str + "\n");
        }
        this.textArea.setCaretPosition(this.textArea.getText().length() - 1);
        this.textArea.requestFocusInWindow();
    }

    public void setEnabledButton(boolean flag) {
        this.connectBtn.setEnabled(flag);
        this.listBtn.setEnabled(flag);
        this.cwdBtn.setEnabled(flag);
        this.cdupBtn.setEnabled(flag);
        this.typeBtn.setEnabled(flag);
        this.mkdBtn.setEnabled(flag);
        this.rmdBtn.setEnabled(flag);
        this.deleBtn.setEnabled(flag);
        this.renBtn.setEnabled(flag);
        this.downloadBtn.setEnabled(flag);
        this.uploadBtn.setEnabled(flag);
    }

    public void windowClosing(WindowEvent e) {
        this.disConnect();
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

