/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.model.XmlModelTemplate;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;

public class GUIXmlTemplateDialog2
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private XMLDocument xmlDoc;
    private String documentName;
    private JButton okBtn;
    private JButton cancelBtn;
    private JTextField tempField;
    private JTextArea tempArea;
    private String tempName;
    private String template;
    private XmlModelTemplate model;
    private boolean updateFlag;

    public GUIXmlTemplateDialog2(GUIFrame obj, XMLDocument xmlDoc, String documentName, XmlModelTemplate model, boolean updateFlag) {
        super((Frame)null, "XML\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u8a2d\u5b9a", true);
        this.appObject = obj;
        this.xmlDoc = xmlDoc;
        this.documentName = documentName;
        this.model = model;
        this.tempName = model.getName();
        this.template = model.getString();
        this.updateFlag = updateFlag;
        this.paramInitialize();
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        if (dim.height < 300) {
            dim.height = 300;
        }
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    public GUIXmlTemplateDialog2(GUIFrame obj, XMLDocument xmlDoc, String documentName) {
        super((Frame)null, "XML\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u8a2d\u5b9a", true);
        this.appObject = obj;
        this.xmlDoc = xmlDoc;
        this.documentName = documentName;
        this.paramInitialize();
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        if (dim.height < 300) {
            dim.height = 300;
        }
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    public GUIXmlTemplateDialog2(GUIFrame obj) {
        this(obj, null, null);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u8a2d\u5b9a");
        this.cancelBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!GUIXmlTemplateDialog2.this.actionOk()) {
                    return;
                }
                GUIXmlTemplateDialog2.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlTemplateDialog2.this.model = null;
                GUIXmlTemplateDialog2.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.cancelBtn);
        pan.add(this.okBtn);
        return pan;
    }

    private void paramInitialize() {
        this.tempField = new JTextField(20);
        if (this.tempName != null) {
            this.tempField.setText(this.tempName);
        }
        this.tempArea = new JTextArea();
        if (this.template != null) {
            this.tempArea.setText(this.template);
        }
    }

    private JPanel createContentsPanel() {
        this.addAction();
        GUIGridPanel gpan = new GUIGridPanel();
        gpan.gridLayoutComponent(new JLabel("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u540d"), 0, 0);
        gpan.gridLayoutComponent(this.tempField, 1, 0);
        JPanel tempPane = new JPanel(new FlowLayout(0));
        tempPane.add(gpan);
        JScrollPane tempScrPane = new JScrollPane(this.tempArea);
        JPanel textPane = new JPanel(new BorderLayout(5, 10));
        textPane.add((Component)tempScrPane, "Center");
        textPane.add((Component)new JLabel(" "), "West");
        textPane.add((Component)new JLabel(" "), "East");
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)tempPane, "North");
        pane.add((Component)textPane, "Center");
        return pane;
    }

    private void addAction() {
    }

    private boolean actionOk() {
        if (this.tempField.getText().trim().length() == 0) {
            StaticUtil.errorMessage("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u540d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044", "\u30a8\u30e9\u30fc");
            return false;
        }
        String newName = this.tempField.getText();
        if (!(null == this.xmlDoc.getTemplateByNameAttribute(this.documentName, newName) || this.updateFlag && this.tempName.equals(newName))) {
            StaticUtil.errorMessage("\u767b\u9332\u6e08\u307f\u306e\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u540d\u3067\u3059", "\u30a8\u30e9\u30fc");
            return false;
        }
        this.tempName = this.tempField.getText();
        this.template = this.tempArea.getText();
        this.model = new XmlModelTemplate(this.tempName, this.template);
        return true;
    }

    public void windowClosing(WindowEvent e) {
        this.model = null;
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public XmlModelTemplate getModel() {
        return this.model;
    }
}

