/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.model;

import java.util.Vector;
import jp.sourceforge.jhime.pectin.model.XmlModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlModelAttribute
extends XmlModel {
    public static final int COMBOBOX_NONE = 0;
    public static final int COMBOBOX_INPUT = 1;
    public static final int COMBOBOX_SELECT = 2;
    public static final String REQUIRED = "required";
    public static final String VALUE = "value";
    public static final String CASE = "case";
    public static final String TEXT = "text";
    private boolean required;
    private String initValue;
    private int combobox;
    private Vector caseValue;

    public XmlModelAttribute(String name, boolean required, String initValue, int combobox, Vector caseValue) {
        this.setName(name);
        this.setType("attribute");
        this.required = required;
        this.initValue = initValue;
        this.combobox = combobox;
        this.caseValue = caseValue;
    }

    public XmlModelAttribute(Element docNode, Element element) {
        super(docNode, element);
        this.required = this.getRequired(element);
        this.initValue = this.getValue(element);
        this.combobox = this.getComboBox(element);
        this.caseValue = this.getCaseValue(element);
    }

    private boolean getRequired(Element element) {
        return element.getAttributeNode(REQUIRED) != null;
    }

    private String getValue(Element element) {
        if (element.getAttributeNode(VALUE) == null) {
            return null;
        }
        return element.getAttributeNode(VALUE).getValue();
    }

    private int getComboBox(Element element) {
        Attr attr = element.getAttributeNode(CASE);
        if (attr == null) {
            return 0;
        }
        return attr.getValue().equals(CASE) ? 2 : 1;
    }

    private Vector getCaseValue(Element element) {
        Vector<String> vector = new Vector<String>();
        NodeList nodeList = element.getElementsByTagName("param");
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String caseValue = ((Element)node).getAttribute(VALUE);
            vector.add(caseValue);
        }
        return vector;
    }

    public boolean getRequired() {
        return this.required;
    }

    public String getValue() {
        return this.initValue;
    }

    public int getComboBox() {
        return this.combobox;
    }

    public Vector getCaseValue() {
        return this.caseValue;
    }

    public Element createElement(Document doc) {
        String name = this.getName();
        boolean required = this.getRequired();
        String initValue = this.getValue();
        Vector vector = this.getCaseValue();
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        Element attributeElement = doc.createElement("attribute");
        attributeElement.setAttribute("name", name);
        if (required) {
            attributeElement.setAttribute(REQUIRED, REQUIRED);
        }
        if (initValue != null) {
            attributeElement.setAttribute(VALUE, initValue);
        } else if (this.getComboBox() != 0) {
            if (this.getComboBox() == 1) {
                attributeElement.setAttribute(CASE, TEXT);
            } else {
                attributeElement.setAttribute(CASE, CASE);
            }
            for (int i = 0; i < vector.size(); ++i) {
                String val = (String)vector.get(i);
                Element paramElement = doc.createElement("param");
                paramElement.setAttribute(VALUE, val);
                attributeElement.appendChild(paramElement);
            }
        }
        return attributeElement;
    }

    public String getString() {
        if (!this.getRequired()) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        buff.append(" " + this.getName());
        buff.append("=\"");
        if (0 == this.getComboBox()) {
            buff.append(this.initValue);
        } else {
            buff.append((String)this.getCaseValue().get(0));
        }
        buff.append("=\"");
        return buff.toString();
    }
}

