/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.xml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sourceforge.jhime.pectin.model.XmlModelCode;
import jp.sourceforge.jhime.pectin.model.XmlTreeModel;
import jp.sourceforge.jhime.pectin.pectin;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDocumentCode
extends XMLDocument {
    private static XMLDocument xmlDoc = null;
    private boolean errorFlag = false;

    private XMLDocumentCode() {
        DocumentBuilder builder = null;
        this.xmlDir = pectin.userDir;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            FileInputStream is = new FileInputStream(this.xmlDir + "/code.xml");
            this.doc = builder.parse(is);
            ((InputStream)is).close();
        }
        catch (ParserConfigurationException e) {
            StaticUtil.errorMessage("\u30b3\u30fc\u30c9\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u69cb\u6210\u30a8\u30e9\u30fc");
            this.errorFlag = true;
        }
        catch (FileNotFoundException e) {
            this.doc = builder.newDocument();
            try {
                Element root = this.doc.createElement("documentRoot");
                this.doc.appendChild(root);
            }
            catch (DOMException de) {
                this.errorFlag = true;
            }
        }
        catch (SAXException e) {
            StaticUtil.errorMessage("\u30b3\u30fc\u30c9\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "SAX\u30a8\u30e9\u30fc");
            this.errorFlag = true;
        }
        catch (IOException e) {
            StaticUtil.errorMessage("\u30b3\u30fc\u30c9\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "IO\u30a8\u30e9\u30fc");
            this.errorFlag = true;
        }
    }

    private Vector getCodeTreeModel(Element docNode, Vector vector) {
        Node node;
        NodeList elementsList = docNode.getElementsByTagName("group");
        if (elementsList == null) {
            return vector;
        }
        int len = elementsList.getLength();
        for (int i = 0; i < len && (node = elementsList.item(i)).getNodeType() == 1; ++i) {
            Node enode;
            if (!"elements".equals(((Element)node).getAttribute("type"))) continue;
            XmlTreeModel tree = new XmlTreeModel(((Element)node).getAttribute("name"));
            NodeList nodeList = ((Element)node).getElementsByTagName("code");
            int elen = nodeList.getLength();
            for (int j = 0; j < elen && (enode = nodeList.item(j)).getNodeType() == 1; ++j) {
                XmlModelCode element = new XmlModelCode(docNode, (Element)enode);
                tree.add(element);
            }
            vector.add(tree);
        }
        return vector;
    }

    public static XMLDocument newInstance() {
        if (xmlDoc == null) {
            xmlDoc = new XMLDocumentCode();
        }
        return xmlDoc;
    }

    public boolean transform() {
        boolean flag = false;
        try {
            TransformerFactory formerFactory = TransformerFactory.newInstance();
            Transformer former = formerFactory.newTransformer();
            DOMSource xmlSource = new DOMSource(this.doc.getDocumentElement());
            StreamResult outputTarget = new StreamResult(new FileOutputStream(this.xmlDir + "/code.xml"));
            former.transform(xmlSource, outputTarget);
            flag = true;
        }
        catch (TransformerFactoryConfigurationError e) {
        }
        catch (TransformerConfigurationException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (TransformerException e) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return flag;
    }

    public Vector getTreeModel(String documentName) {
        Element docNode = this.getDocumentElement(documentName);
        Vector tree = new Vector();
        tree = this.getCodeTreeModel(docNode, tree);
        return tree;
    }

    public boolean isError() {
        return this.errorFlag;
    }
}

