/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.action;

import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import jp.sourceforge.jhime.pectin.action.FileMenuActionHandler;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;

public class FileMenuAction {
    private GUIFrame appObject;
    private JMenu file_menu;
    private JMenuItem file_menu_new = null;
    private JButton tool_bar_new = null;
    private JMenuItem file_menu_open = null;
    private JButton tool_bar_open = null;
    private JMenuItem file_menu_close = null;
    private JMenuItem file_menu_save = null;
    private JButton tool_bar_save = null;
    private JMenuItem file_menu_save_as = null;
    private JMenuItem file_menu_option = null;
    private JMenuItem file_menu_page = null;
    private JMenuItem file_menu_print = null;
    private JButton tool_bar_print = null;
    private JMenuItem file_menu_exit = null;
    private ActionListener action = null;

    public FileMenuAction(GUIFrame obj) {
        this.appObject = obj;
        this.createFileMenu();
    }

    private void createItem() {
        ImageIcon icon = new ImageIcon(ClassLoader.getSystemResource("images/page_white_add.png"));
        this.file_menu_new = new JMenuItem("\u65b0\u898f\u4f5c\u6210", icon);
        this.tool_bar_new = new JButton(icon);
        this.tool_bar_new.setToolTipText("\u65b0\u898f\u4f5c\u6210");
        icon = new ImageIcon(ClassLoader.getSystemResource("images/folder_page_white.png"));
        this.file_menu_open = new JMenuItem("\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f...", icon);
        this.tool_bar_open = new JButton(icon);
        this.tool_bar_open.setToolTipText("\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f");
        this.file_menu_close = new JMenuItem("\u9589\u3058\u308b");
        icon = new ImageIcon(ClassLoader.getSystemResource("images/disk.png"));
        this.file_menu_save = new JMenuItem("\u4e0a\u66f8\u304d\u4fdd\u5b58", icon);
        this.tool_bar_save = new JButton(icon);
        this.tool_bar_save.setToolTipText("\u4e0a\u66f8\u304d\u4fdd\u5b58");
        this.file_menu_option = new JMenuItem("\u74b0\u5883\u8a2d\u5b9a...");
        this.file_menu_page = new JMenuItem("\u30da\u30fc\u30b8\u8a2d\u5b9a...");
        icon = new ImageIcon(ClassLoader.getSystemResource("images/printer.png"));
        this.file_menu_print = new JMenuItem("\u5370\u5237...", icon);
        this.tool_bar_print = new JButton(icon);
        this.tool_bar_print.setToolTipText("\u5370\u5237");
        this.file_menu_save_as = new JMenuItem("\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58...");
        this.file_menu_exit = new JMenuItem("pectin \u306e\u7d42\u4e86");
    }

    private void setItemAccelerator() {
        int ctrl = 2;
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") > -1) {
            ctrl = 4;
        }
        this.file_menu_new.setAccelerator(KeyStroke.getKeyStroke(78, ctrl));
        this.file_menu_open.setAccelerator(KeyStroke.getKeyStroke(79, ctrl));
        this.file_menu_close.setAccelerator(KeyStroke.getKeyStroke(87, ctrl));
        this.file_menu_save.setAccelerator(KeyStroke.getKeyStroke(83, ctrl));
        this.file_menu_save_as.setAccelerator(KeyStroke.getKeyStroke(83, ctrl | 1));
        this.file_menu_print.setAccelerator(KeyStroke.getKeyStroke(80, ctrl));
    }

    private void setActionListener() {
        this.file_menu_new.setActionCommand("new");
        this.file_menu_open.setActionCommand("open");
        this.file_menu_close.setActionCommand("close");
        this.file_menu_save.setActionCommand("save");
        this.file_menu_save_as.setActionCommand("saveas");
        this.file_menu_option.setActionCommand("option");
        this.file_menu_page.setActionCommand("page");
        this.file_menu_print.setActionCommand("print");
        this.file_menu_exit.setActionCommand("exit");
        this.tool_bar_new.setActionCommand("new");
        this.tool_bar_open.setActionCommand("open");
        this.tool_bar_save.setActionCommand("save");
        this.tool_bar_print.setActionCommand("print");
        this.action = new FileMenuActionHandler(this.appObject, this);
        this.file_menu_new.addActionListener(this.action);
        this.file_menu_open.addActionListener(this.action);
        this.file_menu_close.addActionListener(this.action);
        this.file_menu_save.addActionListener(this.action);
        this.file_menu_save_as.addActionListener(this.action);
        this.file_menu_option.addActionListener(this.action);
        this.file_menu_page.addActionListener(this.action);
        this.file_menu_print.addActionListener(this.action);
        this.file_menu_exit.addActionListener(this.action);
        this.tool_bar_new.addActionListener(this.action);
        this.tool_bar_open.addActionListener(this.action);
        this.tool_bar_save.addActionListener(this.action);
        this.tool_bar_print.addActionListener(this.action);
    }

    private void createFileMenu() {
        this.file_menu = new JMenu("\u30d5\u30a1\u30a4\u30eb");
        this.createItem();
        this.setItemAccelerator();
        this.setActionListener();
        this.file_menu.add(this.file_menu_new);
        this.file_menu.add(this.file_menu_open);
        this.file_menu.addSeparator();
        this.file_menu.add(this.file_menu_close);
        this.file_menu.add(this.file_menu_save);
        this.file_menu.add(this.file_menu_save_as);
        this.file_menu.addSeparator();
        this.file_menu.add(this.file_menu_option);
        this.file_menu.addSeparator();
        this.file_menu.add(this.file_menu_page);
        this.file_menu.add(this.file_menu_print);
        this.file_menu.addSeparator();
        this.file_menu.add(this.file_menu_exit);
        this.setMenuEnabled(false);
    }

    public JMenu getMenu() {
        return this.file_menu;
    }

    public void setMenuEnabled(boolean flag) {
        this.file_menu_close.setEnabled(flag);
        this.file_menu_save.setEnabled(flag);
        this.file_menu_save_as.setEnabled(flag);
        this.file_menu_print.setEnabled(flag);
        this.tool_bar_save.setEnabled(flag);
        this.tool_bar_print.setEnabled(flag);
    }

    public JPanel getToolBar() {
        JPanel pan = new JPanel(new FlowLayout(0, 0, 1));
        pan.add(this.tool_bar_new);
        pan.add(this.tool_bar_open);
        pan.add(this.tool_bar_save);
        pan.setMaximumSize(pan.getPreferredSize());
        return pan;
    }

    public JPanel getToolBar2() {
        JPanel pan = new JPanel(new FlowLayout(0, 0, 1));
        pan.add(this.tool_bar_print);
        pan.setMaximumSize(pan.getPreferredSize());
        return pan;
    }
}

