/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.standard.MediaSize;
import jp.sourceforge.jhime.pectin.action.FileMenuAction;
import jp.sourceforge.jhime.pectin.gui.GUIFileChooser;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIOptionDialog;
import jp.sourceforge.jhime.pectin.gui.GUIPageDialog;
import jp.sourceforge.jhime.pectin.gui.GUIPrint;
import jp.sourceforge.jhime.pectin.gui.GUIView;
import jp.sourceforge.jhime.pectin.util.ResourceUtil;
import jp.sourceforge.jhime.pectin.util.StaticUtil;

public class FileMenuActionHandler
implements ActionListener {
    private GUIFrame appObject;
    private FileMenuAction menuObject;
    public static final String NEW = "new";
    public static final String OPEN = "open";
    public static final String CLOSE = "close";
    public static final String SAVE = "save";
    public static final String SAVEAS = "saveas";
    public static final String OPTION = "option";
    public static final String PAGE = "page";
    public static final String PRINT = "print";
    public static final String EXIT = "exit";

    public FileMenuActionHandler(GUIFrame obj, FileMenuAction menu) {
        this.appObject = obj;
        this.menuObject = menu;
    }

    private void actionNew() {
        if (this.appObject.getViewCount() == 0) {
            this.appObject.setMenuStatus(true);
        }
        this.appObject.addView(new GUIView(this.appObject));
    }

    private void actionOpen() {
        GUIFileChooser fc = new GUIFileChooser();
        int ret = fc.showOpenDialog(this.appObject);
        if (ret == 0) {
            try {
                if (this.appObject.getViewCount() == 0) {
                    this.appObject.setMenuStatus(true);
                }
                GUIView view = new GUIView(this.appObject);
                view.read(fc.getSelectedFile(), fc.getEncoding());
                this.appObject.addView(view);
            }
            catch (Exception e) {
                StaticUtil.errorMessage("\u30d5\u30a1\u30a4\u30eb\u306e\u5165\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
            }
        }
    }

    private void actionClose() {
        if (this.appObject.getView().isChangeText()) {
            Object[] options = new Object[]{"\u4fdd\u5b58\u3057\u3066\u9589\u3058\u308b", "\u4fdd\u5b58\u3057\u306a\u3044\u3067\u9589\u3058\u308b", "\u7de8\u96c6\u306b\u623b\u308b"};
            int ret = StaticUtil.warningMessage("\u30c6\u30ad\u30b9\u30c8\u304c\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f", "\u4fdd\u5b58\u78ba\u8a8d", options, 0);
            switch (ret) {
                case 0: {
                    if (this.actionSave() == 0) break;
                    return;
                }
                case -1: 
                case 2: {
                    return;
                }
            }
        }
        this.appObject.removeView();
        if (this.appObject.getViewCount() == 0) {
            this.appObject.setMenuStatus(false);
            this.appObject.setStatusBarPosition(" ");
            this.appObject.getFindDialog().setVisible(false);
        }
    }

    private int actionSave() {
        if (this.appObject.getView().getFileName() == null) {
            return this.actionSaveAs();
        }
        try {
            this.appObject.getView().write(this.appObject.getView().getPathName(), this.appObject.getView().getEncoding());
        }
        catch (Exception e) {
            StaticUtil.errorMessage("\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
            return -1;
        }
        return 0;
    }

    private int actionSaveAs() {
        GUIFileChooser fc = new GUIFileChooser();
        int ret = fc.showSaveDialog(this.appObject);
        if (ret == 0) {
            try {
                Object[] options;
                if (fc.getSelectedFile().canRead() && (ret = StaticUtil.warningMessage("\u30d5\u30a1\u30a4\u30eb\u304c\u3059\u3067\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\u66f8\u304d\u63db\u3048\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f", "\u4e0a\u66f8\u304d\u78ba\u8a8d", options = new Object[]{"\u7de8\u96c6\u306b\u623b\u308b", "\u4e0a\u66f8\u304d\u4fdd\u5b58\u3059\u308b"}, 0)) == 0) {
                    return -1;
                }
                this.appObject.getView().write(fc.getSelectedFile(), fc.getEncoding());
                this.appObject.setTitle(this.appObject.getView().getFileName());
            }
            catch (Exception e) {
                StaticUtil.errorMessage("\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
                return -1;
            }
        } else {
            return -1;
        }
        return 0;
    }

    public void actionOption() {
        new GUIOptionDialog(this.appObject);
    }

    public void actionPage() {
        new GUIPageDialog(this.appObject);
    }

    public void actionPrint() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.defaultPage();
        MediaSize ms = MediaSize.getMediaSizeForName(ResourceUtil.getPrintPaperSize());
        double paperWidth = (double)(ms.getX(1000) * 72.0f) / 25.4;
        double paperHeight = (double)(ms.getY(1000) * 72.0f) / 25.4;
        double topMargin = ResourceUtil.getPrintTopMargin() * 72.0 / 25.4;
        double bottomMargin = ResourceUtil.getPrintBottomMargin() * 72.0 / 25.4;
        double leftMargin = ResourceUtil.getPrintLeftMargin() * 72.0 / 25.4;
        double rightMargin = ResourceUtil.getPrintRightMargin() * 72.0 / 25.4;
        double printWidth = paperWidth - leftMargin - rightMargin;
        double printHeight = paperHeight - topMargin - bottomMargin;
        Paper paper = format.getPaper();
        paper.setSize(paperWidth, paperHeight);
        paper.setImageableArea(leftMargin, topMargin, printWidth, printHeight);
        format.setPaper(paper);
        format.setOrientation(ResourceUtil.getPrintPaperOperation());
        job.setJobName(this.appObject.getView().getFileName() + " - pectin print");
        boolean ok = job.printDialog();
        if (ok) {
            try {
                job.setPrintable(new GUIPrint(this.appObject), format);
                job.print();
            }
            catch (PrinterException ex) {
                // empty catch block
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(NEW)) {
            this.actionNew();
        } else if (command.equals(OPEN)) {
            this.actionOpen();
        } else if (command.equals(CLOSE)) {
            this.actionClose();
        } else if (command.equals(SAVE)) {
            this.actionSave();
        } else if (command.equals(SAVEAS)) {
            this.actionSaveAs();
        } else if (command.equals(OPTION)) {
            this.actionOption();
        } else if (command.equals(PAGE)) {
            this.actionPage();
        } else if (command.equals(PRINT)) {
            this.actionPrint();
        } else if (command.equals(EXIT)) {
            this.appObject.dispatchEvent(new WindowEvent(this.appObject, 201));
        }
        if (this.appObject.getViewCount() != 0) {
            this.appObject.getView().setFocus();
        }
    }
}

