/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.undo.UndoManager;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.pectin;
import jp.sourceforge.jhime.pectin.util.ResourceUtil;
import jp.sourceforge.jhime.pectin.util.StaticUtil;

public class GUIView
extends JPanel {
    private GUIFrame appObject;
    private JTextArea textArea;
    private String fileName;
    private String pathName;
    private String encoding = "UTF-8";
    private String backupText = null;
    private int endOfLine = 0;
    private UndoManager undoMng;
    public static final int LF = 10;
    public static final int CR = 13;

    public GUIView(GUIFrame obj) {
        this.appObject = obj;
        this.fileName = null;
        this.textArea = new JTextArea();
        this.undoMng = new UndoManager();
        this.undoMng.setLimit(32768);
        this.textArea.getDocument().addUndoableEditListener(this.undoMng);
        if (pectin.versionFlag) {
            JPopupMenu popup = this.appObject.getMenuObject().getPopupMenu();
            this.textArea.setComponentPopupMenu(popup);
        }
        this.textArea.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                GUIView.this.focusIn();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.textArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                GUIView.this.getLineAtCaret();
            }
        });
        JScrollPane sp = new JScrollPane(this.textArea, 22, 32);
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
        this.appObject.setStatusBarPosition("  \u4f4d\u7f6e:  1\u884c  1\u6841 ");
        this.textAreaSetFormat();
        this.backupText = this.textArea.getText();
    }

    private void setDefaultEdnOfLine() {
        String endOfLine_default = ResourceUtil.getEndOfLine();
        String endOfLine = endOfLine_default.equals("UNIX") ? StaticUtil.getEndOfLineUnix() : (endOfLine_default.equals("MAC") ? StaticUtil.getEndOfLineMac() : StaticUtil.getEndOfLineWin());
        this.textArea.getDocument().putProperty("__EndOfLine__", endOfLine);
    }

    private void focusIn() {
        boolean bool = this.textArea.getLineWrap();
        this.appObject.getMenuObject().getViewMenu().setWrapSelected(bool);
        String endOfLine = (String)this.textArea.getDocument().getProperty("__EndOfLine__");
        if (endOfLine == null) {
            this.setDefaultEdnOfLine();
        }
        if (endOfLine.equals(StaticUtil.getEndOfLineUnix())) {
            this.appObject.getMenuObject().getViewMenu().setEndOfLineUnix(true);
        } else if (endOfLine.equals(StaticUtil.getEndOfLineMac())) {
            this.appObject.getMenuObject().getViewMenu().setEndOfLineMac(true);
        } else {
            this.appObject.getMenuObject().getViewMenu().setEndOfLineWin(true);
        }
        this.getLineAtCaret();
    }

    private void getLineAtCaret() {
        Element root = this.textArea.getDocument().getDefaultRootElement();
        int pos = this.textArea.getCaretPosition();
        int row = root.getElementIndex(pos);
        int col = pos - root.getElement(row).getStartOffset();
        this.appObject.setStatusBarPosition("  \u4f4d\u7f6e:  " + (row + 1) + "\u884c  " + (col + 1) + "\u6841 ");
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void read(File file, String encoding) throws IOException {
        this.fileName = file.getName();
        this.pathName = file.getPath();
        this.encoding = encoding;
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(this.pathName), encoding);
        this.textArea.read(r, null);
        this.textAreaSetFormat();
        this.backupText = this.textArea.getText();
        if (this.backupText.indexOf(10) == -1) {
            this.setDefaultEdnOfLine();
        }
        this.textArea.getDocument().removeUndoableEditListener(this.undoMng);
        this.textArea.getDocument().addUndoableEditListener(this.undoMng);
    }

    public void write(String pathName, String encoding) throws IOException {
        this.write(new File(pathName), encoding);
    }

    public void write(File file, String encoding) throws IOException {
        this.fileName = file.getName();
        this.pathName = file.getPath();
        this.encoding = encoding;
        String str = (String)this.textArea.getDocument().getProperty("__EndOfLine__");
        if (str != null) {
            System.setProperty("line.separator", str);
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(this.pathName), encoding);
        this.textArea.write(w);
        this.backupText = this.textArea.getText();
    }

    public boolean isChangeText() {
        return !this.textArea.getText().equals(this.backupText);
    }

    public void setFocus() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                GUIView.this.textArea.requestFocusInWindow();
            }
        });
    }

    public void cut() {
        this.textArea.cut();
    }

    public void copy() {
        this.textArea.copy();
    }

    public void paste() {
        this.textArea.paste();
    }

    public void selectAll() {
        this.textArea.selectAll();
    }

    public void textAreaSetFormat() {
        int fontSize = ResourceUtil.getFontSize();
        int tabSize = ResourceUtil.getTabSize();
        int color = ResourceUtil.getColor();
        int background = ResourceUtil.getBackground();
        this.textArea.setMargin(new Insets(3, 3, 3, 3));
        this.textArea.setFont(new Font("Monospaced", 0, fontSize));
        this.textArea.setTabSize(tabSize);
        this.textArea.setForeground(new Color(color));
        this.textArea.setCaretColor(new Color(color));
        this.textArea.setBackground(new Color(background));
        String str = (String)this.textArea.getDocument().getProperty("__EndOfLine__");
        if (str == null) {
            this.setDefaultEdnOfLine();
        }
    }

    public void setWrap(boolean bool) {
        this.textArea.setLineWrap(bool);
    }

    public void setEndOfLine(String endOfLine) {
        this.textArea.getDocument().putProperty("__EndOfLine__", endOfLine);
    }

    public void addHighlight() {
        DefaultHighlighter.DefaultHighlightPainter rPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(ResourceUtil.getHighlightXml(), true));
        DefaultHighlighter.DefaultHighlightPainter gPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(ResourceUtil.getHighlightTag(), true));
        DefaultHighlighter.DefaultHighlightPainter bPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(ResourceUtil.getHighlightEmpty(), true));
        this.deleteHighlight();
        try {
            Highlighter hilite = this.textArea.getHighlighter();
            Document doc = this.textArea.getDocument();
            String text = doc.getText(0, doc.getLength());
            int textLength = text.length();
            int pos = 0;
            while ((pos = text.indexOf("<", pos)) >= 0) {
                int ePos = text.indexOf(">", pos + 1);
                if (ePos < 0) {
                    ePos = textLength - 1;
                }
                int len = ePos - pos + 1;
                DefaultHighlighter.DefaultHighlightPainter painter = gPainter;
                if (pos + 1 < textLength) {
                    char c = text.charAt(pos + 1);
                    if (c == '!' || c == '?') {
                        painter = rPainter;
                    } else if (ePos > 1 && (c = text.charAt(ePos - 1)) == '/') {
                        painter = bPainter;
                    }
                }
                hilite.addHighlight(pos, pos + len, painter);
                pos += len;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public void deleteHighlight() {
        Highlighter hilite = this.textArea.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        for (int i = 0; i < hilites.length; ++i) {
            if (!(hilites[i].getPainter() instanceof DefaultHighlighter.DefaultHighlightPainter)) continue;
            hilite.removeHighlight(hilites[i]);
        }
    }

    public int getCaretPosition() {
        return this.textArea.getCaretPosition();
    }

    public void setCaretPosition(int pos) {
        this.textArea.setCaretPosition(pos);
    }

    public int getOffsetLine(int lineNo) {
        Element root = this.textArea.getDocument().getDefaultRootElement();
        Element line = root.getElement(lineNo);
        int offset = -1;
        if (line != null) {
            offset = line.getStartOffset();
        }
        return offset;
    }

    public int indexOf(String str, int fromIndex, boolean bool) {
        int pos = bool ? this.textArea.getText().toUpperCase().indexOf(str.toUpperCase(), fromIndex) : this.textArea.getText().indexOf(str, fromIndex);
        return pos;
    }

    public int lastIndexOf(String str, int fromIndex, boolean bool) {
        int pos = bool ? this.textArea.getText().toUpperCase().lastIndexOf(str.toUpperCase(), fromIndex) : this.textArea.getText().lastIndexOf(str, fromIndex);
        return pos;
    }

    public void select(int startPos, int endPos) {
        this.textArea.setCaretPosition(startPos);
        this.textArea.moveCaretPosition(endPos);
    }

    public int isSelect() {
        int sPos = this.textArea.getSelectionStart();
        int ePos = this.textArea.getSelectionEnd();
        return ePos - sPos;
    }

    public void replaceRange(String str) {
        int sPos = this.textArea.getSelectionStart();
        int ePos = this.textArea.getSelectionEnd();
        this.textArea.replaceRange(str, sPos, ePos);
        this.select(sPos, sPos + str.length());
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void insertTag(String startTag, String endTag) {
        int sPos = this.textArea.getSelectionStart();
        int ePos = this.textArea.getSelectionEnd();
        this.textArea.insert(endTag, ePos);
        this.textArea.insert(startTag, sPos);
        this.textArea.setCaretPosition(sPos + startTag.length());
        this.textArea.requestFocusInWindow();
    }

    public void undo() {
        if (this.undoMng.canUndo()) {
            this.undoMng.undo();
        }
    }

    public void redo() {
        if (this.undoMng.canRedo()) {
            this.undoMng.redo();
        }
    }
}

