/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.model.XmlModelDtd;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;
import jp.sourceforge.jhime.pectin.xml.XMLDocumentUser;

public class GUIXmlDtdElementDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private JButton okBtn;
    private JButton cancelBtn;
    private JTextField dtdField;
    private JTextField rootField;
    private JCheckBox publicBtn;
    private JTextField publicField;
    private JCheckBox systemBtn;
    private JTextField systemField;
    private String documentName;
    private String dtdName;
    private String rootName;
    private String publicValue;
    private String systemValue;
    private XmlModelDtd model;
    private boolean updateFlag;

    public GUIXmlDtdElementDialog(GUIFrame obj, String documentName, XmlModelDtd model, boolean updateFlag) {
        super((Frame)null, "XML\u6587\u66f8\u578b\u5b9a\u7fa9\u8a2d\u5b9a", true);
        this.appObject = obj;
        this.documentName = documentName;
        this.model = model;
        this.updateFlag = updateFlag;
        if (this.model != null) {
            this.dtdName = this.model.getName();
            this.rootName = this.model.getRootName();
            this.publicValue = this.model.getPublicValue();
            this.systemValue = this.model.getSystemValue();
        }
        this.paramInitialize();
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    public GUIXmlDtdElementDialog(GUIFrame obj, String documentName) {
        this(obj, documentName, null, false);
    }

    public GUIXmlDtdElementDialog(GUIFrame obj, String documentName, XmlModelDtd model) {
        this(obj, documentName, model, true);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u8a2d\u5b9a");
        this.cancelBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!GUIXmlDtdElementDialog.this.actionOk()) {
                    return;
                }
                GUIXmlDtdElementDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlDtdElementDialog.this.model = null;
                GUIXmlDtdElementDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.cancelBtn);
        pan.add(this.okBtn);
        return pan;
    }

    private void paramInitialize() {
        this.dtdField = new JTextField(15);
        if (this.dtdName != null) {
            this.dtdField.setText(this.dtdName);
        }
        this.rootField = new JTextField(10);
        if (this.rootName != null) {
            this.rootField.setText(this.rootName);
        }
        this.publicBtn = new JCheckBox("\u516c\u958b\u8b58\u5225\u5b50");
        this.publicField = new JTextField(30);
        if (this.publicValue != null && this.publicValue.trim().length() > 0) {
            this.publicField.setText(this.publicValue);
            this.publicBtn.setSelected(true);
        }
        this.systemBtn = new JCheckBox("\u30b7\u30b9\u30c6\u30e0\u8b58\u5225\u5b50");
        this.systemField = new JTextField(30);
        if (this.systemValue != null && this.systemValue.trim().length() > 0) {
            this.systemField.setText(this.systemValue);
            this.systemBtn.setSelected(true);
        }
    }

    private JPanel createContentsPanel() {
        this.addAction();
        GUIGridPanel pan = new GUIGridPanel();
        pan.gridLayoutComponent(new JLabel("DTD\u5b9a\u7fa9\u540d"), 0, 0);
        pan.setWidth(2);
        pan.gridLayoutComponent(this.dtdField, 1, 0);
        pan.setWidth(1);
        pan.gridLayoutComponent(new JLabel("\u30eb\u30fc\u30c8\u8981\u7d20\u540d"), 0, 1);
        pan.gridLayoutComponent(this.rootField, 1, 1);
        pan.gridLayoutComponent(this.publicBtn, 0, 2);
        pan.setWidth(3);
        pan.gridLayoutComponent(this.publicField, 1, 2, this.publicBtn.isSelected());
        pan.setWidth(1);
        pan.gridLayoutComponent(this.systemBtn, 0, 3);
        pan.setWidth(3);
        pan.gridLayoutComponent(this.systemField, 1, 3, this.systemBtn.isSelected());
        return pan;
    }

    private void addAction() {
        this.publicBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    GUIXmlDtdElementDialog.this.publicField.setEnabled(true);
                    GUIXmlDtdElementDialog.this.publicField.requestFocusInWindow();
                } else {
                    GUIXmlDtdElementDialog.this.publicField.setEnabled(false);
                }
            }
        });
        this.systemBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    GUIXmlDtdElementDialog.this.systemField.setEnabled(true);
                    GUIXmlDtdElementDialog.this.systemField.requestFocusInWindow();
                } else {
                    GUIXmlDtdElementDialog.this.systemField.setEnabled(false);
                }
            }
        });
    }

    private boolean actionOk() {
        String newName;
        if (this.dtdField.getText().trim().length() == 0 || this.rootField.getText().trim().length() == 0) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u5b9a\u7fa9\u540d\u3001\u30eb\u30fc\u30c8\u8981\u7d20\u540d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044", "\u30a8\u30e9\u30fc");
            return false;
        }
        XMLDocument xmlDoc = XMLDocumentUser.newInstance();
        if (!(null == xmlDoc.getDtdByNameAttribute(this.documentName, newName = this.dtdField.getText()) || this.updateFlag && this.dtdName.equals(newName))) {
            StaticUtil.errorMessage("\u767b\u9332\u6e08\u307f\u306e\u6587\u66f8\u578b\u5b9a\u7fa9\u540d\u3067\u3059", "\u30a8\u30e9\u30fc");
            return false;
        }
        this.dtdName = newName;
        this.rootName = this.rootField.getText();
        this.publicValue = this.publicBtn.isSelected() ? this.publicField.getText() : null;
        this.systemValue = this.systemBtn.isSelected() ? this.systemField.getText() : null;
        this.model = new XmlModelDtd(this.dtdName, this.rootName, this.publicValue, this.systemValue);
        return true;
    }

    public void windowClosing(WindowEvent e) {
        this.model = null;
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public XmlModelDtd getModel() {
        return this.model;
    }
}

