/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.model.XmlModelElement;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;
import jp.sourceforge.jhime.pectin.xml.XMLDocumentUser;

public class GUIXmlElementDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private JButton okBtn;
    private JButton cancelBtn;
    private JTextField elementField;
    private JCheckBox emptyBtn;
    private JCheckBox attributeBtn;
    private String documentName;
    private String elementName;
    private boolean empty;
    private boolean attribute;
    private XmlModelElement model;
    private boolean updateFlag;

    public GUIXmlElementDialog(GUIFrame obj, String documentName, XmlModelElement model, boolean updateFlag) {
        super((Frame)null, "XML\u6587\u66f8\u8981\u7d20\u8a2d\u5b9a", true);
        this.appObject = obj;
        this.documentName = documentName;
        this.model = model;
        this.updateFlag = updateFlag;
        if (this.model != null) {
            this.elementName = this.model.getName();
            this.empty = this.model.getEmpty();
            this.attribute = this.model.getAttribute();
        }
        this.paramInitialize();
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    public GUIXmlElementDialog(GUIFrame obj, String documentName, XmlModelElement model) {
        this(obj, documentName, model, true);
    }

    public GUIXmlElementDialog(GUIFrame obj, String documentName) {
        this(obj, documentName, null, false);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u8a2d\u5b9a");
        this.cancelBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!GUIXmlElementDialog.this.actionOk()) {
                    return;
                }
                GUIXmlElementDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlElementDialog.this.model = null;
                GUIXmlElementDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.cancelBtn);
        pan.add(this.okBtn);
        return pan;
    }

    private void paramInitialize() {
        this.elementField = new JTextField(10);
        if (this.elementName != null) {
            this.elementField.setText(this.elementName);
        }
        this.emptyBtn = new JCheckBox("\u7a7a\u8981\u7d20", this.empty);
        this.attributeBtn = new JCheckBox("\u5c5e\u6027\u5165\u529b\u5fc5\u9808", this.attribute);
    }

    private JPanel createContentsPanel() {
        this.addAction();
        GUIGridPanel pan = new GUIGridPanel();
        pan.gridLayoutComponent(new JLabel("\u8981\u7d20\u540d"), 0, 0);
        pan.gridLayoutComponent(this.elementField, 1, 0);
        pan.gridLayoutComponent(this.emptyBtn, 2, 0);
        pan.gridLayoutComponent(this.attributeBtn, 3, 0);
        return pan;
    }

    private void addAction() {
    }

    private boolean actionOk() {
        String newName;
        if (this.elementField.getText().trim().length() == 0) {
            StaticUtil.errorMessage("\u8981\u7d20\u540d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044", "\u30a8\u30e9\u30fc");
            return false;
        }
        XMLDocument xmlDoc = XMLDocumentUser.newInstance();
        if (!(null == xmlDoc.getElementByNameAttribute(this.documentName, newName = this.elementField.getText()) || this.updateFlag && this.elementName.equals(newName))) {
            StaticUtil.errorMessage("\u767b\u9332\u6e08\u307f\u306e\u8981\u7d20\u540d\u3067\u3059", "\u30a8\u30e9\u30fc");
            return false;
        }
        this.elementName = this.elementField.getText();
        this.empty = this.emptyBtn.isSelected();
        this.attribute = this.attributeBtn.isSelected();
        this.model = new XmlModelElement(this.elementName, this.empty, this.attribute);
        return true;
    }

    public void windowClosing(WindowEvent e) {
        this.model = null;
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public XmlModelElement getModel() {
        return this.model;
    }
}

