/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.action;

import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import jp.sourceforge.jhime.pectin.action.EditMenuActionHandler;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;

public class EditMenuAction {
    private GUIFrame appObject;
    private JMenu edit_menu;
    private JMenuItem edit_menu_undo = null;
    private JButton tool_bar_undo = null;
    private JMenuItem edit_menu_redo = null;
    private JButton tool_bar_redo = null;
    private JMenuItem edit_menu_cut = null;
    private JButton tool_bar_cut = null;
    private JMenuItem edit_menu_copy = null;
    private JButton tool_bar_copy = null;
    private JMenuItem edit_menu_paste = null;
    private JButton tool_bar_paste = null;
    private JMenuItem edit_menu_all = null;
    private ActionListener action = null;

    public EditMenuAction(GUIFrame obj) {
        this.appObject = obj;
        this.createEditMenu();
    }

    private void createItem() {
        ImageIcon icon = new ImageIcon(ClassLoader.getSystemResource("images/arrow_rotate_anticlockwise.png"));
        this.edit_menu_undo = new JMenuItem("\u5143\u306b\u623b\u3059", icon);
        this.tool_bar_undo = new JButton(icon);
        this.tool_bar_undo.setToolTipText("\u5143\u306b\u623b\u3059");
        icon = new ImageIcon(ClassLoader.getSystemResource("images/arrow_rotate_clockwise.png"));
        this.edit_menu_redo = new JMenuItem("\u3084\u308a\u76f4\u3057", icon);
        this.tool_bar_redo = new JButton(icon);
        this.tool_bar_redo.setToolTipText("\u3084\u308a\u76f4\u3057");
        icon = new ImageIcon(ClassLoader.getSystemResource("images/cut.png"));
        this.edit_menu_cut = new JMenuItem("\u30ab\u30c3\u30c8", icon);
        this.tool_bar_cut = new JButton(icon);
        this.tool_bar_cut.setToolTipText("\u30ab\u30c3\u30c8");
        icon = new ImageIcon(ClassLoader.getSystemResource("images/page_copy.png"));
        this.edit_menu_copy = new JMenuItem("\u30b3\u30d4\u30fc", icon);
        this.tool_bar_copy = new JButton(icon);
        this.tool_bar_copy.setToolTipText("\u30b3\u30d4\u30fc");
        icon = new ImageIcon(ClassLoader.getSystemResource("images/page_paste.png"));
        this.edit_menu_paste = new JMenuItem("\u30da\u30fc\u30b9\u30c8", icon);
        this.tool_bar_paste = new JButton(icon);
        this.tool_bar_paste.setToolTipText("\u30da\u30fc\u30b9\u30c8");
        this.edit_menu_all = new JMenuItem("\u3059\u3079\u3066\u3092\u9078\u629e");
    }

    private void setItemAccelerator() {
        int ctrl = 2;
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") > -1) {
            ctrl = 4;
        }
        this.edit_menu_undo.setAccelerator(KeyStroke.getKeyStroke(90, ctrl));
        this.edit_menu_redo.setAccelerator(KeyStroke.getKeyStroke(90, ctrl | 1));
        this.edit_menu_cut.setAccelerator(KeyStroke.getKeyStroke(88, ctrl));
        this.edit_menu_copy.setAccelerator(KeyStroke.getKeyStroke(67, ctrl));
        this.edit_menu_paste.setAccelerator(KeyStroke.getKeyStroke(86, ctrl));
        this.edit_menu_all.setAccelerator(KeyStroke.getKeyStroke(65, ctrl));
    }

    private void setActionListener() {
        this.edit_menu_undo.setActionCommand("undo");
        this.edit_menu_redo.setActionCommand("redo");
        this.edit_menu_cut.setActionCommand("cut");
        this.edit_menu_copy.setActionCommand("copy");
        this.edit_menu_paste.setActionCommand("paste");
        this.edit_menu_all.setActionCommand("all");
        this.tool_bar_undo.setActionCommand("undo");
        this.tool_bar_redo.setActionCommand("redo");
        this.tool_bar_cut.setActionCommand("cut");
        this.tool_bar_copy.setActionCommand("copy");
        this.tool_bar_paste.setActionCommand("paste");
        this.action = new EditMenuActionHandler(this.appObject, this);
        this.edit_menu_undo.addActionListener(this.action);
        this.edit_menu_redo.addActionListener(this.action);
        this.edit_menu_cut.addActionListener(this.action);
        this.edit_menu_copy.addActionListener(this.action);
        this.edit_menu_paste.addActionListener(this.action);
        this.edit_menu_all.addActionListener(this.action);
        this.tool_bar_undo.addActionListener(this.action);
        this.tool_bar_redo.addActionListener(this.action);
        this.tool_bar_cut.addActionListener(this.action);
        this.tool_bar_copy.addActionListener(this.action);
        this.tool_bar_paste.addActionListener(this.action);
    }

    private void createEditMenu() {
        this.edit_menu = new JMenu("\u7de8\u96c6");
        this.createItem();
        this.setItemAccelerator();
        this.setActionListener();
        this.edit_menu.add(this.edit_menu_undo);
        this.edit_menu.add(this.edit_menu_redo);
        this.edit_menu.addSeparator();
        this.edit_menu.add(this.edit_menu_cut);
        this.edit_menu.add(this.edit_menu_copy);
        this.edit_menu.add(this.edit_menu_paste);
        this.edit_menu.addSeparator();
        this.edit_menu.add(this.edit_menu_all);
        this.setMenuEnabled(false);
    }

    public JMenu getMenu() {
        return this.edit_menu;
    }

    public void setMenuEnabled(boolean flag) {
        this.edit_menu_undo.setEnabled(flag);
        this.edit_menu_redo.setEnabled(flag);
        this.edit_menu_cut.setEnabled(flag);
        this.edit_menu_copy.setEnabled(flag);
        this.edit_menu_paste.setEnabled(flag);
        this.edit_menu_all.setEnabled(flag);
        this.tool_bar_undo.setEnabled(flag);
        this.tool_bar_redo.setEnabled(flag);
        this.tool_bar_cut.setEnabled(flag);
        this.tool_bar_copy.setEnabled(flag);
        this.tool_bar_paste.setEnabled(flag);
    }

    public JPanel getToolBar1() {
        JPanel pan = new JPanel(new FlowLayout(0, 0, 1));
        pan.add(this.tool_bar_undo);
        pan.add(this.tool_bar_redo);
        pan.setMaximumSize(pan.getPreferredSize());
        return pan;
    }

    public JPanel getToolBar2() {
        JPanel pan = new JPanel(new FlowLayout(0, 0, 1));
        pan.add(this.tool_bar_cut);
        pan.add(this.tool_bar_copy);
        pan.add(this.tool_bar_paste);
        pan.setMaximumSize(pan.getPreferredSize());
        return pan;
    }
}

