/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.model.XmlModelPi;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;
import jp.sourceforge.jhime.pectin.xml.XMLDocumentUser;

public class GUIXmlPIElementDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private JButton okBtn;
    private JButton cancelBtn;
    private JTextField elementField;
    private JCheckBox attributeBtn;
    private String documentName;
    private String elementName;
    private XmlModelPi model;
    private boolean updateFlag;

    public GUIXmlPIElementDialog(GUIFrame obj, String documentName, XmlModelPi model, boolean updateFlag) {
        super((Frame)null, "XML\u51e6\u7406\u547d\u4ee4\u8a2d\u5b9a", true);
        this.appObject = obj;
        this.documentName = documentName;
        this.model = model;
        this.updateFlag = updateFlag;
        if (this.model != null) {
            this.elementName = this.model.getName();
        }
        this.paramInitialize();
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    public GUIXmlPIElementDialog(GUIFrame obj, String documentName) {
        this(obj, documentName, null, false);
    }

    public GUIXmlPIElementDialog(GUIFrame obj, String documentName, XmlModelPi model) {
        this(obj, documentName, model, true);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u8a2d\u5b9a");
        this.cancelBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!GUIXmlPIElementDialog.this.actionOk()) {
                    return;
                }
                GUIXmlPIElementDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlPIElementDialog.this.model = null;
                GUIXmlPIElementDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.cancelBtn);
        pan.add(this.okBtn);
        return pan;
    }

    private void paramInitialize() {
        this.elementField = new JTextField(10);
        if (this.elementName != null) {
            this.elementField.setText(this.elementName);
        }
    }

    private JPanel createContentsPanel() {
        this.addAction();
        GUIGridPanel pan = new GUIGridPanel();
        pan.gridLayoutComponent(new JLabel("\u51e6\u7406\u547d\u4ee4\u540d"), 0, 0);
        pan.gridLayoutComponent(this.elementField, 1, 0);
        return pan;
    }

    private void addAction() {
    }

    private boolean actionOk() {
        String newName;
        if (this.elementField.getText().trim().length() == 0) {
            StaticUtil.errorMessage("\u51e6\u7406\u547d\u4ee4\u540d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044", "\u30a8\u30e9\u30fc");
            return false;
        }
        XMLDocument xmlDoc = XMLDocumentUser.newInstance();
        if (!(null == xmlDoc.getPiByNameAttribute(this.documentName, newName = this.elementField.getText()) || this.updateFlag && this.elementName.equals(newName))) {
            StaticUtil.errorMessage("\u767b\u9332\u6e08\u307f\u306e\u51e6\u7406\u547d\u4ee4\u540d\u3067\u3059", "\u30a8\u30e9\u30fc");
            return false;
        }
        this.elementName = newName;
        this.model = new XmlModelPi(this.elementName);
        return true;
    }

    public void windowClosing(WindowEvent e) {
        this.model = null;
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public XmlModelPi getModel() {
        return this.model;
    }
}

