/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.gui.GUIFileChooser;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PluginGUIXMLAttributePanel
extends JPanel {
    private ArrayList attributeArray;
    private GUIGridPanel gridPanel;
    private String title;

    public PluginGUIXMLAttributePanel(Element element, ArrayList attributeArray) {
        this.attributeArray = attributeArray;
        this.setLayout(new BorderLayout(5, 5));
        JComponent cPan = this.createContentsPanel();
        this.add((Component)cPan, "Center");
    }

    private JComponent createContentsPanel() {
        this.gridPanel = new GUIGridPanel();
        for (int i = 0; i < this.attributeArray.size(); ++i) {
            Element attrElement = (Element)this.attributeArray.get(i);
            this.addContentsPanel(this.gridPanel, attrElement, i);
        }
        return this.gridPanel;
    }

    private void addContentsPanel(GUIGridPanel pane, Element attrElement, int y) {
        String type = this.getAttributeType(attrElement);
        JComponent comp1 = this.createAttribute(attrElement);
        pane.gridLayoutComponent(comp1, 0, y);
        if (type.equals("text") || type.equals("case") || type.equals("field")) {
            JComponent comp2 = this.createValue(attrElement, type);
            pane.gridLayoutComponent(comp2, 1, y);
            if (comp1.getClass().getName().equals("javax.swing.JCheckBox")) {
                comp2.setEnabled(false);
                ((JCheckBox)comp1).addItemListener(new CheckBoxItemListener(comp2));
            }
        } else if (type.equals("file") || type.equals("xfile") || type.equals("afile") || type.equals("gfile") || type.equals("ofile")) {
            JButton btn = new JButton("\u53c2\u7167");
            JComponent comp2 = this.createValue(attrElement, "field");
            JButton comp3 = btn;
            pane.gridLayoutComponent(comp2, 1, y);
            pane.gridLayoutComponent(comp3, 2, y);
            if (comp1.getClass().getName().equals("javax.swing.JCheckBox")) {
                comp2.setEnabled(false);
                ((JComponent)comp3).setEnabled(false);
                ((JCheckBox)comp1).addItemListener(new CheckBoxItemListener(comp2, comp3));
            }
            btn.addActionListener(new ButtonActionListener((JTextField)comp2, type));
        }
    }

    private String getAttributeType(Element attrElement) {
        String type = attrElement.getAttribute("type");
        if (type.length() == 0) {
            type = "field";
        }
        return type;
    }

    private JComponent createAttribute(Element attrElement) {
        String name = attrElement.getAttribute("name");
        String required = attrElement.getAttribute("required");
        if (required.equals("required")) {
            JLabel label = new JLabel(name);
            return label;
        }
        JCheckBox checkBox = new JCheckBox(name);
        return checkBox;
    }

    private JComponent createValue(Element attrElement, String type) {
        if (type.equals("case") || type.equals("text")) {
            return this.createComboBox(attrElement, type);
        }
        JTextField field = new JTextField(30);
        String val = attrElement.getAttribute("value");
        field.setText(val);
        return field;
    }

    private JComboBox createComboBox(Element attrElement, String type) {
        JComboBox<String> comboBox = new JComboBox<String>();
        if (type.equals("text")) {
            comboBox.setEditable(true);
        }
        NodeList nodeList = attrElement.getElementsByTagName("param");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element param = (Element)nodeList.item(i);
            String val = param.getAttribute("value");
            comboBox.addItem(val);
        }
        return comboBox;
    }

    private String createString(String name, Component comp) {
        StringBuffer buff = new StringBuffer(" " + name + "=");
        buff.append("\"");
        if (comp.getClass().getName().equals("javax.swing.JTextField")) {
            buff.append(((JTextField)comp).getText());
        } else if (comp.getClass().getName().equals("javax.swing.JComboBox")) {
            buff.append((String)((JComboBox)comp).getSelectedItem());
        }
        buff.append("\"");
        return buff.toString();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.gridPanel.getComponentCount(); ++i) {
            String label;
            Component comp1 = this.gridPanel.getComponent(i);
            if (comp1.getClass().getName().equals("javax.swing.JLabel")) {
                label = ((JLabel)comp1).getText();
                buff.append(this.createString(label, this.gridPanel.getComponent(++i)));
                continue;
            }
            if (!comp1.getClass().getName().equals("javax.swing.JCheckBox") || !((JCheckBox)comp1).isSelected()) continue;
            label = ((JCheckBox)comp1).getText();
            buff.append(this.createString(label, this.gridPanel.getComponent(++i)));
        }
        return buff.toString();
    }

    class ButtonActionListener
    implements ActionListener {
        private JTextField field;
        private String type;

        ButtonActionListener(JTextField field, String type) {
            this.field = field;
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            GUIFileChooser fileDialog = new GUIFileChooser(this.type);
            if (0 != fileDialog.showOpenDialog(null)) {
                return;
            }
            this.field.setText(fileDialog.getPath());
        }
    }

    class CheckBoxItemListener
    implements ItemListener {
        private Component comp1;
        private Component comp2;
        private boolean btnFlag;

        CheckBoxItemListener(Component comp) {
            this.btnFlag = false;
            this.comp1 = comp;
        }

        CheckBoxItemListener(Component comp1, Component comp2) {
            this.btnFlag = true;
            this.comp1 = comp1;
            this.comp2 = comp2;
        }

        public void itemStateChanged(ItemEvent e) {
            if (((JCheckBox)e.getSource()).isSelected()) {
                this.comp1.setEnabled(true);
                if (this.btnFlag) {
                    this.comp2.setEnabled(true);
                }
                this.comp1.requestFocusInWindow();
            } else {
                this.comp1.setEnabled(false);
                if (this.btnFlag) {
                    this.comp2.setEnabled(false);
                }
            }
        }
    }
}

