/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins.css;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.plugins.PluginGUICSSAttributePanel;
import jp.sourceforge.jhime.pectin.plugins.css.CheckBoxItemListener;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUICSSLengthComponent;

public class PluginGUIEffectPanel
extends PluginGUICSSAttributePanel {
    private static final String[] OVERFLOW = new String[]{"visible", "hidden", "scroll", "auto", "inherit"};
    private static final String[] CLIP = new String[]{"\u9818\u57df\u6307\u5b9a", "auto", "inherit"};
    private static final String[] VISIBILITY = new String[]{"visible", "hidden", "collapse", "inherit"};
    private JCheckBox overflowBtn = new JCheckBox("\u30aa\u30fc\u30d0\u30fc\u30d5\u30ed\u30fc");
    private JCheckBox clipBtn = new JCheckBox("\u30af\u30ea\u30c3\u30d7");
    private JCheckBox visibilityBtn = new JCheckBox("\u53ef\u8996\u5c5e\u6027");
    private JComboBox overflowBox = new JComboBox<String>(OVERFLOW);
    private JComboBox clipBox = new JComboBox<String>(CLIP);
    private JLabel[] offsetLabel = new JLabel[4];
    private PluginGUICSSLengthComponent[] offsetComp = new PluginGUICSSLengthComponent[4];
    private JComboBox visibilityBox = new JComboBox<String>(VISIBILITY);

    public PluginGUIEffectPanel() {
        this.initComponent();
        this.setLayout(new BorderLayout(5, 5));
        JComponent cPan = this.createContentsPanel();
        this.add((Component)cPan, "Center");
    }

    private void initComponent() {
        this.overflowBtn.addItemListener(new CheckBoxItemListener(this.overflowBox));
        this.visibilityBtn.addItemListener(new CheckBoxItemListener(this.visibilityBox));
        this.clipBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PluginGUIEffectPanel.this.clipBtnSelected();
            }
        });
        this.clipBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PluginGUIEffectPanel.this.clipBoxSelected();
            }
        });
    }

    private JComponent createContentsPanel() {
        GUIGridPanel gridPanel = new GUIGridPanel();
        gridPanel.gridLayoutComponent(this.overflowBtn, 0, 0);
        gridPanel.gridLayoutComponent(this.overflowBox, 1, 0, false);
        gridPanel.gridLayoutComponent(this.createGapPanel(this.clipBtn), 0, 1);
        gridPanel.gridLayoutComponent(this.createGapPanel(this.clipBox), 1, 1);
        this.clipBox.setEnabled(false);
        for (int i = 0; i < 4; ++i) {
            int y = i + 1;
            String label = null;
            switch (i) {
                case 0: {
                    label = "\u4e0a\u30aa\u30d5\u30bb\u30c3\u30c8";
                    break;
                }
                case 1: {
                    label = "\u53f3\u30aa\u30d5\u30bb\u30c3\u30c8";
                    break;
                }
                case 2: {
                    label = "\u4e0b\u30aa\u30d5\u30bb\u30c3\u30c8";
                    break;
                }
                case 3: {
                    label = "\u5de6\u30aa\u30d5\u30bb\u30c3\u30c8";
                }
            }
            this.offsetLabel[i] = new JLabel(label);
            this.offsetComp[i] = new PluginGUICSSLengthComponent("Length");
            gridPanel.gridLayoutComponent(this.createGapPanel(this.offsetLabel[i]), 2, y);
            this.offsetLabel[i].setEnabled(false);
            gridPanel.gridLayoutComponent(this.offsetComp[i], 3, y, false);
        }
        gridPanel.gridLayoutComponent(this.visibilityBtn, 0, 5);
        gridPanel.gridLayoutComponent(this.visibilityBox, 1, 5, false);
        return gridPanel;
    }

    private JPanel createGapPanel(Component comp) {
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        pane.add(comp, "Center");
        return pane;
    }

    private void clipBtnSelected() {
        block3: {
            block2: {
                if (!this.clipBtn.isSelected()) break block2;
                this.clipBox.setEnabled(true);
                if (!((String)this.clipBox.getSelectedItem()).equals("\u9818\u57df\u6307\u5b9a")) break block3;
                for (int i = 0; i < 4; ++i) {
                    this.offsetLabel[i].setEnabled(true);
                    this.offsetComp[i].setEnabled(true);
                }
                break block3;
            }
            this.clipBox.setEnabled(false);
            for (int i = 0; i < 4; ++i) {
                this.offsetLabel[i].setEnabled(false);
                this.offsetComp[i].setEnabled(false);
            }
        }
    }

    private void clipBoxSelected() {
        if (((String)this.clipBox.getSelectedItem()).equals("\u9818\u57df\u6307\u5b9a")) {
            for (int i = 0; i < 4; ++i) {
                this.offsetLabel[i].setEnabled(true);
                this.offsetComp[i].setEnabled(true);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                this.offsetLabel[i].setEnabled(false);
                this.offsetComp[i].setEnabled(false);
            }
        }
    }

    private String boxString(String name, JComboBox box) {
        StringBuffer buff = new StringBuffer(name);
        buff.append(" " + (String)box.getSelectedItem());
        buff.append(";\n");
        return buff.toString();
    }

    private String clipString() {
        StringBuffer buff = new StringBuffer("\tclip:");
        String str = (String)this.clipBox.getSelectedItem();
        if (str.equals("\u9818\u57df\u6307\u5b9a")) {
            buff.append(" rect(");
            for (int i = 0; i < 4; ++i) {
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(this.offsetComp[i].getString());
            }
            buff.append(")");
        } else {
            buff.append(" " + str);
        }
        buff.append(";\n");
        return buff.toString();
    }

    public String getString() {
        StringBuffer buff = new StringBuffer();
        if (this.overflowBtn.isSelected()) {
            buff.append(this.boxString("\toverflow:", this.overflowBox));
        }
        if (this.clipBtn.isSelected()) {
            buff.append(this.clipString());
        }
        if (this.visibilityBtn.isSelected()) {
            buff.append(this.boxString("\tvisibility:", this.visibilityBox));
        }
        return buff.toString();
    }

    public String toString() {
        return "\u8996\u899a\u52b9\u679c\u306e\u8a2d\u5b9a";
    }
}

