/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.plugins.PluginXMLProperties;

public class GUIPluginDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private JButton okBtn;
    private JButton cancelBtn;
    private PluginXMLProperties pluginProp;
    private JTable pluginTable;
    private PluginTableModel pluginTableModel;

    public GUIPluginDialog(GUIFrame obj) {
        super((Frame)null, "\u30d7\u30e9\u30b0\u30a4\u30f3\u7ba1\u7406", true);
        this.appObject = obj;
        this.paramInitialize();
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)new JScrollPane(this.pluginTable), "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u8a2d\u5b9a");
        this.cancelBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIPluginDialog.this.pluginSetting();
                GUIPluginDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIPluginDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.cancelBtn);
        pan.add(this.okBtn);
        return pan;
    }

    private void paramInitialize() {
        this.pluginProp = new PluginXMLProperties();
        Vector heads = this.pluginProp.createTableHead();
        Vector cells = this.pluginProp.createTableCell();
        this.pluginTableModel = new PluginTableModel(heads, cells);
        this.pluginTable = new JTable(this.pluginTableModel);
    }

    private void pluginSetting() {
        for (int i = 0; i < this.pluginTableModel.getRowCount(); ++i) {
            String pluginName = (String)this.pluginTableModel.getValueAt(i, 0);
            String pluginClassName = (String)this.pluginTableModel.getValueAt(i, 1);
            boolean pluginEnabled = (Boolean)this.pluginTableModel.getValueAt(i, 2);
            this.pluginProp.setEnabled(pluginName, pluginClassName, pluginEnabled);
        }
        this.pluginProp.save();
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    class PluginTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] data;

        PluginTableModel(Vector heads, Vector cells) {
            this.columnNames = heads.toArray(new String[0]);
            int n = cells.size();
            this.data = new Object[n][3];
            for (int i = 0; i < n; ++i) {
                Object[] a = ((Vector)cells.get(i)).toArray();
                this.data[i] = a;
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 2;
        }

        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

