/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.gui.GUIXmlDtdElementDialog;
import jp.sourceforge.jhime.pectin.model.XmlModelDtd;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;
import jp.sourceforge.jhime.pectin.xml.XMLDocumentUser;

public class GUIXmlDtdDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private XMLDocument xmlDoc;
    private JButton okBtn;
    private JButton cancelBtn;
    private JComboBox documentBox;
    private JList dtdList;
    private DefaultListModel dtdModel;
    private JButton dtdAppendBtn;
    private JButton dtdRemoveBtn;
    private JButton dtdUpdateBtn;
    private JButton dtdUpBtn;
    private JButton dtdDownBtn;

    public GUIXmlDtdDialog(GUIFrame obj) {
        super((Frame)null, "XML\u6587\u66f8\u578b\u5ba3\u8a00\u5b9a\u7fa9", true);
        this.appObject = obj;
        this.xmlDoc = XMLDocumentUser.newInstance();
        this.paramInitialize();
        if (this.documentBox.getItemCount() <= 0) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
            return;
        }
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        this.getContentPane().add((Component)new JLabel(""), "West");
        this.getContentPane().add((Component)new JLabel(""), "East");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.actionDocumentList();
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u9589\u3058\u308b");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlDtdDialog.this.transform();
                GUIXmlDtdDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.okBtn);
        return pan;
    }

    private void paramInitialize() {
        this.documentBox = new JComboBox(this.xmlDoc.getDocumentList());
        this.dtdModel = new DefaultListModel();
        this.dtdList = new JList(this.dtdModel);
        ImageIcon iconAdd = new ImageIcon(ClassLoader.getSystemResource("images/add.png"));
        ImageIcon iconDelete = new ImageIcon(ClassLoader.getSystemResource("images/delete.png"));
        ImageIcon iconWrench = new ImageIcon(ClassLoader.getSystemResource("images/wrench.png"));
        ImageIcon iconUp = new ImageIcon(ClassLoader.getSystemResource("images/arrow_up.png"));
        ImageIcon iconDown = new ImageIcon(ClassLoader.getSystemResource("images/arrow_down.png"));
        this.dtdAppendBtn = new JButton(iconAdd);
        this.dtdRemoveBtn = new JButton(iconDelete);
        this.dtdUpdateBtn = new JButton(iconWrench);
        this.dtdUpBtn = new JButton(iconUp);
        this.dtdDownBtn = new JButton(iconDown);
        this.dtdAppendBtn.setToolTipText("DTD\u306e\u8ffd\u52a0");
        this.dtdRemoveBtn.setToolTipText("DTD\u306e\u524a\u9664");
        this.dtdUpdateBtn.setToolTipText("DTD\u306e\u4fee\u6b63");
        this.dtdUpBtn.setToolTipText("\uff11\u3064\u4e0a\u3078");
        this.dtdDownBtn.setToolTipText("\uff11\u3064\u4e0b\u3078");
    }

    private JPanel createContentsPanel() {
        this.addAction();
        JScrollPane dtdScrPane = new JScrollPane(this.dtdList);
        JPanel dtdBtnPane = new JPanel(new GridLayout(1, 5));
        dtdBtnPane.add(this.dtdAppendBtn);
        dtdBtnPane.add(this.dtdRemoveBtn);
        dtdBtnPane.add(this.dtdUpdateBtn);
        dtdBtnPane.add(this.dtdUpBtn);
        dtdBtnPane.add(this.dtdDownBtn);
        JPanel dtdPan = new JPanel(new BorderLayout());
        dtdPan.add((Component)new JLabel("DTD\u30ea\u30b9\u30c8"), "North");
        dtdPan.add((Component)dtdScrPane, "Center");
        dtdPan.add((Component)dtdBtnPane, "South");
        GUIGridPanel gpan = new GUIGridPanel();
        gpan.gridLayoutComponent(new JLabel("\u6587\u66f8\u578b"), 0, 0);
        gpan.gridLayoutComponent(this.documentBox, 1, 0);
        JPanel docPane = new JPanel(new FlowLayout(0));
        docPane.add(gpan);
        JPanel ppan = new JPanel(new BorderLayout());
        ppan.add((Component)docPane, "North");
        ppan.add((Component)dtdPan, "Center");
        return ppan;
    }

    private void addAction() {
        this.documentBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlDtdDialog.this.actionDocumentList();
            }
        });
        this.dtdAppendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlDtdDialog.this.actionDtdAppend();
            }
        });
        this.dtdRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlDtdDialog.this.actionDtdDelete();
            }
        });
        this.dtdUpdateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlDtdDialog.this.actionDtdUpdate();
            }
        });
        this.dtdList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUIXmlDtdDialog.this.actionDtdUpdate();
                }
            }
        });
        this.dtdUpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlDtdDialog.this.actionDtdUpDown(true);
            }
        });
        this.dtdDownBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlDtdDialog.this.actionDtdUpDown(false);
            }
        });
    }

    private void actionDocumentList() {
        String documentName = (String)this.documentBox.getSelectedItem();
        if (documentName == null) {
            return;
        }
        this.dtdModel.clear();
        this.dtdModel = this.xmlDoc.getDtdElementList(this.dtdModel, documentName);
        this.dtdList.setSelectedIndex(0);
    }

    private void transform() {
        this.xmlDoc.transform();
        this.appObject.getUserXmlPanel().update();
    }

    private void actionDtdAppend() {
        String documentName = (String)this.documentBox.getSelectedItem();
        GUIXmlDtdElementDialog dlg = new GUIXmlDtdElementDialog(this.appObject, documentName);
        if (dlg.getModel() == null) {
            return;
        }
        if (!this.xmlDoc.appendDtd(documentName, dlg.getModel())) {
            return;
        }
        this.dtdModel.addElement(dlg.getModel().getName());
        this.dtdList.setSelectedIndex(this.dtdModel.size() - 1);
    }

    private void actionDtdDelete() {
        String dtdName = (String)this.dtdList.getSelectedValue();
        if (dtdName == null) {
            return;
        }
        Object[] options = new Object[]{"\u524a\u9664\u3059\u308b", "\u524a\u9664\u3057\u306a\u3044"};
        int ret = StaticUtil.warningMessage(dtdName + " \u6587\u66f8\u578b\u5ba3\u8a00\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", "\u6587\u66f8\u578b\u5ba3\u8a00\u524a\u9664\u78ba\u8a8d", options, 1);
        if (ret != 0) {
            return;
        }
        String docElement = (String)this.documentBox.getSelectedItem();
        if (!this.xmlDoc.removeDtd(docElement, dtdName)) {
            return;
        }
        int idx = this.dtdModel.indexOf(dtdName);
        this.dtdModel.removeElement(dtdName);
        if (idx >= this.dtdModel.size()) {
            idx = this.dtdModel.size() - 1;
        }
        if (idx < 0) {
            return;
        }
        this.dtdList.setSelectedIndex(idx);
        this.dtdList.requestFocusInWindow();
    }

    private void actionDtdUpdate() {
        String documentName = (String)this.documentBox.getSelectedItem();
        String dtdName = (String)this.dtdList.getSelectedValue();
        if (documentName == null || dtdName == null) {
            return;
        }
        XmlModelDtd model = this.xmlDoc.getDtdModel(documentName, dtdName);
        if (model == null) {
            return;
        }
        GUIXmlDtdElementDialog dlg = new GUIXmlDtdElementDialog(this.appObject, documentName, model);
        if (dlg.getModel() == null) {
            return;
        }
        if (!this.xmlDoc.updateDtd(documentName, dtdName, dlg.getModel())) {
            return;
        }
        int idx = this.dtdList.getSelectedIndex();
        this.dtdModel.set(idx, dlg.getModel().getName());
        this.dtdList.setSelectedIndex(idx);
        this.dtdList.requestFocusInWindow();
    }

    private void actionDtdUpDown(boolean upFlag) {
        int eIdx;
        int sIdx;
        int idx = this.dtdList.getSelectedIndex();
        if (upFlag) {
            if (idx <= 0) {
                return;
            }
            sIdx = idx - 1;
            eIdx = idx;
        } else {
            if (idx >= this.dtdModel.size() - 1) {
                return;
            }
            sIdx = idx;
            eIdx = idx + 1;
        }
        String elm1 = (String)this.dtdModel.get(sIdx);
        String elm2 = (String)this.dtdModel.get(eIdx);
        String documentName = (String)this.documentBox.getSelectedItem();
        if (!this.xmlDoc.dtdUpDown(documentName, elm1, elm2)) {
            return;
        }
        this.dtdModel.set(sIdx, elm2);
        this.dtdModel.set(eIdx, elm1);
        if (!upFlag) {
            sIdx = eIdx;
        }
        this.dtdList.setSelectedIndex(sIdx);
        this.dtdList.requestFocusInWindow();
    }

    public void windowClosing(WindowEvent e) {
        this.transform();
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

