/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.model;

import jp.sourceforge.jhime.pectin.model.XmlModel;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlModelTemplate
extends XmlModel {
    private String template;

    public XmlModelTemplate(String name, String text) {
        this.setName(name);
        this.setType("template");
        this.template = text;
    }

    public XmlModelTemplate(Element docNode, Element element) {
        super(docNode, element);
    }

    public Element createElement(Document doc) {
        Element templateElement = doc.createElement("template");
        templateElement.setAttribute("name", this.getName());
        CDATASection cdata = doc.createCDATASection(this.template);
        templateElement.appendChild(cdata);
        return templateElement;
    }

    public String getString() {
        int i;
        Element documentNode = this.getDocumentNode();
        if (documentNode == null) {
            return null;
        }
        NodeList nodeList = documentNode.getElementsByTagName("template");
        Node node = null;
        for (i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) {
                node = null;
                continue;
            }
            String name = ((Element)node).getAttribute("name");
            if (this.getName().equals(name)) break;
        }
        if (node == null) {
            return null;
        }
        nodeList = node.getChildNodes();
        for (i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 4) continue;
            return node.getNodeValue();
        }
        return null;
    }
}

