/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins.css;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.plugins.PluginGUICSSAttributePanel;
import jp.sourceforge.jhime.pectin.plugins.css.CheckBoxItemListener;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUICSSLengthComponent;

public class PluginGUIDisplayPanel
extends PluginGUICSSAttributePanel {
    private static final String[] DISPLAY = new String[]{"inline", "block", "list-item", "run-in", "compact", "marker", "table", "inline-table", "table-row-group", "table-header-group", "table-footer-group", "table-row", "table-column-group", "table-column", "table-cell", "table-caption", "none", "inherit"};
    private static final String[] POSITION = new String[]{"static", "relative", "absolute", "fixed", "inherit"};
    private static final String[] POSITION_P = new String[]{"auto", "\u5024\u6307\u5b9a", "inherit"};
    private static final String[] FLOAT = new String[]{"none", "left", "right", "inherit"};
    private static final String[] CLEAR = new String[]{"none", "left", "right", "both", "inherit"};
    private static final String[] ZINDEX = new String[]{"auto", "\u5024\u6307\u5b9a", "inherit"};
    private JCheckBox displayBtn = new JCheckBox("\u30dc\u30c3\u30af\u30b9\u751f\u6210\u898f\u5247");
    private JCheckBox positionBtn = new JCheckBox("\u30dc\u30c3\u30af\u30b9\u914d\u7f6e\u898f\u5247");
    private JCheckBox[] offsetBtn = new JCheckBox[4];
    private JCheckBox floatBtn = new JCheckBox("\u30d5\u30ed\u30fc\u30c8\u6307\u5b9a");
    private JCheckBox clearBtn = new JCheckBox("\u30d5\u30ed\u30fc\u30c8\u89e3\u9664");
    private JCheckBox zindexBtn = new JCheckBox("\u30b9\u30bf\u30c3\u30af\u30ec\u30d9\u30eb");
    private JComboBox displayBox = new JComboBox<String>(DISPLAY);
    private JComboBox positionBox = new JComboBox<String>(POSITION);
    private JComboBox[] offsetBox = new JComboBox[4];
    private PluginGUICSSLengthComponent[] offsetComp = new PluginGUICSSLengthComponent[4];
    private JComboBox floatBox = new JComboBox<String>(FLOAT);
    private JComboBox clearBox = new JComboBox<String>(CLEAR);
    private JComboBox zindexBox = new JComboBox<String>(ZINDEX);
    private JTextField zindexField = new JTextField(10);

    public PluginGUIDisplayPanel() {
        this.initComponent();
        this.setLayout(new BorderLayout(5, 5));
        JComponent cPan = this.createContentsPanel();
        this.add((Component)cPan, "Center");
    }

    private void initComponent() {
        this.displayBtn.addItemListener(new CheckBoxItemListener(this.displayBox));
        this.positionBtn.addItemListener(new CheckBoxItemListener(this.positionBox));
        this.floatBtn.addItemListener(new CheckBoxItemListener(this.floatBox));
        this.clearBtn.addItemListener(new CheckBoxItemListener(this.clearBox));
        for (int i = 0; i < 4; ++i) {
            String label = null;
            switch (i) {
                case 0: {
                    label = "\u4e0a\u30aa\u30d5\u30bb\u30c3\u30c8";
                    break;
                }
                case 1: {
                    label = "\u4e0b\u30aa\u30d5\u30bb\u30c3\u30c8";
                    break;
                }
                case 2: {
                    label = "\u5de6\u30aa\u30d5\u30bb\u30c3\u30c8";
                    break;
                }
                case 3: {
                    label = "\u53f3\u30aa\u30d5\u30bb\u30c3\u30c8";
                }
            }
            this.offsetBtn[i] = new JCheckBox(label);
            this.offsetBox[i] = new JComboBox<String>(POSITION_P);
            this.offsetComp[i] = new PluginGUICSSLengthComponent("LengthPercent");
            this.offsetBtn[i].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    PluginGUIDisplayPanel.this.offsetBtnSelected((JCheckBox)e.getSource());
                }
            });
            this.offsetBox[i].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    PluginGUIDisplayPanel.this.offsetBoxSelected((JComboBox)e.getSource());
                }
            });
        }
        this.zindexBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PluginGUIDisplayPanel.this.zindexBtnSelected();
            }
        });
        this.zindexBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PluginGUIDisplayPanel.this.zindexBoxSelected();
            }
        });
    }

    private JComponent createContentsPanel() {
        GUIGridPanel gridPanel = new GUIGridPanel();
        gridPanel.gridLayoutComponent(this.displayBtn, 0, 0);
        gridPanel.gridLayoutComponent(this.displayBox, 1, 0, false);
        gridPanel.gridLayoutComponent(this.positionBtn, 0, 1);
        gridPanel.gridLayoutComponent(this.positionBox, 1, 1, false);
        for (int i = 0; i < 4; ++i) {
            int y = i + 2;
            gridPanel.gridLayoutComponent(this.createGapPanel(this.offsetBtn[i]), 0, y);
            gridPanel.gridLayoutComponent(this.createGapPanel(this.offsetBox[i]), 1, y);
            this.offsetBox[i].setEnabled(false);
            gridPanel.gridLayoutComponent(this.offsetComp[i], 2, y, false);
        }
        gridPanel.gridLayoutComponent(this.floatBtn, 0, 6);
        gridPanel.gridLayoutComponent(this.floatBox, 1, 6, false);
        gridPanel.gridLayoutComponent(this.clearBtn, 0, 7);
        gridPanel.gridLayoutComponent(this.clearBox, 1, 7, false);
        gridPanel.gridLayoutComponent(this.createGapPanel(this.zindexBtn), 0, 8);
        gridPanel.gridLayoutComponent(this.createGapPanel(this.zindexBox), 1, 8);
        this.zindexBox.setEnabled(false);
        gridPanel.gridLayoutComponent(this.zindexField, 2, 8, false);
        return gridPanel;
    }

    private JPanel createGapPanel(Component comp) {
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        pane.add(comp, "Center");
        return pane;
    }

    private void offsetBtnSelected(JCheckBox btn) {
        int idx = -1;
        for (int i = 0; i < 4; ++i) {
            if (!btn.equals(this.offsetBtn[i])) continue;
            idx = i;
            break;
        }
        if (btn.isSelected()) {
            this.offsetBox[idx].setEnabled(true);
            if (((String)this.offsetBox[idx].getSelectedItem()).equals("\u5024\u6307\u5b9a")) {
                this.offsetComp[idx].setEnabled(true);
            }
        } else {
            this.offsetBox[idx].setEnabled(false);
            this.offsetComp[idx].setEnabled(false);
        }
    }

    private void offsetBoxSelected(JComboBox box) {
        String str;
        int idx = -1;
        for (int i = 0; i < 4; ++i) {
            if (!box.equals(this.offsetBox[i])) continue;
            idx = i;
            break;
        }
        if ((str = (String)box.getSelectedItem()).equals("\u5024\u6307\u5b9a")) {
            this.offsetComp[idx].setEnabled(true);
        } else {
            this.offsetComp[idx].setEnabled(false);
        }
    }

    private void zindexBtnSelected() {
        if (this.zindexBtn.isSelected()) {
            this.zindexBox.setEnabled(true);
            if (((String)this.zindexBox.getSelectedItem()).equals("\u5024\u6307\u5b9a")) {
                this.zindexField.setEnabled(true);
            }
        } else {
            this.zindexBox.setEnabled(false);
            this.zindexField.setEnabled(false);
        }
    }

    private void zindexBoxSelected() {
        String str = (String)this.zindexBox.getSelectedItem();
        if (str.equals("\u5024\u6307\u5b9a")) {
            this.zindexField.setEnabled(true);
        } else {
            this.zindexField.setEnabled(false);
        }
    }

    private String boxString(String name, JComboBox box) {
        StringBuffer buff = new StringBuffer(name);
        buff.append(" " + (String)box.getSelectedItem());
        buff.append(";\n");
        return buff.toString();
    }

    private String offsetString(int idx, String name) {
        StringBuffer buff = new StringBuffer(name);
        String str = (String)this.offsetBox[idx].getSelectedItem();
        if (str.equals("\u5024\u6307\u5b9a")) {
            buff.append(" " + this.offsetComp[idx].getString());
        } else {
            buff.append(" " + str);
        }
        buff.append(";\n");
        return buff.toString();
    }

    public String getString() {
        StringBuffer buff = new StringBuffer();
        if (this.displayBtn.isSelected()) {
            buff.append(this.boxString("\tdisplay:", this.displayBox));
        }
        if (this.positionBtn.isSelected()) {
            buff.append(this.boxString("\tposition:", this.positionBox));
        }
        for (int i = 0; i < 4; ++i) {
            String str = null;
            switch (i) {
                case 0: {
                    str = "\ttop:";
                    break;
                }
                case 1: {
                    str = "\tbottom:";
                    break;
                }
                case 2: {
                    str = "\tleft:";
                    break;
                }
                case 3: {
                    str = "\tright:";
                }
            }
            if (!this.offsetBtn[i].isSelected()) continue;
            buff.append(this.offsetString(i, str));
        }
        if (this.floatBtn.isSelected()) {
            buff.append(this.boxString("\tfloat:", this.floatBox));
        }
        if (this.clearBtn.isSelected()) {
            buff.append(this.boxString("\tclear:", this.clearBox));
        }
        if (this.zindexBtn.isSelected()) {
            buff.append("\tz-index:");
            String str = (String)this.zindexBox.getSelectedItem();
            if (str.equals("\u5024\u6307\u5b9a")) {
                buff.append(" " + this.zindexField.getText().trim());
            } else {
                buff.append(" " + str);
            }
            buff.append(";\n");
        }
        return buff.toString();
    }

    public String toString() {
        return "\u30dc\u30c3\u30af\u30b9\u306e\u914d\u7f6e";
    }
}

