#!/bin/sh
# GPL_3+
cat << 'EEE' > /dev/null
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

cat << 'EEE' > /dev/null
#SH_doc
cat << 'EEE'
title=AMN section=1
repnl=\040	//dfl is repnl =(noset). change nl to \s for latin-langages
@name amn
@_brief man maker
@_syno amn [-hHV137] [-D key=str] [file|stdin]
@tl;dr
	make man:

	@(code)--
	~$ amn <<- EEE
	@name hw - hello, world
	@synopsis hw [-hH] file...
	@description disp 'hello', '_world'
	EEE
	
	~$ amn <<- EEE |man /dev/stdin 
	title=xyz section=3
	@name hw - hello, world
	@_syno
	#include "hw.h"
	int hw(int ac, char** av);
	@_desc use c-func parser in @synopsis if section is '_2' or '3'
	EEE
	@()--

	read from '_stdin' if ag1 '_file' isnt exist
	@(code)
	~$ anm src.txt
	~$ anm <src.txt
	~$ cat src.txt | anm | man /dev/stdin
	~$ cat src.txt | anm -D title=abc 
	@()
@_opt
	@(list_o)
	-h, -H, -V:	print usage, version info
	-1, -3, -7:	output sample command
	-D key=str: overwrite default settings
	@()
	opt '-D' '_key' are the below. val '_str' \[\abfnrtv], \ooo, \xhh is converted.
	null-char \0 causes undefined results. 
	@(pre)@
	'  mk   ': tag marker. used for charesc too. dfl=@'@@@'
	'  hlop ': bold/underline highlight block open. dfl=\047 (single quote)
	'  hlcl ': close. dfl=\047
	'  ulstr': underline flag. dfl=@'_@'. @'_str@' makes underline, '_str'
	'  tagop': tag open. @@(pre) etc. dfl=@'(@'
	'  tagcl': close. dfl=@')@'
	'  lbdlm': works only in @(list), -a@: info..., etc. dfl=@':@'
	'  brstr': break marker. dfl=@'--@'. --(\n) works as <br>.
	'  repnl': replace nl. dfl=  (del). latin-type lang may need \s==\040
	'  zwsp ': insert zwsp to all chars if set 1. dfl=0 
	         man misses locale if read file from local.
	           ~$ man abc.1		#>> valil, locale=ja_JP etc
	           ~$ cp /usr/share/man/ja/man1/abc.1.gz ./
	           ~$ man ./abc.1.gz		#>> broken format locale=C ?
	         man preprocesser causes this problem. abc.1.gz is valid.
	         zwsp temporary improves broken format at editing/making doc.
	         dont use zwsp to release doc. (h|e|l|l|o ...redundant)
	         you can resolve this probrem using groff delective '.mso'.
	           ~$ (echo .mso ja.tmac; cat ./abc.1) | man -l -
	         `-l -` means ` read local + stdin(-)`. see 'man(1), groff(7)'
	@()
	--
	next keys change manpage setting
	@(pre)@
	'  title'   : manpage title. dfl=no_title
	'  section' : man section. dfl=1
	'  footer'  : dfl isnt set
	'  footer_l': dfl isnt set
	'  header'  : dfl isnt set
	@()
@_desc
	amn converts markup text to manpages. basic rule is close to html.
	@(pre)@
	  - tab, newline, emptylines are ignored
	  - spaces are merged to 1 char
	@()
	a typical example is the below:
	@(code)@
	---
	  title=hello section=1
	  header=GNU  repnl=\040
	  @name hw
	  @_brief hello, world
	  @_syno hw [-h|-H] file ...
	  @options option list is --
	    @(list)
	    -h: escape quote, colon.. @'help@' @: etc
	    '-v': version
	    @() 
	  @_see ls(1), 'pwd(1)' '_puts(3)'
	---
	@()--
	
	amn accepts the following syntax:
	@(list)--
	'_key=str': from BOF to 1st @XXX is defination block. --
		- grep only XX=YY str. ignore others --
		- dont quote. mk=@'@@@' is bad. title=a\101c is valid. --
		- '_str' is sapareted with sp/tab. use \040 if needs space \s. --
		- '_str' is converted with printf('_str'). --
		- option -D'_key=str' overwrites defination block settings.	--
	'_@XXX': header, '@name' etc. make uppercase. must be BOL.
		XXX is converted with printf('XXX'). @conforming\040to etc.
	@_XXX: same as @XXX, but some words are reserved to alias/macros. --
		'  @_syno '@: @SYNOPSIS		--
		'  @_opt  '@: @OPTIONS		--
		'  @_desc '@: @DESCRIPTION	--
		'  @_eg   '@: @EXSAMPLE		--
		'  @_ver  '@: @VERSION		--
		'  @_see  '@: @SEE_ALSO		--
		'  @_brief'@: add description to @NAME	--
	'@(pre)...@()': <pre>..</pre>. highlighting, charesc, @@(raw) works
	'@(code)..@()': similar to @(pre) but any syntax/tag doesnt work

	'@(list)..@()': list. splits label and info with colon @'@:@'.
		if use colon char in infostr, use '@@:' . nl, --(\n) cant use in label. --
		''eg) it@@'s a 'la'@'_bel': m'sg' @@: --(\n)@(raw).RS@()  ..valid''	--

	'@(list_o)..@()': list for command options. highlight label automatically --
		''eg) -n, --num[=n]: set num >>>'' '-n', '--num'[='_n'] set num

	'@(raw)...@()': pass rawstr to groff. no needs to set \n at the block end. --
		''eg) abc@(raw).SH new_section@()123''

	'@()(\n)': works as block end if exists in the EOL. if block isnt open or
		not EOL, ignored/skipped. --
		''eg) abc@()123 >>> abc123, do nothing''

	@'str@'		: bold 'str'. keep inner sp/tabs. use '@@@', @@@@' to write '@', @@'
	@'_str@'	: underline '_str'. 1 char @'_@' works as bold
	@'@'str@'@'	: single quote x2, no highlighting. you dont need esc quote. --
		''eg) '@' 'abc' esc @@' @@@@ works too'@''' >>'' 'abc' esc ' @@ works too''
	'@@@''	: single quote. you can also use groff esc '@(raw) \(aa @()'
	'@@@@'	: atmark. you can also use groff '@(raw) @ @()'
	'@@:'	: colon. maybe uses only for @(list) or @(list_o). '@(raw) : @()'
	'--(\n)': 2-hyphen + nl. <br>. --(\s)(\n) doesnt work. 'gnu_man' seems
		to merge blanklines at output, so you cant use multi-blankslines. --
	@()

	if @@(pre,code,list,list_o) end with @@(...)\n, deletes \n char. --
	if they end with @@(...)--\n, add a empty line before the block. --
	if @@(pre,code) block end with @@(...)@@\n, remove the leading tabs as
	shell heredoc '' '<<-' '' syntax. --
	if they end with @@(...)--@\n, add a empty lines and remove the leading tabs.	--
	if @@() end with @@()--\n or @@()--@@\n, add a empty line after block.	--
	if @@() end with @@()@@\n, work the same as @@()\n. (ignores end @@). --
	summary example is the below:

	@(code)--@
	aaa              aaa          |  aaa              aaa
	@(code)          \t   \s 000  |  @(code)@            000
	\t   \s 000  >>  \s \t   111  |          000  >>          111
	\s \t   111      zzz          |          111
	@()\n                         |  @()--            zzz
	zzz                           |  zzz
	- - - - - - - - - - - - - - - + - - - - - - - - - - - - - - -
	aaa              aaa          |  aaa              aaa
	@(code)--                     |  @(code)--@ 
	        000  >>          000  |          000  >>     000
	        111              111  |          111              111
	@()@             zzz          |  @()--@ 
	zzz                           |  zzz              zzz
	@()--@

	the @(list_o) label and @SYNOPSIS block are highlighted automatically.
	@@(list_o) label is assumed to be command options -a, --all[=str] etc. --
	@SYNOPSIS parser is changed by '-Dsection'='_num' setting
	@(list)
	section 1:	detect command format, "cmd [-a ag] file" etc. use --(\n)
		to split long command description@: --
		'    'eg) cmd [-a ag] --(\n)(\t) [-b] file
	section 2/3: detect C-func decreations "int myf(int num);" etc. use 
		simple (\n) to split long string. (allow --(\n) too)--
		this block works as @@(pre) block with C-func highlighting.
	@()--
	the parsers are heuristic but work for the most part.
	
@_eg
	@(code)--@
		--
		@name hw - hello, world
		@_desc disp --
		  @(raw)...@() 
		  'messages' ...
		
		--
		mk=#_@ brstr=???
		#_@name hw - hello, world
		#_@_desc disp ???
		  #_@(raw)...#_@() 
		  'messages' ...
	@()--@

@conforming_to	posix-sh, POSIX.1-2001+
@notes
	@(code)
if you needs to html converter, use mandoc.
 ~$ cat amn.1 | mandoc -Thtml > amn.1.html
 ~$ cat amn.1 | mandoc -Tpdf > amn.1.pdf

gnu_man has self html parser (man -H) but not so good 
 ~$ cat amn.1 |man -Hcat /dev/stdin > amn.1.html

if you needs plaintext, man or mandoc.
 ~$ mandoc -Tutf8 <amn.1 | sed -e "s/.`printf '\\b'`//g"> amn.1.txt
 ~$ amn -7|amn -Dzwsp=1 |
		man -Tutf8 /dev/stdin|sed -e "s/.`printf '\\b'`//g"> amn.7.txt
 (-Dzwsp=1 + man makes terminal 80x24 suitable text in multibyte locale)
	@()
@copyright
	Copyright (C) 2021 Momi-g --
	License GPLv3+ <https://gnu.org/licenses/gpl.html>.

@_see
	'man-pages(7)', 'groff_man(7)', 'groff(7)', 'mandoc(1)'	--
	https://wiki.archlinux.org/title/Man_page (strongly recommend)	--
	--
	...recommend to read man-pages(7)
#SH_docE
EEE
