// ------------------------------------------------
// File : simple.cpp
// Date: 4-apr-2002
// Author: giles
// Desc: 
//		Simple tray icon interface to PeerCast, mostly win32 related stuff.
//		
// (c) 2002 peercast.org
// ------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------

#include <windows.h>

#include "stdafx.h"
#include "resource.h"
#include "gui.h"
#include "channel.h"
#include "servent.h"
#include "servmgr.h"
#include "win32/wsys.h"
#include "peercast.h"
#include "simple.h"

#define MAX_LOADSTRING 100

#define PLAY_CMD 7000
#define RELAY_CMD 8000
#define INFO_CMD 9000
#define URL_CMD 10000

extern "C"
{
	void loadIcons(HINSTANCE hInstance, HWND hWnd);
};


// PeerCast globals

static int currNotify=0;
String iniFileName;
HWND guiWnd;
HWND mainWnd;
HMENU trayMenu,ltrayMenu;
bool showGUI=true;
bool allowMulti=false;
bool killMe=false;
bool allowTrayMenu=true;
int		seenNewVersionTime=0;
HICON icon1,icon2;
ChanInfo chanInfo;
bool chanInfoIsRelayed;
GnuID	lastPlayID;

// ---------------------------------
Sys * APICALL MyPeercastInst::createSys()
{
	return new WSys(mainWnd);
}
// ---------------------------------
const char * APICALL MyPeercastApp ::getIniFilename()
{
	return iniFileName.cstr();
}

// ---------------------------------
const char *APICALL MyPeercastApp ::getClientTypeOS() 
{
	return PCX_OS_WIN32;
}



class NOTIFYICONDATA2
{
public:
        DWORD cbSize; // DWORD
        HWND hWnd; // HWND
        UINT uID; // UINT
        UINT uFlags; // UINT
        UINT uCallbackMessage; // UINT
        HICON hIcon; // HICON
        char szTip[128]; // char[128]
        DWORD dwState; // DWORD
        DWORD dwStateMask; // DWORD
        char szInfo[256]; // char[256]
        UINT uTimeoutOrVersion; // UINT
        char szInfoTitle[64]; // char[64]
        DWORD dwInfoFlags; // DWORD
        //GUID guidItem; > IE 6
};

NOTIFYICONDATA2 trayIcon;


// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];								// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];								// The title bar text

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	ChanInfoProc(HWND, UINT, WPARAM, LPARAM);

void setTrayIcon(int type, const char *,const char *,bool);
void flipNotifyPopup(int id, ServMgr::NOTIFY_TYPE nt);


HWND chWnd=NULL;

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{

	String tmpURL;
	tmpURL.clear();
	char *localURL=NULL;

	iniFileName.set("peercast-jp.ini"); //JP-Patch
	//iniFileName.set("peercast.ini");

	// off by default now
	showGUI = false;

	if (strlen(lpCmdLine) > 0)
	{
		char *p;
		if ((p = strstr(lpCmdLine,"-inifile"))!=NULL) 
			iniFileName.setFromString(p+8);

		if (strstr(lpCmdLine,"-zen")) 
			showGUI = false;

		if (strstr(lpCmdLine,"-multi")) 
			allowMulti = true;

		if (strstr(lpCmdLine,"-kill")) 
			killMe = true;

		if ((p = strstr(lpCmdLine,"-url"))!=NULL)
			tmpURL.setFromString(p+4);
	}
	
	if (strstr(tmpURL.cstr(),"peercast://"))
	{
		localURL = tmpURL.cstr()+11;
		showGUI = false;
	}


	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
	//LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	//LoadString(hInstance, IDC_APP_TITLE, szWindowClass, MAX_LOADSTRING);

	strcpy(szTitle,"PeerCast");
	strcpy(szWindowClass,"PeerCast");


	if (!allowMulti)
	{
		HANDLE mutex = CreateMutex(NULL,TRUE,szWindowClass);
		
		if (GetLastError() == ERROR_ALREADY_EXISTS)
		{
			HWND oldWin = FindWindow(szWindowClass,NULL);
			if (oldWin)
			{
				if (killMe)
				{
					SendMessage(oldWin,WM_DESTROY,0,0);
					return 0;
				}

				if (localURL)
				{
					if (strncmp(localURL,"pls/",4)==0)
					{
						int len = strlen(localURL+4);
						localURL[4+len] = 0;

						COPYDATASTRUCT copy;
						copy.dwData = WM_PLAYCHANNEL;
						copy.cbData = len+1;			// plus null term
						copy.lpData = localURL+4;
						SendMessage(oldWin,WM_COPYDATA,NULL,(LPARAM)&copy);
					}else{

						LRESULT r = SendMessage(oldWin,WM_GETPORTNUMBER,0,0);
						char cmd[512];
						sprintf(cmd,"http://localhost:%d/%s",r,localURL);
						ShellExecute(NULL, NULL, cmd, NULL, NULL, SW_SHOWNORMAL);
					}
				}else{
					if (showGUI)
						SendMessage(oldWin,WM_SHOWGUI,0,0);
				}
			}
			return 0;
		}
	}

	if (killMe)
		return 0;
	
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
		return FALSE;

	peercastInst = new MyPeercastInst();
	peercastApp = new MyPeercastApp();

	peercastInst->init();


	if (localURL)
	{
		if (strncmp(localURL,"pls/",4)==0)
		{
			GnuID id;
			id.fromStr(localURL+4);
			chanMgr->playChannel(id,false);
		}else
			sys->callLocalURL(localURL,servMgr->serverHost.port);
	}


	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_SIMPLE);


	// setup menu notifes
	int mask = peercastInst->getNotifyMask();
	if (mask & ServMgr::NT_PEERCAST)
		CheckMenuItem(trayMenu,ID_POPUP_SHOWMESSAGES_PEERCAST,MF_CHECKED|MF_BYCOMMAND);
	if (mask & ServMgr::NT_BROADCASTERS)
		CheckMenuItem(trayMenu,ID_POPUP_SHOWMESSAGES_BROADCASTERS,MF_CHECKED|MF_BYCOMMAND);
	if (mask & ServMgr::NT_TRACKINFO)
		CheckMenuItem(trayMenu,ID_POPUP_SHOWMESSAGES_TRACKINFO,MF_CHECKED|MF_BYCOMMAND);



	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

    Shell_NotifyIcon(NIM_DELETE, (NOTIFYICONDATA*)&trayIcon);
	servMgr->saveSettings(iniFileName.cstr());


	return msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_SIMPLE);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCSTR)IDC_SIMPLE;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);

}

//-----------------------------
void loadIcons(HINSTANCE hInstance, HWND hWnd)
{
	icon1 = LoadIcon(hInstance, (LPCTSTR)IDI_SMALL);
	icon2 = LoadIcon(hInstance, (LPCTSTR)IDI_SMALL2);

    trayIcon.cbSize = sizeof(trayIcon);
    trayIcon.hWnd = hWnd;
    trayIcon.uID = 100;
    trayIcon.uFlags = NIF_MESSAGE + NIF_ICON + NIF_TIP;
    trayIcon.uCallbackMessage = WM_TRAYICON;
    trayIcon.hIcon = icon1;
    strcpy(trayIcon.szTip, "PeerCast");

    Shell_NotifyIcon(NIM_ADD, (NOTIFYICONDATA*)&trayIcon);

    //ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);

	trayMenu = LoadMenu(hInstance,MAKEINTRESOURCE(IDR_TRAYMENU));
	ltrayMenu = LoadMenu(hInstance,MAKEINTRESOURCE(IDR_LTRAYMENU));


}

//-----------------------------
//
//   FUNCTION: InitInstance(HANDLE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND hWnd;

	hInst = hInstance; // Store instance handle in our global variable

	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
	  CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

	if (!hWnd)
	{
	  return FALSE;
	}

	mainWnd = hWnd;

	loadIcons(hInstance,hWnd);

	return TRUE;
}
//-----------------------------
static String trackTitle;

//-----------------------------
void channelPopup(const char *title, const char *msg)
{
	String both;

	both.append(msg);
	both.append(" (");
	both.append(title);
	both.append(")");

	trayIcon.uFlags = NIF_ICON|NIF_TIP;
	strncpy(trayIcon.szTip, both.cstr(),sizeof(trayIcon.szTip)-1);
	trayIcon.szTip[sizeof(trayIcon.szTip)-1]=0;

	if (ServMgr::NT_TRACKINFO & peercastInst->getNotifyMask())
	{
		trayIcon.uFlags |= 16;
		trayIcon.uTimeoutOrVersion = 10000;
		strcpy(trayIcon.szInfo,msg);
		strcpy(trayIcon.szInfoTitle,title);
	}

	Shell_NotifyIcon(NIM_MODIFY, (NOTIFYICONDATA*)&trayIcon);
}
//-----------------------------
void clearChannelPopup()
{
	trayIcon.uFlags = NIF_ICON|16;
	trayIcon.uTimeoutOrVersion = 10000;
	strcpy(trayIcon.szInfo,"");
	strcpy(trayIcon.szInfoTitle,"");
	Shell_NotifyIcon(NIM_MODIFY, (NOTIFYICONDATA*)&trayIcon);
}

//-----------------------------
void	APICALL MyPeercastApp::channelStart(ChanInfo *info)
{
	lastPlayID = info->id;
	clearChannelPopup();
}
//-----------------------------
void	APICALL MyPeercastApp::channelStop(ChanInfo *info)
{
	if (info->id.isSame(lastPlayID))
	{
		lastPlayID.clear();
		clearChannelPopup();
	}
}
//-----------------------------
void	APICALL MyPeercastApp::channelUpdate(ChanInfo *info)
{
	if (info && info->id.isSame(lastPlayID))
	{
		String tmp;
		tmp.append(info->track.artist);
		tmp.append(" ");
		tmp.append(info->track.title);

		if (!tmp.isSame(trackTitle))
		{			
			trackTitle = tmp;
			String wk; //JP-Patch
			wk = tmp; //JP-Patch
			wk.convertTo(String::T_KANJI); //JP-Patch
			clearChannelPopup();
			channelPopup(info->name.cstr(),wk.cstr()); //JP-Patch
		}

	}
}
//-----------------------------
void	APICALL MyPeercastApp::notifyMessage(ServMgr::NOTIFY_TYPE type, const char *msg)
{
	currNotify = type;

	if (type == ServMgr::NT_UPGRADE)
	{
	    trayIcon.uFlags = NIF_ICON;
	    trayIcon.hIcon = icon2;
	}else{
	    trayIcon.uFlags = NIF_ICON;
	    trayIcon.hIcon = icon1;
	}

	const char *title="";

	switch(type)
	{
		case ServMgr::NT_UPGRADE:
			title = "Upgrade alert";
			break;
		case ServMgr::NT_BROADCASTERS:
			title = "Message from broadcaster:";
			break;
		case ServMgr::NT_PEERCAST:
			title = "Message from PeerCast:";
			break;

	}

	if (type & peercastInst->getNotifyMask())
	{
		trayIcon.uFlags |= 16;
        trayIcon.uTimeoutOrVersion = 10000;
        strcpy(trayIcon.szInfo,msg);
		strcpy(trayIcon.szInfoTitle,title);
	    Shell_NotifyIcon(NIM_MODIFY, (NOTIFYICONDATA*)&trayIcon);
	}
}
//-----------------------------

// createGUI()
//
void createGUI(HWND hWnd)
{
	if (!guiWnd)
		guiWnd = CreateDialog(hInst, (LPCTSTR)IDD_MAINWINDOW, hWnd, (DLGPROC)GUIProc);
	ShowWindow(guiWnd,SW_SHOWNORMAL);
}


// 
// addRelayedChannelsMenu(HMENU m)
// 
//
void addRelayedChannelsMenu(HMENU cm)
{
	int cnt = GetMenuItemCount(cm);
	for(int i=0; i<cnt-3; i++)
		DeleteMenu(cm,0,MF_BYPOSITION);

	for(i=0; i<ChanMgr::MAX_CHANNELS; i++)
	{
		Channel *c = &chanMgr->channels[i];
		if (c->isActive())
		{
			char str[128],name[64];
			strncpy(name,c->info.name,32);
			name[32]=0;
			if (strlen(c->info.name) > 32)
				strcat(name,"...");


			sprintf(str,"%s  (%d kb/s %s)",name,c->info.bitrate,ChanInfo::getTypeStr(c->info.contentType));
			//InsertMenu(cm,0,MF_BYPOSITION,RELAY_CMD+i,str);
		}
	}
}

typedef int (*COMPARE_FUNC)(const void *,const void *);

static int compareHitLists(ChanHitList **c2, ChanHitList **c1)
{
	return stricmp(c1[0]->info.name.cstr(),c2[0]->info.name.cstr());
}

// 
// addAllChannelsMenu(HMENU m)
// 
//
void addAllChannelsMenu(HMENU cm)
{
	int cnt = GetMenuItemCount(cm);
	for(int i=0; i<cnt-3; i++)
		DeleteMenu(cm,0,MF_BYPOSITION);

	int numActive=0;


	// sort channels into alphabetical order
	ChanHitList *lists[ChanMgr::MAX_HITLISTS];

	int numLists=0;

	for(i=0; i<ChanMgr::MAX_HITLISTS; i++)
	if (chanMgr->hitlists[i].isUsed())
		lists[numLists++]=&chanMgr->hitlists[i];
		
	qsort(lists,numLists,sizeof(ChanHitList*),(COMPARE_FUNC)compareHitLists);


	// add channels to menu
	for(i=0; i<numLists; i++)
	{
		ChanHitList *chl = lists[i];
		{
			char str[128],name[64];
			strncpy(name,chl->info.name,32);
			name[32]=0;
			if (strlen(chl->info.name) > 32)
				strcat(name,"...");

			sprintf(str,"%s  (%d kb/s %s)",name,chl->info.bitrate,ChanInfo::getTypeStr(chl->info.contentType));

			HMENU opMenu = CreatePopupMenu();
			InsertMenu(opMenu,0,MF_BYPOSITION,INFO_CMD+chl->index,""); //JP-EX
			if (chl->info.url.isValidURL())
				InsertMenu(opMenu,0,MF_BYPOSITION,URL_CMD+chl->index,""); //JP-EX
			InsertMenu(opMenu,0,MF_BYPOSITION,RELAY_CMD+chl->index,"ڰ"); //JP-EX
			InsertMenu(opMenu,0,MF_BYPOSITION,PLAY_CMD+chl->index,"Đ"); //JP-EX


			UINT fl = MF_BYPOSITION|MF_POPUP;
			Channel *ch = chanMgr->findChannelByID(chl->info.id);
			if (ch)
				fl |= (ch->isPlaying()?MF_CHECKED:0);

			//if (!chl->isAvailable())
			//	fl |= MF_GRAYED;

			if (servMgr->channelsFilter) //JP-EX
			{
				if (!chl->isAvailable() || !chl->isNotfirewalled() || chl->info.name.isEmpty())
					fl |= MF_GRAYED;
			}	

			InsertMenu(cm,0,fl,(UINT)opMenu,str);
			numActive++;
		}
	}

	if (!numActive)
			InsertMenu(cm,0,MF_BYPOSITION,0,"<No channels>");

}


// 
// flipNotifyPopup(id, flag)
void flipNotifyPopup(int id, ServMgr::NOTIFY_TYPE nt)
{
	int mask = peercastInst->getNotifyMask();

	mask ^= nt;
	if (mask & nt)
		CheckMenuItem(trayMenu,id,MF_CHECKED|MF_BYCOMMAND);
	else
		CheckMenuItem(trayMenu,id,MF_UNCHECKED|MF_BYCOMMAND);

	peercastInst->setNotifyMask(mask);
	peercastInst->saveSettings();
}
 

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	POINT point;


	switch (message) 
	{
		case WM_SHOWGUI:
			createGUI(hWnd);
			break;


		case WM_TRAYICON:
			switch((UINT)lParam) 
			{
				case WM_LBUTTONDOWN:
					if (allowTrayMenu)
						SendMessage(hWnd,WM_SHOWMENU,2,0);
					SetForegroundWindow(hWnd);    
					break;
				case WM_RBUTTONDOWN:
					if (allowTrayMenu)
						SendMessage(hWnd,WM_SHOWMENU,1,0);
					SetForegroundWindow(hWnd);    
					break;
			}
			break;

		case WM_COPYDATA:
			{
				GnuID id;
				COPYDATASTRUCT *pc = (COPYDATASTRUCT *)lParam;
				LOG("URL request: %s",pc->lpData);
				if (pc->dwData == WM_PLAYCHANNEL)
				{
					char *arg = (char *)pc->lpData;
					id.fromStr(arg);
					servMgr->procConnectArgs(arg,id);
					chanMgr->playChannel(id,false);
				}
				//sys->callLocalURL((const char *)pc->lpData,servMgr->serverHost.port);
			}
			break;
		case WM_GETPORTNUMBER:
			{
				int port;
				port=servMgr->serverHost.port;
				LOG("PORT request: %d",port);
				ReplyMessage(port);
			}
			break;

		case WM_SHOWMENU:
			{
				SetForegroundWindow(hWnd);    
				bool skipMenu=false;

				allowTrayMenu = false;

				// check for notifications
				if (currNotify & ServMgr::NT_UPGRADE)
				{
					if (servMgr->downloadURL[0])
					{
						if ((sys->getTime()-seenNewVersionTime) > (60*60))	// notify every hour
						{
							if (MessageBox(hWnd,"A newer version of PeerCast is available, press OK to upgrade.","PeerCast",MB_OKCANCEL|MB_APPLMODAL|MB_ICONEXCLAMATION) == IDOK)
								sys->getURL(servMgr->downloadURL);

							seenNewVersionTime=sys->getTime();
							skipMenu=true;
						}
					}
				}


				if (!skipMenu)
				{
					GetCursorPos(&point);
					HMENU menu;

					switch (wParam)
					{
						case 1:
							menu = GetSubMenu(trayMenu,0);
							addAllChannelsMenu(GetSubMenu(menu,0));
							addRelayedChannelsMenu(GetSubMenu(menu,1));
							break;
						case 2:
							menu = GetSubMenu(ltrayMenu,0);
							addAllChannelsMenu(menu);
							break;
					}

					TrackPopupMenu(menu,TPM_RIGHTALIGN,point.x,point.y,0,hWnd,NULL);
					PostMessage(hWnd,WM_NULL,0,0); 
				}
				allowTrayMenu = true;
			}
			break;

		case WM_CREATE:
			if (showGUI)
				createGUI(hWnd);
			break;

		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 

			if ((wmId >= INFO_CMD) && (wmId < INFO_CMD+ChanMgr::MAX_HITLISTS))
			{
				int c = wmId - INFO_CMD;
				chanInfo = chanMgr->hitlists[c].info;
				chanInfoIsRelayed = false;
				DialogBox(hInst, (LPCTSTR)IDD_CHANINFO, hWnd, (DLGPROC)ChanInfoProc);
				return 0;
			}
			if ((wmId >= URL_CMD) && (wmId < URL_CMD+ChanMgr::MAX_HITLISTS))
			{
				int c = wmId - URL_CMD;
				if (chanMgr->hitlists[c].info.url.isValidURL())
					sys->getURL(chanMgr->hitlists[c].info.url);
				return 0;
			}
			if ((wmId >= PLAY_CMD) && (wmId < PLAY_CMD+ChanMgr::MAX_HITLISTS))
			{
				int c = wmId - PLAY_CMD;
				chanMgr->playChannel(chanMgr->hitlists[c].info.id,false);
				return 0;
			}
			if ((wmId >= RELAY_CMD) && (wmId < RELAY_CMD+ChanMgr::MAX_HITLISTS))
			{
				int c = wmId - RELAY_CMD;
				chanMgr->playChannel(chanMgr->hitlists[c].info.id,true);
				return 0;
			}

			// Parse the menu selections:
			switch (wmId)
			{
				case ID_POPUP_SHOWMESSAGES_PEERCAST:
					flipNotifyPopup(ID_POPUP_SHOWMESSAGES_PEERCAST,ServMgr::NT_PEERCAST);
					break;
				case ID_POPUP_SHOWMESSAGES_BROADCASTERS:
					flipNotifyPopup(ID_POPUP_SHOWMESSAGES_BROADCASTERS,ServMgr::NT_BROADCASTERS);
					break;
				case ID_POPUP_SHOWMESSAGES_TRACKINFO:
					flipNotifyPopup(ID_POPUP_SHOWMESSAGES_TRACKINFO,ServMgr::NT_TRACKINFO);
					break;

				case ID_POPUP_ABOUT:
				case IDM_ABOUT:
					DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
					break;
				case ID_POPUP_SHOWGUI:
				case IDM_SETTINGS_GUI:
				{
					createGUI(hWnd);
					break;
				}
				case ID_POPUP_YELLOWPAGES:
					sys->getURL("http://yp.peercast.org");
					break;

				case ID_POPUP_ADVANCED_VIEWLOG:
					sys->callLocalURL("admin?page=viewlog",servMgr->serverHost.port);
					break;
				case ID_POPUP_ADVANCED_SAVESETTINGS:
					servMgr->saveSettings(iniFileName.cstr());
					break;
				case ID_POPUP_ADVANCED_INFORMATION:
					sys->callLocalURL("admin?",servMgr->serverHost.port);
					break;
				case ID_FIND_CHANNELS:
				case ID_POPUP_ADVANCED_ALLCHANNELS:
				case ID_POPUP_ALLCHANNELS:
					sys->callLocalURL("admin?page=chans",servMgr->serverHost.port);
					break;
				case ID_POPUP_UPGRADE:
					sys->callLocalURL("admin?cmd=upgrade",servMgr->serverHost.port);
					break;
				case ID_POPUP_ADVANCED_RELAYEDCHANNELS:
				case ID_POPUP_FAVORITES_EDIT:
					sys->callLocalURL("admin?page=mychans",servMgr->serverHost.port);
					break;
				case ID_POPUP_ADVANCED_BROADCAST:
					sys->callLocalURL("admin?page=broadcast",servMgr->serverHost.port);
					break;
				case ID_POPUP_FAVORITES_PLAYALL:
					{
						Channel *clist[ChanMgr::MAX_CHANNELS];
						ChanInfo info;
						int num = chanMgr->findChannels(info,clist,ChanMgr::MAX_CHANNELS);
						if (num)
							chanMgr->playChannels(clist,num);
					}
					break;
				case ID_POPUP_SETTINGS:
					sys->callLocalURL("admin?page=settings",servMgr->serverHost.port);
					break;
				case ID_POPUP_CONNECTIONS:
					sys->callLocalURL("admin?page=connections",servMgr->serverHost.port);
					break;
				case ID_POPUP_HELP:
					sys->getURL("http://www.peercast.org/help.php");
					break;

				case ID_POPUP_BEGIN1: //JP-EX add-s
					sys->getURL("http://peercast-jp.sourceforge.jp/");
					break;
				case ID_POPUP_BEGIN2:
					sys->getURL("http://peercast.gooside.com/");
					break; //JP-EX add-e

				case ID_POPUP_EXIT_CONFIRM:
				case IDM_EXIT:
				   DestroyWindow(hWnd);
				   break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}
// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			SendDlgItemMessage(hDlg,IDC_ABOUTVER,WM_SETTEXT,0,(LONG)PCX_AGENT);
			return TRUE;

		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDOK:
				case IDCANCEL:
					EndDialog(hDlg, LOWORD(wParam));
					return TRUE;
				case IDC_BUTTON1:
					sys->getURL("http://www.peercast.org");
					EndDialog(hDlg, LOWORD(wParam));
					return TRUE;

			}
			break;
		case WM_DESTROY:
			break;
	}
    return FALSE;
}

// Mesage handler for chaninfo box
LRESULT CALLBACK ChanInfoProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			{
				char str[1024];				
				strcpy(str,chanInfo.track.artist); //JP-Patch
				strcat(str," - ");
				strcat(str,chanInfo.track.title); //JP-Patch
				String wk; //JP-Patch
				wk = str; //JP-Patch
				wk.convertTo(String::T_KANJI); //JP-Patch
				
				SendDlgItemMessage(hDlg,IDC_EDIT_NAME,WM_SETTEXT,0,(LONG)chanInfo.name.cstr());
				SendDlgItemMessage(hDlg,IDC_EDIT_PLAYING,WM_SETTEXT,0,(LONG)wk.cstr()); //JP-Patch
				SendDlgItemMessage(hDlg,IDC_EDIT_MESSAGE,WM_SETTEXT,0,(LONG)chanInfo.comment.cstr());
				SendDlgItemMessage(hDlg,IDC_EDIT_DESC,WM_SETTEXT,0,(LONG)chanInfo.desc.cstr());
				SendDlgItemMessage(hDlg,IDC_EDIT_GENRE,WM_SETTEXT,0,(LONG)chanInfo.genre.cstr());

				sprintf(str,"%d kb/s %s",chanInfo.bitrate,ChanInfo::getTypeStr(chanInfo.contentType));
				SendDlgItemMessage(hDlg,IDC_FORMAT,WM_SETTEXT,0,(LONG)str);


				ChanHitList *chl = chanMgr->findHitListByID(chanInfo.id);
				if (chl)
				{
					sprintf(str,"%d",chl->numListeners());
					SendDlgItemMessage(hDlg,IDC_EDIT_LISTENERS,WM_SETTEXT,0,(LONG)str);

					unsigned int nh = chl->numHits();
					sprintf(str,"%d/%d",nh-chl->numBusy(),nh);
					SendDlgItemMessage(hDlg,IDC_EDIT_HOSTS,WM_SETTEXT,0,(LONG)str);
				}else{
					SendDlgItemMessage(hDlg,IDC_EDIT_LISTENERS,WM_SETTEXT,0,(LONG)"-");
					SendDlgItemMessage(hDlg,IDC_EDIT_HOSTS,WM_SETTEXT,0,(LONG)"-");
				}


				if (!chanInfo.url.isValidURL())
					EnableWindow(GetDlgItem(hDlg,IDC_CONTACT),false);

				Channel *ch = chanMgr->findChannelByID(chanInfo.id);
				if (ch)
				{
					SendDlgItemMessage(hDlg,IDC_EDIT_STATUS,WM_SETTEXT,0,(LONG)ch->getStatusStr());
					SendDlgItemMessage(hDlg, IDC_KEEP,BM_SETCHECK, ch->stayConnected, 0);
				}else
				{
					SendDlgItemMessage(hDlg,IDC_EDIT_STATUS,WM_SETTEXT,0,(LONG)"OK");
					EnableWindow(GetDlgItem(hDlg,IDC_KEEP),false);
				}



				POINT point;
				RECT rect,drect;
				HWND hDsk = GetDesktopWindow();
				GetWindowRect(hDsk,&drect);
				GetWindowRect(hDlg,&rect);
				GetCursorPos(&point);

				POINT pos,size;
				size.x = rect.right-rect.left;
				size.y = rect.bottom-rect.top;

				if (point.x-drect.left < size.x)
					pos.x = point.x;
				else
					pos.x = point.x-size.x;

				if (point.y-drect.top < size.y)
					pos.y = point.y;
				else
					pos.y = point.y-size.y;

				SetWindowPos(hDlg,HWND_TOPMOST,pos.x,pos.y,size.x,size.y,0);
				chWnd = hDlg;
			}
			return TRUE;

		case WM_COMMAND:
			{
				char str[1024],idstr[64];
				chanInfo.id.toStr(idstr);

				switch (LOWORD(wParam))
				{
					case IDC_CONTACT:
					{
						sys->getURL(chanInfo.url);
						return TRUE;
					}
					case IDC_DETAILS:
					{
						sprintf(str,"admin?page=chaninfo&id=%s&relay=%d",idstr,chanInfoIsRelayed);
						sys->callLocalURL(str,servMgr->serverHost.port);
						return TRUE;
					}
					case IDC_KEEP:
					{
						Channel *ch = chanMgr->findChannelByID(chanInfo.id);
						if (ch)
							ch->stayConnected = SendDlgItemMessage(hDlg, IDC_KEEP,BM_GETCHECK, 0, 0) == BST_CHECKED;;
						return TRUE;
					}


					case IDC_PLAY:
					{
						chanMgr->playChannel(chanInfo.id,false);
						return TRUE;
					}
					//case IDC_CLOSE:
					//{
					//	EndDialog(hDlg, 0);
					//	return TRUE;
					//}

				}
			}
			break;

		case WM_CLOSE:
			EndDialog(hDlg, 0);
			break;

		case WM_ACTIVATE:
			if (LOWORD(wParam) == WA_INACTIVE)
				EndDialog(hDlg, 0);
			break;
		case WM_DESTROY:
			chWnd = NULL;
			break;


	}
    return FALSE;
}
