/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.stage.TransparencyRGBImageFilter;
import tsukuba_bunko.peko.resource.ResourceManager;

public class ImageManager {
    private static ImageManager _instance = null;
    static /* synthetic */ Class class$tsukuba_bunko$peko$canvas$stage$ImageManager;

    protected ImageManager() {
    }

    public Image getImage(String string) {
        return this.getImage(string, false);
    }

    public Image getImage(String string, boolean bl) {
        Image image = null;
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(this.getURL(string));
        }
        catch (IOException iOException) {
            Logger.debug("[canvas.stage] fail to load image :" + string, iOException);
            return null;
        }
        if (bl) {
            int n = bufferedImage.getRGB(0, 0);
            if ((n & 0xFF000000) != 0) {
                TransparencyRGBImageFilter transparencyRGBImageFilter = new TransparencyRGBImageFilter();
                transparencyRGBImageFilter.setTransparencyColor(n & 0xFFFFFF);
                FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), transparencyRGBImageFilter);
                image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
                bufferedImage.flush();
            } else {
                image = bufferedImage;
            }
        } else {
            image = bufferedImage;
        }
        return image;
    }

    public void putImage(String string, Image image) {
        if (image != null) {
            image.flush();
        }
    }

    protected URL getURL(String string) {
        ResourceManager resourceManager = ResourceManager.getInstance();
        try {
            return new URL(resourceManager.getLocationResources().getImagesDirecotryURL(), string);
        }
        catch (Exception exception) {
            Logger.error("[scene.stage] fatal error!", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageManager getInstance() {
        if (_instance == null) {
            Class clazz = class$tsukuba_bunko$peko$canvas$stage$ImageManager == null ? (class$tsukuba_bunko$peko$canvas$stage$ImageManager = ImageManager.class$("tsukuba_bunko.peko.canvas.stage.ImageManager")) : class$tsukuba_bunko$peko$canvas$stage$ImageManager;
            synchronized (clazz) {
                if (_instance == null) {
                    _instance = new ImageManager();
                }
            }
        }
        return _instance;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

