/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage;

import java.awt.Color;
import java.awt.Image;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.stage.Actor;
import tsukuba_bunko.peko.canvas.stage.AudioPlayer;
import tsukuba_bunko.peko.canvas.stage.ImageManager;
import tsukuba_bunko.peko.canvas.stage.StageCanvas;
import tsukuba_bunko.peko.resource.ColorManager;

public class Stage
implements Serializable {
    private transient StageCanvas _canvas = null;
    private AudioPlayer _audioPlayer = new AudioPlayer();
    private transient Map _actors = new HashMap();
    private HashMap _committedActors = new HashMap();
    private transient String _background = null;
    private String _committedBackground = null;
    private transient Image _backgroundImage = null;
    private transient Color _backgroundColor = null;
    private Color _committedBackgroundColor = null;
    private transient String _slide = null;
    private String _committedSlide = null;
    private transient Image _slideImage = null;

    public void enter(Actor actor) {
        this._actors.put(actor.getName(), actor);
    }

    public Actor getName(String string) {
        return (Actor)this._actors.get(string);
    }

    public Actor exit(String string) {
        Actor actor = (Actor)this._actors.remove(string);
        if (actor != null) {
            actor.disposeLooks();
        }
        return actor;
    }

    public void exitAll() {
        String[] stringArray = this._actors.keySet().toArray(new String[this._actors.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            this.exit(stringArray[i]);
        }
    }

    public Actor getActor(String string) {
        return (Actor)this._actors.get(string);
    }

    public Map getActors() {
        return this._actors;
    }

    public void setBackgroundImage(String string) {
        Image image;
        ImageManager imageManager = ImageManager.getInstance();
        if (this._backgroundImage != null && !this._background.equals(string)) {
            imageManager.putImage(this._background, this._backgroundImage);
            this._backgroundImage = null;
        }
        if ((image = imageManager.getImage(string)) != null) {
            this._backgroundImage = image;
            this._background = string;
            this._backgroundColor = null;
        } else if (image == null) {
            Logger.error("[canvas.stage] invalid background-image :" + string);
            this._backgroundColor = Color.black;
            this._background = "black";
        }
    }

    public Image getBackgroundImage() {
        return this._backgroundImage;
    }

    public void setBackgroundColor(String string) {
        Object object;
        if (this._backgroundImage != null) {
            object = ImageManager.getInstance();
            ((ImageManager)object).putImage(this._background, this._backgroundImage);
            this._backgroundImage = null;
        }
        object = ColorManager.getInstance();
        this._backgroundColor = ((ColorManager)object).getColor(string);
        this._background = string;
    }

    public Color getBackgroundColor() {
        return this._backgroundColor;
    }

    public void showSlide(String string) {
        ImageManager imageManager = ImageManager.getInstance();
        if (this._slide != null && !this._slide.equals(string)) {
            imageManager.putImage(this._slide, this._slideImage);
        }
        this._slideImage = imageManager.getImage(string);
        this._slide = string;
    }

    public void hideSlide() {
        if (this._slideImage != null) {
            ImageManager imageManager = ImageManager.getInstance();
            imageManager.putImage(this._slide, this._slideImage);
        }
        this._slide = null;
        this._slideImage = null;
    }

    public String getSlide() {
        return this._slide;
    }

    public Image getSlideImage() {
        return this._slideImage;
    }

    public void playBGM(String string, String string2, boolean bl) {
        this._audioPlayer.playBGM(string, string2, bl);
    }

    public void stopBGM(String string) {
        this._audioPlayer.stop(string);
    }

    public void stopSE(String string) {
        this._audioPlayer.stop(string);
    }

    public void playSE(String string, String string2, boolean bl) {
        this._audioPlayer.playSE(string, string2, bl);
    }

    public void setAudioPlayer(AudioPlayer audioPlayer) {
        this._audioPlayer = audioPlayer;
    }

    public AudioPlayer getAudioPlayer() {
        return this._audioPlayer;
    }

    void setStageCanvas(StageCanvas stageCanvas) {
        this._canvas = stageCanvas;
    }

    public StageCanvas getStageCanvas() {
        return this._canvas;
    }

    public void updateCanvas() {
        this._canvas.updateCanvas(null);
    }

    public void updateCanvas(String string) {
        if (this._canvas != null) {
            Logger.debug("[canvas.stage] effect :" + string);
            this._canvas.updateCanvas(string);
        }
    }

    public void commit() {
        this._committedActors.clear();
        this._committedActors.putAll(this._actors);
        this._committedBackground = this._background;
        this._committedBackgroundColor = this._backgroundColor;
        this._committedSlide = this._slide;
    }

    void dispose() {
        Iterator iterator = this._actors.values().iterator();
        while (iterator.hasNext()) {
            ((Actor)iterator.next()).disposeLooks();
        }
        if (this._backgroundImage != null) {
            ImageManager imageManager = ImageManager.getInstance();
            imageManager.putImage(this._background, this._backgroundImage);
        }
        this._audioPlayer.stopAll();
    }

    public void prepare() {
        if (this._actors == null) {
            this._actors = (Map)this._committedActors.clone();
        }
        Iterator iterator = this._actors.values().iterator();
        while (iterator.hasNext()) {
            ((Actor)iterator.next()).prepare();
        }
        if (this._committedBackgroundColor == null) {
            this.setBackgroundImage(this._committedBackground);
        } else {
            this._background = this._committedBackground;
            this._backgroundColor = this._committedBackgroundColor;
        }
        if (this._committedSlide != null) {
            this.showSlide(this._committedSlide);
        }
        this.updateCanvas();
    }
}

