/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage.audio;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javazoom.jlme.decoder.BitStream;
import javazoom.jlme.decoder.Decoder;
import javazoom.jlme.decoder.Header;
import javazoom.jlme.decoder.SampleBuffer;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.stage.AudioClip;

public class MP3AudioClip
extends AudioClip
implements Runnable {
    private int _bufferSize = 1024;
    private Thread _thread = null;
    private boolean _running = false;
    private BitStream _bitstream = null;
    private Decoder _decoder = null;
    private SourceDataLine _line = null;
    private FloatControl _gainControl = null;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public MP3AudioClip(String string, URL uRL) {
        super(string, uRL);
    }

    protected void prepare() throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getClipURL().openStream(), this._bufferSize);
        this._bitstream = new BitStream(bufferedInputStream);
        this._decoder = new Decoder(this._bitstream.readFrame(), this._bitstream);
    }

    public void play() {
        if (this._thread != null) {
            return;
        }
        try {
            this.prepare();
        }
        catch (Exception exception) {
            Logger.error("[canvas.stage.audio] fail to play.", (Throwable)exception);
            return;
        }
        this._thread = new Thread(this);
        this._thread.start();
    }

    public void stop() {
        Logger.debug("[canvas.audio] stop clip " + this.getID());
        if (this._gainControl != null) {
            this._gainControl.setValue(this._gainControl.getMinimum());
        }
        this._running = false;
        try {
            this._thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._thread = null;
    }

    public void run() {
        boolean bl = true;
        int n = 0;
        Header header = null;
        this._running = true;
        while (this._running) {
            try {
                SampleBuffer sampleBuffer = this._decoder.decodeFrame();
                n = sampleBuffer.size();
                if (n == 0) {
                    if (!this.isLoop()) break;
                    this._bitstream.closeFrame();
                    this._bitstream.close();
                    this.prepare();
                    continue;
                }
                if (bl) {
                    FloatControl floatControl;
                    bl = false;
                    Logger.debug("[canvas.stage.audio] frequency: " + this._decoder.getOutputFrequency() + ", channels: " + this._decoder.getOutputChannels());
                    AudioFormat audioFormat = new AudioFormat(this._decoder.getOutputFrequency(), 16, this._decoder.getOutputChannels(), true, false);
                    DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? MP3AudioClip.class$("javax.sound.sampled.SourceDataLine") : class$javax$sound$sampled$SourceDataLine, audioFormat);
                    if (!AudioSystem.isLineSupported(info)) {
                        throw new LineUnavailableException("sorry, the sound format cannot be played");
                    }
                    this._line = (SourceDataLine)AudioSystem.getLine(info);
                    this._gainControl = floatControl = (FloatControl)this._line.getControl(FloatControl.Type.MASTER_GAIN);
                    this._line.open(audioFormat);
                    this._line.start();
                }
                if (this._running) {
                    this._line.write(sampleBuffer.getBuffer(), 0, n);
                }
                this._bitstream.closeFrame();
                header = this._bitstream.readFrame();
            }
            catch (Exception exception) {
                Logger.debug("\u306a\u3093\u304b\u30a8\u30e9\u30fc", exception);
                break;
            }
        }
        this._running = false;
        try {
            this._bitstream.close();
            this._bitstream = null;
            this._decoder = null;
        }
        catch (Exception exception) {
            Logger.warn("[canvas.stage.audio] fail to close bit stream.", (Throwable)exception);
        }
        this._running = false;
        this._thread = null;
        Logger.debug("[canvas.audio] playing data \"" + this.getClipURL() + "\" was finished.");
        this.playingFinished();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

