/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.text;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.Serializable;
import java.text.AttributedString;
import tsukuba_bunko.peko.canvas.text.Page;

public class Line
implements Serializable {
    private transient TextLayout _textLayout = null;
    private transient Shape _shape = null;
    private float _lineSpan = 0.0f;
    private Color _foreground = null;
    private Color _shadowColor = Color.black;
    private String _text = null;

    public void setForeground(Color color) {
        this._foreground = color;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void setShadowColor(Color color) {
        this._shadowColor = color;
    }

    public Color getShadowColor() {
        return this._shadowColor;
    }

    public void setText(String string) {
        this._text = string;
    }

    public String getText() {
        return this._text;
    }

    public void setTextLayout(TextLayout textLayout) {
        this._textLayout = textLayout;
        this._shape = textLayout.getOutline(null);
    }

    public TextLayout getTextLayout() {
        return this._textLayout;
    }

    public void setLineSpan(float f) {
        this._lineSpan = f;
    }

    public float getLineSpan() {
        return this._lineSpan;
    }

    public float getAscent() {
        return this._textLayout.getAscent() + this._lineSpan;
    }

    public float getDescent() {
        return this._textLayout.getDescent();
    }

    public float getAdavance() {
        return this._textLayout.getAdvance();
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.translate((int)f + 2, (int)f2 + 2);
        if (this._shadowColor == null) {
            graphics2D2.setColor(Color.black);
        } else {
            graphics2D2.setColor(this._shadowColor);
        }
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D2.fill(this._shape);
        Color color = graphics2D.getColor();
        if (this._foreground != null) {
            graphics2D.setColor(this._foreground);
        }
        this._textLayout.draw(graphics2D, f, f2);
        graphics2D.setColor(color);
    }

    public void prepare(Page page) {
        if (this._textLayout == null) {
            AttributedString attributedString = new AttributedString(this._text);
            attributedString.addAttribute(TextAttribute.FONT, page.getDefaultFont());
            attributedString.addAttribute(TextAttribute.FOREGROUND, page.getForeground());
            this.setTextLayout(new TextLayout(attributedString.getIterator(), page.getFontRenderContext()));
        }
    }
}

