/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.text;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.canvas.text.Line;
import tsukuba_bunko.peko.canvas.text.Marker;
import tsukuba_bunko.peko.canvas.text.Page;

public class TextCanvas
extends JComponent {
    private Page _page = null;
    private List _lines = null;
    private AlphaComposite _alphaComposite = AlphaComposite.getInstance(4, 0.5f);
    private Dimension _size = new Dimension();
    private Point _location = new Point(0, 0);
    private Insets _padding = new Insets(0, 0, 0, 0);
    private FontRenderContext _frc = null;
    private Marker _marker = null;

    public TextCanvas() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontRenderContext getFontRenderContext() {
        if (this._frc == null) {
            TextCanvas textCanvas = this;
            synchronized (textCanvas) {
                if (this._frc == null) {
                    try {
                        Logger.debug("[canvas.text] waiting for create cached FontRenderContext.");
                        this.wait();
                        Logger.debug("[canvas.text] creating cached FontRenderContext done.");
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.error("[canvas.text] interrupted.");
                    }
                }
            }
        }
        return this._frc;
    }

    public AlphaComposite getAlphaComposite() {
        return this._alphaComposite;
    }

    public void updateCanvas() {
        if (!this.isEnabled()) {
            return;
        }
        Logger.debug("[canvas.text] update TextCanvas view");
        this._lines = null;
        this._page.getSize(this._size);
        this._page.getLocation(this._location);
        this._page.getPadding(this._padding);
        this.setForeground(this._page.getForeground());
        this.setBackground(this._page.getBackground());
        float f = this._page.getTransparency();
        if (this._alphaComposite == null || this._alphaComposite.getAlpha() != f) {
            this._alphaComposite = AlphaComposite.getInstance(3, f);
        }
        this._marker.setText("\u25bc", this._page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateText() {
        if (!this.isEnabled()) {
            return;
        }
        Logger.debug("[canvas.text] update texts.");
        this._marker.setVisible(false);
        List list = this._page.getLines();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ((Line)list.get(i)).prepare(this._page);
        }
        this._lines = list;
        PekoSystem.getInstance().getCanvasManager().showTextCanvas();
        this.repaint();
        try {
            TextCanvas textCanvas = this;
            synchronized (textCanvas) {
                this.wait(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._marker.setVisible(true);
    }

    public void setPage(Page page) {
        this._page = page;
        this._page.setTextCanvas(this);
    }

    public Page getPage() {
        return this._page;
    }

    public void paintPageBackground(Graphics graphics) {
        Dimension dimension = this._size;
        Point point = this._location;
        Graphics2D graphics2D = (Graphics2D)graphics.create(point.x, point.y, dimension.width, dimension.height);
        graphics2D.setComposite(this._alphaComposite);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.dispose();
    }

    private void initialize() {
        this.setLayout(null);
        this.setDoubleBuffered(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this._marker = new Marker();
        this.add(this._marker);
        this._marker.setLocation(0, 0);
        this._marker.setVisible(false);
    }

    public void setVisible(boolean bl) {
        Logger.debug("[canvas.text] set visibility :" + bl);
        if (bl) {
            this._marker.start();
        }
        super.setVisible(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        super.addNotify();
        Logger.debug("[canvas.text] added notify to TextCavas");
        if (this._frc == null) {
            Logger.debug("[canvas.text] try create new font render context.");
            TextCanvas textCanvas = this;
            synchronized (textCanvas) {
                if (this._frc == null) {
                    Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    this._frc = graphics2D.getFontRenderContext();
                    Logger.debug("[canvas] notify all thread waiting at TextCanvas");
                    this.notifyAll();
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        List list = this._lines;
        if (list == null || list.isEmpty()) {
            return;
        }
        super.paint(graphics);
    }

    public void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, this._location.x, this._location.y, this._size.width, this._size.height);
        }
    }

    public void paintComponent(Graphics graphics) {
        List list = this._lines;
        Dimension dimension = this._size;
        Point point = this._location;
        Insets insets = this._padding;
        Graphics2D graphics2D = (Graphics2D)graphics;
        float f = point.x + insets.left;
        float f2 = point.y + insets.top;
        float f3 = 0.0f;
        int n = list.size();
        Line line = null;
        for (int i = 0; i < n; ++i) {
            line = (Line)list.get(i);
            line.draw(graphics2D, f, f2 += line.getAscent());
            f2 += line.getDescent();
            f3 = line.getAdavance();
        }
        this._marker.setPosition((int)(f3 + 5.0f + f), (int)f2);
    }
}

