/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario;

import java.util.HashMap;
import java.util.Map;
import tsukuba_bunko.peko.scenario.ElementHandler;
import tsukuba_bunko.peko.scenario.select.SelectHandler;
import tsukuba_bunko.peko.scenario.stage.ActorHandler;
import tsukuba_bunko.peko.scenario.stage.AtOnceHandler;
import tsukuba_bunko.peko.scenario.stage.BackgroundHandler;
import tsukuba_bunko.peko.scenario.stage.SlideHandler;
import tsukuba_bunko.peko.scenario.stage.SoundHandler;
import tsukuba_bunko.peko.scenario.structure.HeadHandler;
import tsukuba_bunko.peko.scenario.text.NewPageHandler;
import tsukuba_bunko.peko.scenario.text.ParagraphHandler;
import tsukuba_bunko.peko.scenario.util.FlagHandler;
import tsukuba_bunko.peko.scenario.util.SceneFlowHandler;
import tsukuba_bunko.peko.scenario.util.WaitHandler;

public class HandlerRegistry {
    private Map _registry = new HashMap(89);

    public void register(String string, ElementHandler elementHandler) {
        this.register("http://tsukuba-bunko.org/ns/psml-scene", string, elementHandler);
    }

    public void register(String string, String string2, ElementHandler elementHandler) {
        Map map = this.getElementHandlers(string);
        map.put(string2, elementHandler);
    }

    public void unregister(String string) {
        this.unregister("http://tsukuba-bunko.org/ns/psml-scene", string);
    }

    public void unregister(String string, String string2) {
        Map map = this.getElementHandlers(string);
        map.remove(string2);
    }

    public ElementHandler getElementHandler(String string) {
        return this.getElementHandler("http://tsukuba-bunko.org/ns/psml-scene", string);
    }

    public ElementHandler getElementHandler(String string, String string2) {
        Map map = this.getElementHandlers(string);
        return (ElementHandler)map.get(string2);
    }

    private Map getElementHandlers(String string) {
        HashMap hashMap = (HashMap)this._registry.get(string);
        if (hashMap == null) {
            hashMap = new HashMap(89);
            this._registry.put(string, hashMap);
        }
        return hashMap;
    }

    public static HandlerRegistry newInstance() {
        HandlerRegistry handlerRegistry = new HandlerRegistry();
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "select", new SelectHandler());
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "flag", new FlagHandler());
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "wait", new WaitHandler());
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "scene-flow", new SceneFlowHandler());
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "np", new NewPageHandler());
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "p", new ParagraphHandler());
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "head", new HeadHandler());
        ActorHandler actorHandler = new ActorHandler();
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "enter", actorHandler);
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "action", actorHandler);
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "exit", actorHandler);
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "background", new BackgroundHandler());
        SlideHandler slideHandler = new SlideHandler();
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "show-slide", slideHandler);
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "hide-slide", slideHandler);
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "at-once", new AtOnceHandler());
        SoundHandler soundHandler = new SoundHandler();
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "play-bgm", soundHandler);
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "stop-bgm", soundHandler);
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "play-se", soundHandler);
        handlerRegistry.register("http://tsukuba-bunko.org/ns/psml-scene", "stop-se", soundHandler);
        return handlerRegistry;
    }
}

