/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.text;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.scenario.FlagScope;
import tsukuba_bunko.peko.scenario.PSMLUtil;
import tsukuba_bunko.peko.scenario.text.TextCoordinator;
import tsukuba_bunko.peko.scenario.text.TextElementHandler;
import tsukuba_bunko.peko.scenario.util.WaitHandler;

public class ParagraphHandler
extends TextElementHandler {
    private StringBuffer _text = null;
    private String _flagID = null;
    private WaitHandler _waitHandler = new WaitHandler();

    private boolean performParagraph() {
        TextCoordinator textCoordinator = this.getTextCoordinator();
        String string = new String(this._text);
        if (string.length() > 0) {
            textCoordinator.pushText(new String(this._text));
            this._text = new StringBuffer(48);
            return true;
        }
        return false;
    }

    public void startDocument() {
        Logger.debug("[scene] start paragraph");
        this._text = new StringBuffer(48);
        this._flagID = null;
        this.getTextCoordinator().begin();
    }

    public void endDocument() {
        Logger.debug("[scene] end paragraph");
        if (this.performParagraph()) {
            this.stop();
        }
        this._text = null;
        this.getTextCoordinator().commit();
        if (this._flagID != null) {
            this.getSceneContext().declareFlag(this._flagID, FlagScope.SESSION);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("wait")) {
            this.performParagraph();
            this._waitHandler.waitFor(attributes);
        } else if (string2.equals("p")) {
            this._flagID = PSMLUtil.getAttributeValue(attributes, "flag");
        }
    }

    public void endElement(String string, String string2, String string3) {
    }

    public void characters(char[] cArray, int n, int n2) {
        this._text.append(cArray, n, n2);
    }
}

