/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.session;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.scenario.SceneContext;

public class Session
implements Serializable {
    protected HashSet _sessionFlags = null;
    protected HashSet _systemFlags = null;
    protected Date _timestamp = null;
    protected SceneContext _sceneContext = null;
    protected HashMap _attributes = new HashMap(17);
    protected transient Thread _activeThread = null;

    public synchronized void setSceneContext(SceneContext sceneContext, Thread thread) {
        this._sceneContext = sceneContext;
        this._activeThread = thread;
    }

    public void setSceneContext(SceneContext sceneContext) {
        this.setSceneContext(sceneContext, Thread.currentThread());
    }

    public SceneContext getSceneContext() {
        return this._sceneContext;
    }

    public void declareSessionFlag(String string) {
        Logger.debug("[session] declare session flag: " + string);
        if (this.isActiveThread()) {
            this._sessionFlags.add(string);
        } else {
            Logger.debug("[session] canceled declaring session flag: " + string);
        }
    }

    public void undeclareSessionFlag(String string) {
        Logger.debug("[session] undeclare session flag: " + string);
        if (this.isActiveThread()) {
            this._sessionFlags.remove(string);
        } else {
            Logger.debug("[session] canceled undeclaring session flag: " + string);
        }
    }

    public boolean isDeclaredSessionFlag(String string) {
        return this._sessionFlags.contains(string);
    }

    public void declareSystemFlag(String string) {
        Logger.debug("[session] declare system flag: " + string);
        if (this.isActiveThread()) {
            this._systemFlags.add(string);
        } else {
            Logger.debug("[session] canceled declaring system flag: " + string);
        }
    }

    public void undeclareSystemFlag(String string) {
        Logger.debug("[session] undeclare system flag: " + string);
        if (this.isActiveThread()) {
            this._systemFlags.remove(string);
        } else {
            Logger.debug("[session] canceled undeclaring system flag: " + string);
        }
    }

    public boolean isDeclaredSystemFlag(String string) {
        return this._systemFlags.contains(string);
    }

    public void setSessionFlagSet(HashSet hashSet) {
        this._sessionFlags = hashSet;
    }

    public HashSet getSessionFlagSet() {
        return this._sessionFlags;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void setSystemFlagSet(HashSet hashSet, Date date) {
        if (this._timestamp == null || this._timestamp.before(date)) {
            this._systemFlags = hashSet;
            this._timestamp = date;
        }
    }

    public HashSet getSystemFlagSet() {
        return this._systemFlags;
    }

    public void setSessionAttribute(String string, Serializable serializable) {
        this._attributes.put(string, serializable);
    }

    public Object getSessionAttribute(String string) {
        return this._attributes.get(string);
    }

    protected boolean isActiveThread() {
        return this._activeThread == Thread.currentThread();
    }
}

