/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JOptionPane;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.session.LoadFailureException;
import tsukuba_bunko.peko.session.MessageIDs;
import tsukuba_bunko.peko.session.SaveData;
import tsukuba_bunko.peko.session.SaveDataDialog;
import tsukuba_bunko.peko.session.SaveDataInfo;
import tsukuba_bunko.peko.session.SaveFailureException;
import tsukuba_bunko.peko.session.Session;
import tsukuba_bunko.peko.session.SystemSaveData;

public class SessionManager {
    protected static final DecimalFormat FORMAT = new DecimalFormat("000");
    protected int _lastIndex = -1;
    protected SystemSaveData _systemSaveData = null;
    protected Session _session = null;

    public SessionManager() {
        try {
            this._systemSaveData = this.loadSystemSaveData();
        }
        catch (Exception exception) {
            Logger.debug("[session.manager] fail to load SystemSaveData.", exception);
        }
        this._session = new Session();
        this._session.setSessionFlagSet(new HashSet(89));
        if (this._systemSaveData != null) {
            this._session.setSystemFlagSet(this._systemSaveData.getSystemFlagSet(), this._systemSaveData.getSaveDataInfo().getTimestamp());
        } else {
            this._systemSaveData = new SystemSaveData();
            SaveDataInfo saveDataInfo = new SaveDataInfo();
            saveDataInfo.setID(-1);
            saveDataInfo.setTitle("PVNS System Save Data");
            this._systemSaveData.setSaveDataInfo(saveDataInfo);
            this._session.setSystemFlagSet(new HashSet(89), null);
        }
    }

    public void initializeSession() {
        this._session.setSessionFlagSet(new HashSet(89));
        this._session.setSceneContext(null);
    }

    public Session getSession() {
        return this._session;
    }

    public SystemSaveData getSystemSaveData() {
        return this._systemSaveData;
    }

    public void saveCurrentSession() throws SaveFailureException {
        SaveData saveData = new SaveData();
        SaveDataInfo saveDataInfo = new SaveDataInfo();
        saveDataInfo.setTitle(this._session.getSceneContext().getSceneTitle());
        saveData.setSaveDataInfo(saveDataInfo);
        saveData.setSession(this._session);
        this.save(saveData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected SaveDataInfo[] getSaveDataInfoList(int n, int n2) {
        SaveDataInfo[] saveDataInfoArray = new SaveDataInfo[n2];
        File file = null;
        SaveData saveData = null;
        SaveDataInfo saveDataInfo = null;
        Object object = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        for (int i = 0; i < saveDataInfoArray.length; ++i) {
            block23: {
                Exception exception2222;
                Object var13_12;
                block22: {
                    block21: {
                        file = this.getSaveFile(i + n);
                        if (!file.isFile()) continue;
                        fileInputStream = new FileInputStream(file);
                        objectInputStream = new ObjectInputStream(fileInputStream);
                        object = objectInputStream.readObject();
                        var13_12 = null;
                        if (objectInputStream == null) break block21;
                        try {
                            objectInputStream.close();
                        }
                        catch (Exception exception2222) {
                            Logger.warn(MessageIDs.SAV0004W, (Throwable)exception2222);
                        }
                        break block22;
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception2222) {
                            Logger.warn(MessageIDs.SAV0004W, (Throwable)exception2222);
                        }
                    }
                }
                objectInputStream = null;
                fileInputStream = null;
                {
                    break block23;
                    catch (Exception exception3) {
                        Logger.warn(MessageIDs.SAV0008W, new Object[]{String.valueOf(i + n)}, exception3);
                        var13_12 = null;
                        if (objectInputStream != null) {
                            try {
                                objectInputStream.close();
                            }
                            catch (Exception exception2222) {
                                Logger.warn(MessageIDs.SAV0004W, (Throwable)exception2222);
                            }
                        } else if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Exception exception2222) {
                                Logger.warn(MessageIDs.SAV0004W, (Throwable)exception2222);
                            }
                        }
                        objectInputStream = null;
                        fileInputStream = null;
                    }
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (Exception exception2222) {
                            Logger.warn(MessageIDs.SAV0004W, (Throwable)exception2222);
                        }
                    } else if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception2222) {
                            Logger.warn(MessageIDs.SAV0004W, (Throwable)exception2222);
                        }
                    }
                    objectInputStream = null;
                    fileInputStream = null;
                    throw throwable;
                }
            }
            if (!(object instanceof SaveData)) continue;
            saveData = (SaveData)object;
            if (saveData != null) {
                saveDataInfo = saveData.getSaveDataInfo();
                if (saveDataInfo == null || saveDataInfo.getTitle() == null || saveDataInfo.getTimestamp() == null) continue;
                saveDataInfoArray[i] = saveDataInfo;
                continue;
            }
            Logger.warn(MessageIDs.SAV0022W, new Object[]{String.valueOf(i)});
        }
        return saveDataInfoArray;
    }

    /*
     * Loose catch block
     */
    protected void save(SaveData saveData) throws SaveFailureException {
        block16: {
            ObjectOutputStream objectOutputStream;
            FileOutputStream fileOutputStream;
            block15: {
                SaveDataInfo[] saveDataInfoArray = this.getSaveDataInfoList(0, 20);
                int n = SaveDataDialog.showDialog(saveDataInfoArray, this.getInitialSelectedIndexForSave(saveDataInfoArray), true);
                Logger.debug("index: " + n);
                if (n == -1) {
                    return;
                }
                saveData.getSaveDataInfo().setID(n);
                Date date = new Date();
                saveData.getSaveDataInfo().setTimestamp(date);
                fileOutputStream = null;
                objectOutputStream = null;
                File file = this.getSaveFile(saveData.getSaveDataInfo().getID());
                Logger.debug("save to " + file.getAbsolutePath());
                fileOutputStream = new FileOutputStream(file);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(saveData);
                objectOutputStream.flush();
                this._lastIndex = n;
                Object var10_9 = null;
                if (objectOutputStream == null) break block15;
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    Logger.warn(MessageIDs.SAV0002W, (Throwable)exception);
                }
                break block16;
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    Logger.warn(MessageIDs.SAV0002W, (Throwable)exception);
                }
            }
            break block16;
            {
                catch (Exception exception) {
                    Logger.error(MessageIDs.SAV0001E, new Object[]{String.valueOf(saveData.getSaveDataInfo().getID())}, exception);
                    SaveFailureException saveFailureException = new SaveFailureException("fail to save.", exception);
                    throw saveFailureException;
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (Exception exception) {
                        Logger.warn(MessageIDs.SAV0002W, (Throwable)exception);
                    }
                } else if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        Logger.warn(MessageIDs.SAV0002W, (Throwable)exception);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load() throws LoadFailureException {
        boolean bl;
        FileInputStream fileInputStream;
        block20: {
            int n;
            SaveDataInfo[] saveDataInfoArray = this.getSaveDataInfoList(0, 20);
            boolean bl2 = false;
            if (saveDataInfoArray != null) {
                bl2 = true;
                for (n = 0; n < saveDataInfoArray.length; ++n) {
                    if (saveDataInfoArray[n] == null) continue;
                    bl2 = false;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                String string;
                ResourceManager resourceManager = ResourceManager.getInstance();
                String string2 = (String)resourceManager.getResource("peko.savedata-chooser.dialog.notify-nodata.title");
                if (string2 == null) {
                    Logger.warn(MessageIDs.SAV0020W);
                }
                if ((string = (String)resourceManager.getResource("peko.savedata-chooser.dialog.notify-nodata.message")) == null) {
                    string = "No save data for loading.";
                    Logger.warn(MessageIDs.SAV0021W, new Object[]{"\"" + string + "\""});
                }
                JOptionPane.showMessageDialog(PekoSystem.getInstance().getMainWindow(), string, string2, 1);
                return false;
            }
            n = SaveDataDialog.showDialog(saveDataInfoArray, this.getInitialSelectedIndexForLoad(saveDataInfoArray), false);
            if (n == -1) {
                return false;
            }
            File file = this.getSaveFile(n);
            if (!file.exists()) {
                Logger.error(MessageIDs.SAV0005E, new Object[]{String.valueOf(n)});
                LoadFailureException loadFailureException = new LoadFailureException("no such save file");
                throw loadFailureException;
            }
            fileInputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    objectInputStream = new ObjectInputStream(fileInputStream);
                    SaveData saveData = (SaveData)objectInputStream.readObject();
                    Session session = saveData.getSession();
                    session.setSystemFlagSet(this._session.getSystemFlagSet(), this._session.getTimestamp());
                    this._session = session;
                    this._lastIndex = n;
                    bl = true;
                    Object var11_16 = null;
                    if (objectInputStream == null) break block20;
                }
                catch (Exception exception) {
                    Logger.error(MessageIDs.SAV0003E, new Object[]{String.valueOf(String.valueOf(n))}, exception);
                    LoadFailureException loadFailureException = new LoadFailureException("fail to load.", exception);
                    throw loadFailureException;
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception2) {
                        Logger.warn(MessageIDs.SAV0004W, (Throwable)exception2);
                        throw throwable;
                    }
                }
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (Exception exception3) {
                    Logger.warn(MessageIDs.SAV0004W, (Throwable)exception3);
                    throw throwable;
                }
            }
            try {}
            catch (Exception exception) {
                Logger.warn(MessageIDs.SAV0004W, (Throwable)exception);
                return bl;
            }
            objectInputStream.close();
            return bl;
        }
        if (fileInputStream == null) return bl;
        try {}
        catch (Exception exception) {
            Logger.warn(MessageIDs.SAV0004W, (Throwable)exception);
            return bl;
        }
        fileInputStream.close();
        return bl;
    }

    /*
     * Loose catch block
     */
    public void saveSystemSaveData() throws SaveFailureException {
        block15: {
            ObjectOutputStream objectOutputStream;
            FileOutputStream fileOutputStream;
            block14: {
                Logger.debug("save SystemSaveData.");
                SystemSaveData systemSaveData = this._systemSaveData;
                systemSaveData.setSystemFlagSet(this._session.getSystemFlagSet());
                fileOutputStream = null;
                objectOutputStream = null;
                systemSaveData.getSaveDataInfo().setTimestamp(new Date());
                File file = this.getSystemSaveFile();
                fileOutputStream = new FileOutputStream(file);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(systemSaveData);
                objectOutputStream.flush();
                Object var7_6 = null;
                if (objectOutputStream == null) break block14;
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    Logger.warn(MessageIDs.SAV0002W, (Throwable)exception);
                }
                break block15;
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    Logger.warn(MessageIDs.SAV0002W, (Throwable)exception);
                }
            }
            break block15;
            {
                catch (Exception exception) {
                    Logger.error(MessageIDs.SAV0006F, (Throwable)exception);
                    SaveFailureException saveFailureException = new SaveFailureException("fail to save system save data.", exception);
                    throw saveFailureException;
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (Exception exception) {
                        Logger.warn(MessageIDs.SAV0002W, (Throwable)exception);
                    }
                } else if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        Logger.warn(MessageIDs.SAV0002W, (Throwable)exception);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public SystemSaveData loadSystemSaveData() throws LoadFailureException {
        SystemSaveData systemSaveData;
        block16: {
            ObjectInputStream objectInputStream;
            FileInputStream fileInputStream;
            block15: {
                systemSaveData = null;
                File file = this.getSystemSaveFile();
                if (!file.exists()) {
                    return null;
                }
                fileInputStream = null;
                objectInputStream = null;
                fileInputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(fileInputStream);
                systemSaveData = (SystemSaveData)objectInputStream.readObject();
                Object var8_5 = null;
                if (objectInputStream == null) break block15;
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {
                    Logger.warn(MessageIDs.SAV0004W, (Throwable)exception);
                }
                break block16;
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    Logger.warn(MessageIDs.SAV0004W, (Throwable)exception);
                }
            }
            break block16;
            {
                catch (Exception exception) {
                    Logger.fatal(MessageIDs.SAV0006F, (Throwable)exception);
                    LoadFailureException loadFailureException = new LoadFailureException("fail to load.", exception);
                    throw loadFailureException;
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (Exception exception) {
                        Logger.warn(MessageIDs.SAV0004W, (Throwable)exception);
                    }
                } else if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        Logger.warn(MessageIDs.SAV0004W, (Throwable)exception);
                    }
                }
                throw throwable;
            }
        }
        return systemSaveData;
    }

    protected File getSaveFile(int n) {
        ResourceManager resourceManager = ResourceManager.getInstance();
        return new File(resourceManager.getLocationResources().getSaveDirectory(), "save" + FORMAT.format(new Integer(n)) + ".dat");
    }

    protected File getSystemSaveFile() {
        ResourceManager resourceManager = ResourceManager.getInstance();
        return new File(resourceManager.getLocationResources().getSaveDirectory(), "config.dat");
    }

    protected int getInitialSelectedIndexForSave(SaveDataInfo[] saveDataInfoArray) {
        if (saveDataInfoArray == null || saveDataInfoArray.length == 0) {
            throw new IllegalArgumentException("void list is specified.");
        }
        int n = 0;
        SaveDataInfo saveDataInfo = null;
        for (int i = 0; i < saveDataInfoArray.length; ++i) {
            saveDataInfo = saveDataInfoArray[i];
            if (saveDataInfo == null) {
                n = i;
                break;
            }
            if (saveDataInfoArray[n] != null && !saveDataInfo.getTimestamp().before(saveDataInfoArray[n].getTimestamp())) continue;
            n = i;
        }
        return n;
    }

    protected int getInitialSelectedIndexForLoad(SaveDataInfo[] saveDataInfoArray) {
        if (saveDataInfoArray == null || saveDataInfoArray.length == 0) {
            throw new IllegalArgumentException("void list is specified.");
        }
        if (this._lastIndex != -1) {
            return this._lastIndex;
        }
        int n = 0;
        SaveDataInfo saveDataInfo = null;
        for (int i = 0; i < saveDataInfoArray.length; ++i) {
            saveDataInfo = saveDataInfoArray[i];
            if (saveDataInfo == null || saveDataInfoArray[n] != null && !saveDataInfo.getTimestamp().after(saveDataInfoArray[n].getTimestamp())) continue;
            n = i;
        }
        return n;
    }
}

