/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.resource;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import tsukuba_bunko.resource.BasicDeserializer;
import tsukuba_bunko.resource.ResourceDeserializer;

public class ListDeserializer
extends BasicDeserializer {
    private List _list = null;
    private ResourceDeserializer _itemDeserializer = null;
    private ContentHandler _itemHandler = null;
    private String _itemType = null;
    private int _level = 0;

    public void setTypeName(String string) {
        super.setTypeName(string);
        int n = string.indexOf(47);
        if (n == -1) {
            throw new IllegalArgumentException("illegal list item type. \"" + string + "\"");
        }
        this._itemType = string.substring(n + 1);
    }

    public void startDocument() {
        this._list = null;
        this._level = 0;
    }

    public void endDocument() {
        this.setValue(this._list);
        this._list = null;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.startPrefixMapping(string, string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.endPrefixMapping(string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this._list == null) {
            this._list = new ArrayList();
            this._itemDeserializer = this._mapping.getResourceDeserializer(this._itemType);
            if (this._itemDeserializer != null) return;
            throw new SAXException("no deserializer for \"" + this._itemType + "\"");
        }
        if (this._itemHandler == null) {
            if (!string2.equals("item")) throw new SAXException("illegal structure. : non-item element \"" + string3 + "\"");
            ++this._level;
            this._itemHandler = this._itemDeserializer;
            this._itemHandler.startElement(string, string2, string3, attributes);
            return;
        } else {
            ++this._level;
            this._itemHandler.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this._itemHandler != null) {
                --this._level;
                this._itemHandler.endElement(string, string2, string3);
                if (this._level == 0) {
                    this._list.add(this._itemDeserializer.getValue());
                    this._itemHandler = null;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.processingInstruction(string, string2);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.skippedEntity(string);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.ignorableWhitespace(cArray, n, n2);
        }
    }
}

